/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateCacheClusterRequestMarshaller
implements Marshaller<Request<CreateCacheClusterRequest>, CreateCacheClusterRequest> {
    public Request<CreateCacheClusterRequest> marshall(CreateCacheClusterRequest createCacheClusterRequest) {
        SdkInternalList snapshotArnsList;
        SdkInternalList tagsList;
        SdkInternalList securityGroupIdsList;
        SdkInternalList cacheSecurityGroupNamesList;
        SdkInternalList preferredAvailabilityZonesList;
        if (createCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCacheClusterRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCacheClusterRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)createCacheClusterRequest.cacheClusterId()));
        }
        if (createCacheClusterRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)createCacheClusterRequest.replicationGroupId()));
        }
        if (createCacheClusterRequest.azMode() != null) {
            request.addParameter("AZMode", StringUtils.fromString((String)createCacheClusterRequest.azMode()));
        }
        if (createCacheClusterRequest.preferredAvailabilityZone() != null) {
            request.addParameter("PreferredAvailabilityZone", StringUtils.fromString((String)createCacheClusterRequest.preferredAvailabilityZone()));
        }
        if (!(preferredAvailabilityZonesList = (SdkInternalList)createCacheClusterRequest.preferredAvailabilityZones()).isEmpty() || !preferredAvailabilityZonesList.isAutoConstruct()) {
            int preferredAvailabilityZonesListIndex = 1;
            for (Object preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                if (preferredAvailabilityZonesListValue != null) {
                    request.addParameter("PreferredAvailabilityZones.PreferredAvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString((String)preferredAvailabilityZonesListValue));
                }
                ++preferredAvailabilityZonesListIndex;
            }
        }
        if (createCacheClusterRequest.numCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringUtils.fromInteger((Integer)createCacheClusterRequest.numCacheNodes()));
        }
        if (createCacheClusterRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)createCacheClusterRequest.cacheNodeType()));
        }
        if (createCacheClusterRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createCacheClusterRequest.engine()));
        }
        if (createCacheClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createCacheClusterRequest.engineVersion()));
        }
        if (createCacheClusterRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)createCacheClusterRequest.cacheParameterGroupName()));
        }
        if (createCacheClusterRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)createCacheClusterRequest.cacheSubnetGroupName()));
        }
        if (!(cacheSecurityGroupNamesList = (SdkInternalList)createCacheClusterRequest.cacheSecurityGroupNames()).isEmpty() || !cacheSecurityGroupNamesList.isAutoConstruct()) {
            int cacheSecurityGroupNamesListIndex = 1;
            for (Object cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (!(securityGroupIdsList = (SdkInternalList)createCacheClusterRequest.securityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (Object securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (!(tagsList = (SdkInternalList)createCacheClusterRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (!(snapshotArnsList = (SdkInternalList)createCacheClusterRequest.snapshotArns()).isEmpty() || !snapshotArnsList.isAutoConstruct()) {
            int snapshotArnsListIndex = 1;
            for (String snapshotArnsListValue : snapshotArnsList) {
                if (snapshotArnsListValue != null) {
                    request.addParameter("SnapshotArns.SnapshotArn." + snapshotArnsListIndex, StringUtils.fromString((String)snapshotArnsListValue));
                }
                ++snapshotArnsListIndex;
            }
        }
        if (createCacheClusterRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)createCacheClusterRequest.snapshotName()));
        }
        if (createCacheClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createCacheClusterRequest.preferredMaintenanceWindow()));
        }
        if (createCacheClusterRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createCacheClusterRequest.port()));
        }
        if (createCacheClusterRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)createCacheClusterRequest.notificationTopicArn()));
        }
        if (createCacheClusterRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createCacheClusterRequest.autoMinorVersionUpgrade()));
        }
        if (createCacheClusterRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)createCacheClusterRequest.snapshotRetentionLimit()));
        }
        if (createCacheClusterRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)createCacheClusterRequest.snapshotWindow()));
        }
        if (createCacheClusterRequest.authToken() != null) {
            request.addParameter("AuthToken", StringUtils.fromString((String)createCacheClusterRequest.authToken()));
        }
        return request;
    }
}

