/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupStatus;

public class CacheParameterGroupStatusUnmarshaller
implements Unmarshaller<CacheParameterGroupStatus, StaxUnmarshallerContext> {
    private static CacheParameterGroupStatusUnmarshaller INSTANCE;

    public CacheParameterGroupStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CacheParameterGroupStatus.Builder cacheParameterGroupStatus = CacheParameterGroupStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheParameterGroupName", targetDepth)) {
                    cacheParameterGroupStatus.cacheParameterGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ParameterApplyStatus", targetDepth)) {
                    cacheParameterGroupStatus.parameterApplyStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeIdsToReboot", targetDepth)) {
                    cacheParameterGroupStatus.cacheNodeIdsToReboot(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("CacheNodeIdsToReboot/CacheNodeId", targetDepth)) continue;
                cacheParameterGroupStatus.cacheNodeIdsToReboot(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CacheParameterGroupStatus)cacheParameterGroupStatus.build();
    }

    public static CacheParameterGroupStatusUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheParameterGroupStatusUnmarshaller();
        }
        return INSTANCE;
    }
}

