/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticache.model.CacheCluster;
import software.amazon.awssdk.services.elasticache.model.CacheNode;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupMembership;
import software.amazon.awssdk.services.elasticache.transform.CacheNodeUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.CacheParameterGroupStatusUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.CacheSecurityGroupMembershipUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.EndpointUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.NotificationConfigurationUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.PendingModifiedValuesUnmarshaller;
import software.amazon.awssdk.services.elasticache.transform.SecurityGroupMembershipUnmarshaller;

public class CacheClusterUnmarshaller
implements Unmarshaller<CacheCluster, StaxUnmarshallerContext> {
    private static CacheClusterUnmarshaller INSTANCE;

    public CacheCluster unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CacheCluster.Builder cacheCluster = CacheCluster.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheClusterId", targetDepth)) {
                    cacheCluster.cacheClusterId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConfigurationEndpoint", targetDepth)) {
                    cacheCluster.configurationEndpoint(EndpointUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClientDownloadLandingPage", targetDepth)) {
                    cacheCluster.clientDownloadLandingPage(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeType", targetDepth)) {
                    cacheCluster.cacheNodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Engine", targetDepth)) {
                    cacheCluster.engine(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    cacheCluster.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheClusterStatus", targetDepth)) {
                    cacheCluster.cacheClusterStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NumCacheNodes", targetDepth)) {
                    cacheCluster.numCacheNodes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredAvailabilityZone", targetDepth)) {
                    cacheCluster.preferredAvailabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheClusterCreateTime", targetDepth)) {
                    cacheCluster.cacheClusterCreateTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                    cacheCluster.preferredMaintenanceWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PendingModifiedValues", targetDepth)) {
                    cacheCluster.pendingModifiedValues(PendingModifiedValuesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NotificationConfiguration", targetDepth)) {
                    cacheCluster.notificationConfiguration(NotificationConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheSecurityGroups", targetDepth)) {
                    cacheCluster.cacheSecurityGroups(new ArrayList<CacheSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("CacheSecurityGroups/CacheSecurityGroup", targetDepth)) {
                    cacheCluster.cacheSecurityGroups(CacheSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheParameterGroup", targetDepth)) {
                    cacheCluster.cacheParameterGroup(CacheParameterGroupStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheSubnetGroupName", targetDepth)) {
                    cacheCluster.cacheSubnetGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodes", targetDepth)) {
                    cacheCluster.cacheNodes(new ArrayList<CacheNode>());
                    continue;
                }
                if (context.testExpression("CacheNodes/CacheNode", targetDepth)) {
                    cacheCluster.cacheNodes(CacheNodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoMinorVersionUpgrade", targetDepth)) {
                    cacheCluster.autoMinorVersionUpgrade(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecurityGroups", targetDepth)) {
                    cacheCluster.securityGroups(new ArrayList<SecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("SecurityGroups/member", targetDepth)) {
                    cacheCluster.securityGroups(SecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReplicationGroupId", targetDepth)) {
                    cacheCluster.replicationGroupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SnapshotRetentionLimit", targetDepth)) {
                    cacheCluster.snapshotRetentionLimit(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SnapshotWindow", targetDepth)) continue;
                cacheCluster.snapshotWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CacheCluster)cacheCluster.build();
    }

    public static CacheClusterUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheClusterUnmarshaller();
        }
        return INSTANCE;
    }
}

