/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticache.model.CacheNodeIdsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RebootCacheClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RebootCacheClusterRequest> {
    private final String cacheClusterId;
    private final List<String> cacheNodeIdsToReboot;

    private RebootCacheClusterRequest(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.cacheNodeIdsToReboot = builder.cacheNodeIdsToReboot;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public List<String> cacheNodeIdsToReboot() {
        return this.cacheNodeIdsToReboot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheClusterId() == null ? 0 : this.cacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeIdsToReboot() == null ? 0 : this.cacheNodeIdsToReboot().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootCacheClusterRequest)) {
            return false;
        }
        RebootCacheClusterRequest other = (RebootCacheClusterRequest)((Object)obj);
        if (other.cacheClusterId() == null ^ this.cacheClusterId() == null) {
            return false;
        }
        if (other.cacheClusterId() != null && !other.cacheClusterId().equals(this.cacheClusterId())) {
            return false;
        }
        if (other.cacheNodeIdsToReboot() == null ^ this.cacheNodeIdsToReboot() == null) {
            return false;
        }
        return other.cacheNodeIdsToReboot() == null || other.cacheNodeIdsToReboot().equals(this.cacheNodeIdsToReboot());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.cacheNodeIdsToReboot() != null) {
            sb.append("CacheNodeIdsToReboot: ").append(this.cacheNodeIdsToReboot()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private List<String> cacheNodeIdsToReboot = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(RebootCacheClusterRequest model) {
            this.setCacheClusterId(model.cacheClusterId);
            this.setCacheNodeIdsToReboot(model.cacheNodeIdsToReboot);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final Collection<String> getCacheNodeIdsToReboot() {
            return this.cacheNodeIdsToReboot;
        }

        @Override
        public final Builder cacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToReboot(String ... cacheNodeIdsToReboot) {
            if (this.cacheNodeIdsToReboot == null) {
                this.cacheNodeIdsToReboot = new SdkInternalList(cacheNodeIdsToReboot.length);
            }
            for (String e : cacheNodeIdsToReboot) {
                this.cacheNodeIdsToReboot.add(e);
            }
            return this;
        }

        public final void setCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
        }

        @SafeVarargs
        public final void setCacheNodeIdsToReboot(String ... cacheNodeIdsToReboot) {
            if (this.cacheNodeIdsToReboot == null) {
                this.cacheNodeIdsToReboot = new SdkInternalList(cacheNodeIdsToReboot.length);
            }
            for (String e : cacheNodeIdsToReboot) {
                this.cacheNodeIdsToReboot.add(e);
            }
        }

        public RebootCacheClusterRequest build() {
            return new RebootCacheClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RebootCacheClusterRequest> {
        public Builder cacheClusterId(String var1);

        public Builder cacheNodeIdsToReboot(Collection<String> var1);

        public Builder cacheNodeIdsToReboot(String ... var1);
    }
}

