/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NodeGroupMember
implements ToCopyableBuilder<Builder, NodeGroupMember> {
    private final String cacheClusterId;
    private final String cacheNodeId;
    private final Endpoint readEndpoint;
    private final String preferredAvailabilityZone;
    private final String currentRole;

    private NodeGroupMember(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.cacheNodeId = builder.cacheNodeId;
        this.readEndpoint = builder.readEndpoint;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.currentRole = builder.currentRole;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String cacheNodeId() {
        return this.cacheNodeId;
    }

    public Endpoint readEndpoint() {
        return this.readEndpoint;
    }

    public String preferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public String currentRole() {
        return this.currentRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheClusterId() == null ? 0 : this.cacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeId() == null ? 0 : this.cacheNodeId().hashCode());
        hashCode = 31 * hashCode + (this.readEndpoint() == null ? 0 : this.readEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.preferredAvailabilityZone() == null ? 0 : this.preferredAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.currentRole() == null ? 0 : this.currentRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupMember)) {
            return false;
        }
        NodeGroupMember other = (NodeGroupMember)obj;
        if (other.cacheClusterId() == null ^ this.cacheClusterId() == null) {
            return false;
        }
        if (other.cacheClusterId() != null && !other.cacheClusterId().equals(this.cacheClusterId())) {
            return false;
        }
        if (other.cacheNodeId() == null ^ this.cacheNodeId() == null) {
            return false;
        }
        if (other.cacheNodeId() != null && !other.cacheNodeId().equals(this.cacheNodeId())) {
            return false;
        }
        if (other.readEndpoint() == null ^ this.readEndpoint() == null) {
            return false;
        }
        if (other.readEndpoint() != null && !other.readEndpoint().equals(this.readEndpoint())) {
            return false;
        }
        if (other.preferredAvailabilityZone() == null ^ this.preferredAvailabilityZone() == null) {
            return false;
        }
        if (other.preferredAvailabilityZone() != null && !other.preferredAvailabilityZone().equals(this.preferredAvailabilityZone())) {
            return false;
        }
        if (other.currentRole() == null ^ this.currentRole() == null) {
            return false;
        }
        return other.currentRole() == null || other.currentRole().equals(this.currentRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.cacheNodeId() != null) {
            sb.append("CacheNodeId: ").append(this.cacheNodeId()).append(",");
        }
        if (this.readEndpoint() != null) {
            sb.append("ReadEndpoint: ").append(this.readEndpoint()).append(",");
        }
        if (this.preferredAvailabilityZone() != null) {
            sb.append("PreferredAvailabilityZone: ").append(this.preferredAvailabilityZone()).append(",");
        }
        if (this.currentRole() != null) {
            sb.append("CurrentRole: ").append(this.currentRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private String cacheNodeId;
        private Endpoint readEndpoint;
        private String preferredAvailabilityZone;
        private String currentRole;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupMember model) {
            this.setCacheClusterId(model.cacheClusterId);
            this.setCacheNodeId(model.cacheNodeId);
            this.setReadEndpoint(model.readEndpoint);
            this.setPreferredAvailabilityZone(model.preferredAvailabilityZone);
            this.setCurrentRole(model.currentRole);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getCacheNodeId() {
            return this.cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        public final Endpoint getReadEndpoint() {
            return this.readEndpoint;
        }

        @Override
        public final Builder readEndpoint(Endpoint readEndpoint) {
            this.readEndpoint = readEndpoint;
            return this;
        }

        public final void setReadEndpoint(Endpoint readEndpoint) {
            this.readEndpoint = readEndpoint;
        }

        public final String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        public final String getCurrentRole() {
            return this.currentRole;
        }

        @Override
        public final Builder currentRole(String currentRole) {
            this.currentRole = currentRole;
            return this;
        }

        public final void setCurrentRole(String currentRole) {
            this.currentRole = currentRole;
        }

        public NodeGroupMember build() {
            return new NodeGroupMember(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NodeGroupMember> {
        public Builder cacheClusterId(String var1);

        public Builder cacheNodeId(String var1);

        public Builder readEndpoint(Endpoint var1);

        public Builder preferredAvailabilityZone(String var1);

        public Builder currentRole(String var1);
    }
}

