/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyReplicationGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyReplicationGroupRequest> {
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String primaryClusterId;
    private final String snapshottingClusterId;
    private final Boolean automaticFailoverEnabled;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final String preferredMaintenanceWindow;
    private final String notificationTopicArn;
    private final String cacheParameterGroupName;
    private final String notificationTopicStatus;
    private final Boolean applyImmediately;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String cacheNodeType;
    private final String nodeGroupId;

    private ModifyReplicationGroupRequest(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.primaryClusterId = builder.primaryClusterId;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.applyImmediately = builder.applyImmediately;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.cacheNodeType = builder.cacheNodeType;
        this.nodeGroupId = builder.nodeGroupId;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public String primaryClusterId() {
        return this.primaryClusterId;
    }

    public String snapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public Boolean automaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }

    public List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String notificationTopicStatus() {
        return this.notificationTopicStatus;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String nodeGroupId() {
        return this.nodeGroupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.replicationGroupId() == null ? 0 : this.replicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.replicationGroupDescription() == null ? 0 : this.replicationGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.primaryClusterId() == null ? 0 : this.primaryClusterId().hashCode());
        hashCode = 31 * hashCode + (this.snapshottingClusterId() == null ? 0 : this.snapshottingClusterId().hashCode());
        hashCode = 31 * hashCode + (this.automaticFailoverEnabled() == null ? 0 : this.automaticFailoverEnabled().hashCode());
        hashCode = 31 * hashCode + (this.cacheSecurityGroupNames() == null ? 0 : this.cacheSecurityGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.notificationTopicArn() == null ? 0 : this.notificationTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.cacheParameterGroupName() == null ? 0 : this.cacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.notificationTopicStatus() == null ? 0 : this.notificationTopicStatus().hashCode());
        hashCode = 31 * hashCode + (this.applyImmediately() == null ? 0 : this.applyImmediately().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.autoMinorVersionUpgrade() == null ? 0 : this.autoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.snapshotRetentionLimit() == null ? 0 : this.snapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.snapshotWindow() == null ? 0 : this.snapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeType() == null ? 0 : this.cacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.nodeGroupId() == null ? 0 : this.nodeGroupId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationGroupRequest)) {
            return false;
        }
        ModifyReplicationGroupRequest other = (ModifyReplicationGroupRequest)((Object)obj);
        if (other.replicationGroupId() == null ^ this.replicationGroupId() == null) {
            return false;
        }
        if (other.replicationGroupId() != null && !other.replicationGroupId().equals(this.replicationGroupId())) {
            return false;
        }
        if (other.replicationGroupDescription() == null ^ this.replicationGroupDescription() == null) {
            return false;
        }
        if (other.replicationGroupDescription() != null && !other.replicationGroupDescription().equals(this.replicationGroupDescription())) {
            return false;
        }
        if (other.primaryClusterId() == null ^ this.primaryClusterId() == null) {
            return false;
        }
        if (other.primaryClusterId() != null && !other.primaryClusterId().equals(this.primaryClusterId())) {
            return false;
        }
        if (other.snapshottingClusterId() == null ^ this.snapshottingClusterId() == null) {
            return false;
        }
        if (other.snapshottingClusterId() != null && !other.snapshottingClusterId().equals(this.snapshottingClusterId())) {
            return false;
        }
        if (other.automaticFailoverEnabled() == null ^ this.automaticFailoverEnabled() == null) {
            return false;
        }
        if (other.automaticFailoverEnabled() != null && !other.automaticFailoverEnabled().equals(this.automaticFailoverEnabled())) {
            return false;
        }
        if (other.cacheSecurityGroupNames() == null ^ this.cacheSecurityGroupNames() == null) {
            return false;
        }
        if (other.cacheSecurityGroupNames() != null && !other.cacheSecurityGroupNames().equals(this.cacheSecurityGroupNames())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.notificationTopicArn() == null ^ this.notificationTopicArn() == null) {
            return false;
        }
        if (other.notificationTopicArn() != null && !other.notificationTopicArn().equals(this.notificationTopicArn())) {
            return false;
        }
        if (other.cacheParameterGroupName() == null ^ this.cacheParameterGroupName() == null) {
            return false;
        }
        if (other.cacheParameterGroupName() != null && !other.cacheParameterGroupName().equals(this.cacheParameterGroupName())) {
            return false;
        }
        if (other.notificationTopicStatus() == null ^ this.notificationTopicStatus() == null) {
            return false;
        }
        if (other.notificationTopicStatus() != null && !other.notificationTopicStatus().equals(this.notificationTopicStatus())) {
            return false;
        }
        if (other.applyImmediately() == null ^ this.applyImmediately() == null) {
            return false;
        }
        if (other.applyImmediately() != null && !other.applyImmediately().equals(this.applyImmediately())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() == null ^ this.autoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() != null && !other.autoMinorVersionUpgrade().equals(this.autoMinorVersionUpgrade())) {
            return false;
        }
        if (other.snapshotRetentionLimit() == null ^ this.snapshotRetentionLimit() == null) {
            return false;
        }
        if (other.snapshotRetentionLimit() != null && !other.snapshotRetentionLimit().equals(this.snapshotRetentionLimit())) {
            return false;
        }
        if (other.snapshotWindow() == null ^ this.snapshotWindow() == null) {
            return false;
        }
        if (other.snapshotWindow() != null && !other.snapshotWindow().equals(this.snapshotWindow())) {
            return false;
        }
        if (other.cacheNodeType() == null ^ this.cacheNodeType() == null) {
            return false;
        }
        if (other.cacheNodeType() != null && !other.cacheNodeType().equals(this.cacheNodeType())) {
            return false;
        }
        if (other.nodeGroupId() == null ^ this.nodeGroupId() == null) {
            return false;
        }
        return other.nodeGroupId() == null || other.nodeGroupId().equals(this.nodeGroupId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.replicationGroupDescription() != null) {
            sb.append("ReplicationGroupDescription: ").append(this.replicationGroupDescription()).append(",");
        }
        if (this.primaryClusterId() != null) {
            sb.append("PrimaryClusterId: ").append(this.primaryClusterId()).append(",");
        }
        if (this.snapshottingClusterId() != null) {
            sb.append("SnapshottingClusterId: ").append(this.snapshottingClusterId()).append(",");
        }
        if (this.automaticFailoverEnabled() != null) {
            sb.append("AutomaticFailoverEnabled: ").append(this.automaticFailoverEnabled()).append(",");
        }
        if (this.cacheSecurityGroupNames() != null) {
            sb.append("CacheSecurityGroupNames: ").append(this.cacheSecurityGroupNames()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.notificationTopicArn() != null) {
            sb.append("NotificationTopicArn: ").append(this.notificationTopicArn()).append(",");
        }
        if (this.cacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.cacheParameterGroupName()).append(",");
        }
        if (this.notificationTopicStatus() != null) {
            sb.append("NotificationTopicStatus: ").append(this.notificationTopicStatus()).append(",");
        }
        if (this.applyImmediately() != null) {
            sb.append("ApplyImmediately: ").append(this.applyImmediately()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.snapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.snapshotRetentionLimit()).append(",");
        }
        if (this.snapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.snapshotWindow()).append(",");
        }
        if (this.cacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.cacheNodeType()).append(",");
        }
        if (this.nodeGroupId() != null) {
            sb.append("NodeGroupId: ").append(this.nodeGroupId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String primaryClusterId;
        private String snapshottingClusterId;
        private Boolean automaticFailoverEnabled;
        private List<String> cacheSecurityGroupNames = new SdkInternalList();
        private List<String> securityGroupIds = new SdkInternalList();
        private String preferredMaintenanceWindow;
        private String notificationTopicArn;
        private String cacheParameterGroupName;
        private String notificationTopicStatus;
        private Boolean applyImmediately;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String cacheNodeType;
        private String nodeGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationGroupRequest model) {
            this.setReplicationGroupId(model.replicationGroupId);
            this.setReplicationGroupDescription(model.replicationGroupDescription);
            this.setPrimaryClusterId(model.primaryClusterId);
            this.setSnapshottingClusterId(model.snapshottingClusterId);
            this.setAutomaticFailoverEnabled(model.automaticFailoverEnabled);
            this.setCacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.setSecurityGroupIds(model.securityGroupIds);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setNotificationTopicArn(model.notificationTopicArn);
            this.setCacheParameterGroupName(model.cacheParameterGroupName);
            this.setNotificationTopicStatus(model.notificationTopicStatus);
            this.setApplyImmediately(model.applyImmediately);
            this.setEngineVersion(model.engineVersion);
            this.setAutoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.setSnapshotRetentionLimit(model.snapshotRetentionLimit);
            this.setSnapshotWindow(model.snapshotWindow);
            this.setCacheNodeType(model.cacheNodeType);
            this.setNodeGroupId(model.nodeGroupId);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        public final String getSnapshottingClusterId() {
            return this.snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return this.automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            if (this.cacheSecurityGroupNames == null) {
                this.cacheSecurityGroupNames = new SdkInternalList(cacheSecurityGroupNames.length);
            }
            for (String e : cacheSecurityGroupNames) {
                this.cacheSecurityGroupNames.add(e);
            }
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        @SafeVarargs
        public final void setCacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            if (this.cacheSecurityGroupNames == null) {
                this.cacheSecurityGroupNames = new SdkInternalList(cacheSecurityGroupNames.length);
            }
            for (String e : cacheSecurityGroupNames) {
                this.cacheSecurityGroupNames.add(e);
            }
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new SdkInternalList(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @SafeVarargs
        public final void setSecurityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new SdkInternalList(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getNotificationTopicStatus() {
            return this.notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public ModifyReplicationGroupRequest build() {
            return new ModifyReplicationGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyReplicationGroupRequest> {
        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder primaryClusterId(String var1);

        public Builder snapshottingClusterId(String var1);

        public Builder automaticFailoverEnabled(Boolean var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder notificationTopicArn(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder notificationTopicStatus(String var1);

        public Builder applyImmediately(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder cacheNodeType(String var1);

        public Builder nodeGroupId(String var1);
    }
}

