/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.Certificate;
import software.amazon.awssdk.services.eks.model.ClusterStatus;
import software.amazon.awssdk.services.eks.model.Identity;
import software.amazon.awssdk.services.eks.model.Logging;
import software.amazon.awssdk.services.eks.model.VpcConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::name)).setter(Cluster.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::arn)).setter(Cluster.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Cluster.getter(Cluster::createdAt)).setter(Cluster.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::version)).setter(Cluster.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::endpoint)).setter(Cluster.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::roleArn)).setter(Cluster.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<VpcConfigResponse> RESOURCES_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Cluster.getter(Cluster::resourcesVpcConfig)).setter(Cluster.setter(Builder::resourcesVpcConfig)).constructor(VpcConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesVpcConfig").build()}).build();
    private static final SdkField<Logging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Cluster.getter(Cluster::logging)).setter(Cluster.setter(Builder::logging)).constructor(Logging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<Identity> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Cluster.getter(Cluster::identity)).setter(Cluster.setter(Builder::identity)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::statusAsString)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Certificate> CERTIFICATE_AUTHORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Cluster.getter(Cluster::certificateAuthority)).setter(Cluster.setter(Builder::certificateAuthority)).constructor(Certificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAuthority").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::clientRequestToken)).setter(Cluster.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::platformVersion)).setter(Cluster.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, CREATED_AT_FIELD, VERSION_FIELD, ENDPOINT_FIELD, ROLE_ARN_FIELD, RESOURCES_VPC_CONFIG_FIELD, LOGGING_FIELD, IDENTITY_FIELD, STATUS_FIELD, CERTIFICATE_AUTHORITY_FIELD, CLIENT_REQUEST_TOKEN_FIELD, PLATFORM_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final Instant createdAt;
    private final String version;
    private final String endpoint;
    private final String roleArn;
    private final VpcConfigResponse resourcesVpcConfig;
    private final Logging logging;
    private final Identity identity;
    private final String status;
    private final Certificate certificateAuthority;
    private final String clientRequestToken;
    private final String platformVersion;

    private Cluster(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.version = builder.version;
        this.endpoint = builder.endpoint;
        this.roleArn = builder.roleArn;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.logging = builder.logging;
        this.identity = builder.identity;
        this.status = builder.status;
        this.certificateAuthority = builder.certificateAuthority;
        this.clientRequestToken = builder.clientRequestToken;
        this.platformVersion = builder.platformVersion;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String version() {
        return this.version;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public VpcConfigResponse resourcesVpcConfig() {
        return this.resourcesVpcConfig;
    }

    public Logging logging() {
        return this.logging;
    }

    public Identity identity() {
        return this.identity;
    }

    public ClusterStatus status() {
        return ClusterStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Certificate certificateAuthority() {
        return this.certificateAuthority;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthority());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.resourcesVpcConfig(), other.resourcesVpcConfig()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.identity(), other.identity()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.certificateAuthority(), other.certificateAuthority()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.platformVersion(), other.platformVersion());
    }

    public String toString() {
        return ToString.builder((String)"Cluster").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Version", (Object)this.version()).add("Endpoint", (Object)this.endpoint()).add("RoleArn", (Object)this.roleArn()).add("ResourcesVpcConfig", (Object)this.resourcesVpcConfig()).add("Logging", (Object)this.logging()).add("Identity", (Object)this.identity()).add("Status", (Object)this.statusAsString()).add("CertificateAuthority", (Object)this.certificateAuthority()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("PlatformVersion", (Object)this.platformVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "resourcesVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.resourcesVpcConfig()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "certificateAuthority": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthority()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private Instant createdAt;
        private String version;
        private String endpoint;
        private String roleArn;
        private VpcConfigResponse resourcesVpcConfig;
        private Logging logging;
        private Identity identity;
        private String status;
        private Certificate certificateAuthority;
        private String clientRequestToken;
        private String platformVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.name(model.name);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.version(model.version);
            this.endpoint(model.endpoint);
            this.roleArn(model.roleArn);
            this.resourcesVpcConfig(model.resourcesVpcConfig);
            this.logging(model.logging);
            this.identity(model.identity);
            this.status(model.status);
            this.certificateAuthority(model.certificateAuthority);
            this.clientRequestToken(model.clientRequestToken);
            this.platformVersion(model.platformVersion);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final VpcConfigResponse.Builder getResourcesVpcConfig() {
            return this.resourcesVpcConfig != null ? this.resourcesVpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourcesVpcConfig(VpcConfigResponse resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final void setResourcesVpcConfig(VpcConfigResponse.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        public final Logging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final Identity.Builder getIdentity() {
            return this.identity != null ? this.identity.toBuilder() : null;
        }

        @Override
        public final Builder identity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(Identity.BuilderImpl identity) {
            this.identity = identity != null ? identity.build() : null;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Certificate.Builder getCertificateAuthority() {
            return this.certificateAuthority != null ? this.certificateAuthority.toBuilder() : null;
        }

        @Override
        public final Builder certificateAuthority(Certificate certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public final void setCertificateAuthority(Certificate.BuilderImpl certificateAuthority) {
            this.certificateAuthority = certificateAuthority != null ? certificateAuthority.build() : null;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder version(String var1);

        public Builder endpoint(String var1);

        public Builder roleArn(String var1);

        public Builder resourcesVpcConfig(VpcConfigResponse var1);

        default public Builder resourcesVpcConfig(Consumer<VpcConfigResponse.Builder> resourcesVpcConfig) {
            return this.resourcesVpcConfig((VpcConfigResponse)((VpcConfigResponse.Builder)VpcConfigResponse.builder().applyMutation(resourcesVpcConfig)).build());
        }

        public Builder logging(Logging var1);

        default public Builder logging(Consumer<Logging.Builder> logging) {
            return this.logging((Logging)((Logging.Builder)Logging.builder().applyMutation(logging)).build());
        }

        public Builder identity(Identity var1);

        default public Builder identity(Consumer<Identity.Builder> identity) {
            return this.identity((Identity)((Identity.Builder)Identity.builder().applyMutation(identity)).build());
        }

        public Builder status(String var1);

        public Builder status(ClusterStatus var1);

        public Builder certificateAuthority(Certificate var1);

        default public Builder certificateAuthority(Consumer<Certificate.Builder> certificateAuthority) {
            return this.certificateAuthority((Certificate)((Certificate.Builder)Certificate.builder().applyMutation(certificateAuthority)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder platformVersion(String var1);
    }
}

