/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an Amazon EKS cluster VPC configuration response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfigResponse.Builder, VpcConfigResponse> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(VpcConfigResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(VpcConfigResponse::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterSecurityGroupId").getter(getter(VpcConfigResponse::clusterSecurityGroupId))
            .setter(setter(Builder::clusterSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterSecurityGroupId").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(VpcConfigResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<Boolean> ENDPOINT_PUBLIC_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("endpointPublicAccess").getter(getter(VpcConfigResponse::endpointPublicAccess))
            .setter(setter(Builder::endpointPublicAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointPublicAccess").build())
            .build();

    private static final SdkField<Boolean> ENDPOINT_PRIVATE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("endpointPrivateAccess").getter(getter(VpcConfigResponse::endpointPrivateAccess))
            .setter(setter(Builder::endpointPrivateAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointPrivateAccess").build())
            .build();

    private static final SdkField<List<String>> PUBLIC_ACCESS_CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("publicAccessCidrs")
            .getter(getter(VpcConfigResponse::publicAccessCidrs))
            .setter(setter(Builder::publicAccessCidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccessCidrs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD,
            SECURITY_GROUP_IDS_FIELD, CLUSTER_SECURITY_GROUP_ID_FIELD, VPC_ID_FIELD, ENDPOINT_PUBLIC_ACCESS_FIELD,
            ENDPOINT_PRIVATE_ACCESS_FIELD, PUBLIC_ACCESS_CIDRS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final String clusterSecurityGroupId;

    private final String vpcId;

    private final Boolean endpointPublicAccess;

    private final Boolean endpointPrivateAccess;

    private final List<String> publicAccessCidrs;

    private VpcConfigResponse(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.clusterSecurityGroupId = builder.clusterSecurityGroupId;
        this.vpcId = builder.vpcId;
        this.endpointPublicAccess = builder.endpointPublicAccess;
        this.endpointPrivateAccess = builder.endpointPrivateAccess;
        this.publicAccessCidrs = builder.publicAccessCidrs;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnets associated with your cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The subnets associated with your cluster.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups associated with the cross-account elastic network interfaces that are used to allow
     * communication between your nodes and the Kubernetes control plane.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The security groups associated with the cross-account elastic network interfaces that are used to allow
     *         communication between your nodes and the Kubernetes control plane.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security
     * group for control-plane-to-data-plane communication.
     * </p>
     * 
     * @return The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this
     *         security group for control-plane-to-data-plane communication.
     */
    public final String clusterSecurityGroupId() {
        return clusterSecurityGroupId;
    }

    /**
     * <p>
     * The VPC associated with your cluster.
     * </p>
     * 
     * @return The VPC associated with your cluster.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Whether the public API server endpoint is enabled.
     * </p>
     * 
     * @return Whether the public API server endpoint is enabled.
     */
    public final Boolean endpointPublicAccess() {
        return endpointPublicAccess;
    }

    /**
     * <p>
     * This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS private
     * API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's VPC use the
     * private VPC endpoint instead of traversing the internet. If this value is disabled and you have nodes or Fargate
     * pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for
     * communication with the nodes or Fargate pods. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server endpoint</a> in
     * the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * 
     * @return This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS
     *         private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's
     *         VPC use the private VPC endpoint instead of traversing the internet. If this value is disabled and you
     *         have nodes or Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the
     *         necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server
     *         endpoint</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     */
    public final Boolean endpointPrivateAccess() {
        return endpointPrivateAccess;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublicAccessCidrs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPublicAccessCidrs() {
        return publicAccessCidrs != null && !(publicAccessCidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to
     * the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is
     * <code>0.0.0.0/0</code> and additionally <code>::/0</code> for dual-stack `IPv6` clusters. If you've disabled
     * private endpoint access, make sure that you specify the necessary CIDR blocks for every node and Fargate
     * <code>Pod</code> in the cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server endpoint</a> in
     * the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <p>
     * Note that the public endpoints are dual-stack for only <code>IPv6</code> clusters that are made after October
     * 2024. You can't add <code>IPv6</code> CIDR blocks to <code>IPv4</code> clusters or <code>IPv6</code> clusters
     * that were made before October 2024.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublicAccessCidrs} method.
     * </p>
     * 
     * @return The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
     *         Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The
     *         default value is <code>0.0.0.0/0</code> and additionally <code>::/0</code> for dual-stack `IPv6`
     *         clusters. If you've disabled private endpoint access, make sure that you specify the necessary CIDR
     *         blocks for every node and Fargate <code>Pod</code> in the cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server
     *         endpoint</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>
     *         <p>
     *         Note that the public endpoints are dual-stack for only <code>IPv6</code> clusters that are made after
     *         October 2024. You can't add <code>IPv6</code> CIDR blocks to <code>IPv4</code> clusters or
     *         <code>IPv6</code> clusters that were made before October 2024.
     */
    public final List<String> publicAccessCidrs() {
        return publicAccessCidrs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointPublicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(endpointPrivateAccess());
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicAccessCidrs() ? publicAccessCidrs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigResponse)) {
            return false;
        }
        VpcConfigResponse other = (VpcConfigResponse) obj;
        return hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(clusterSecurityGroupId(), other.clusterSecurityGroupId())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(endpointPublicAccess(), other.endpointPublicAccess())
                && Objects.equals(endpointPrivateAccess(), other.endpointPrivateAccess())
                && hasPublicAccessCidrs() == other.hasPublicAccessCidrs()
                && Objects.equals(publicAccessCidrs(), other.publicAccessCidrs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConfigResponse").add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("ClusterSecurityGroupId", clusterSecurityGroupId()).add("VpcId", vpcId())
                .add("EndpointPublicAccess", endpointPublicAccess()).add("EndpointPrivateAccess", endpointPrivateAccess())
                .add("PublicAccessCidrs", hasPublicAccessCidrs() ? publicAccessCidrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "clusterSecurityGroupId":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroupId()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "endpointPublicAccess":
            return Optional.ofNullable(clazz.cast(endpointPublicAccess()));
        case "endpointPrivateAccess":
            return Optional.ofNullable(clazz.cast(endpointPrivateAccess()));
        case "publicAccessCidrs":
            return Optional.ofNullable(clazz.cast(publicAccessCidrs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("clusterSecurityGroupId", CLUSTER_SECURITY_GROUP_ID_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        map.put("endpointPublicAccess", ENDPOINT_PUBLIC_ACCESS_FIELD);
        map.put("endpointPrivateAccess", ENDPOINT_PRIVATE_ACCESS_FIELD);
        map.put("publicAccessCidrs", PUBLIC_ACCESS_CIDRS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcConfigResponse, T> g) {
        return obj -> g.apply((VpcConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfigResponse> {
        /**
         * <p>
         * The subnets associated with your cluster.
         * </p>
         * 
         * @param subnetIds
         *        The subnets associated with your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The subnets associated with your cluster.
         * </p>
         * 
         * @param subnetIds
         *        The subnets associated with your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The security groups associated with the cross-account elastic network interfaces that are used to allow
         * communication between your nodes and the Kubernetes control plane.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups associated with the cross-account elastic network interfaces that are used to
         *        allow communication between your nodes and the Kubernetes control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security groups associated with the cross-account elastic network interfaces that are used to allow
         * communication between your nodes and the Kubernetes control plane.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups associated with the cross-account elastic network interfaces that are used to
         *        allow communication between your nodes and the Kubernetes control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this
         * security group for control-plane-to-data-plane communication.
         * </p>
         * 
         * @param clusterSecurityGroupId
         *        The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use
         *        this security group for control-plane-to-data-plane communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroupId(String clusterSecurityGroupId);

        /**
         * <p>
         * The VPC associated with your cluster.
         * </p>
         * 
         * @param vpcId
         *        The VPC associated with your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Whether the public API server endpoint is enabled.
         * </p>
         * 
         * @param endpointPublicAccess
         *        Whether the public API server endpoint is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPublicAccess(Boolean endpointPublicAccess);

        /**
         * <p>
         * This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS
         * private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's VPC
         * use the private VPC endpoint instead of traversing the internet. If this value is disabled and you have nodes
         * or Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR
         * blocks for communication with the nodes or Fargate pods. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server endpoint</a>
         * in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param endpointPrivateAccess
         *        This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon
         *        EKS private API server endpoint is enabled, Kubernetes API requests that originate from within your
         *        cluster's VPC use the private VPC endpoint instead of traversing the internet. If this value is
         *        disabled and you have nodes or Fargate pods in the cluster, then ensure that
         *        <code>publicAccessCidrs</code> includes the necessary CIDR blocks for communication with the nodes or
         *        Fargate pods. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server
         *        endpoint</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPrivateAccess(Boolean endpointPrivateAccess);

        /**
         * <p>
         * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
         * Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The
         * default value is <code>0.0.0.0/0</code> and additionally <code>::/0</code> for dual-stack `IPv6` clusters. If
         * you've disabled private endpoint access, make sure that you specify the necessary CIDR blocks for every node
         * and Fargate <code>Pod</code> in the cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server endpoint</a>
         * in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <p>
         * Note that the public endpoints are dual-stack for only <code>IPv6</code> clusters that are made after October
         * 2024. You can't add <code>IPv6</code> CIDR blocks to <code>IPv4</code> clusters or <code>IPv6</code> clusters
         * that were made before October 2024.
         * </p>
         * 
         * @param publicAccessCidrs
         *        The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
         *        Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied.
         *        The default value is <code>0.0.0.0/0</code> and additionally <code>::/0</code> for dual-stack `IPv6`
         *        clusters. If you've disabled private endpoint access, make sure that you specify the necessary CIDR
         *        blocks for every node and Fargate <code>Pod</code> in the cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server
         *        endpoint</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>
         *        <p>
         *        Note that the public endpoints are dual-stack for only <code>IPv6</code> clusters that are made after
         *        October 2024. You can't add <code>IPv6</code> CIDR blocks to <code>IPv4</code> clusters or
         *        <code>IPv6</code> clusters that were made before October 2024.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessCidrs(Collection<String> publicAccessCidrs);

        /**
         * <p>
         * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
         * Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The
         * default value is <code>0.0.0.0/0</code> and additionally <code>::/0</code> for dual-stack `IPv6` clusters. If
         * you've disabled private endpoint access, make sure that you specify the necessary CIDR blocks for every node
         * and Fargate <code>Pod</code> in the cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server endpoint</a>
         * in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <p>
         * Note that the public endpoints are dual-stack for only <code>IPv6</code> clusters that are made after October
         * 2024. You can't add <code>IPv6</code> CIDR blocks to <code>IPv4</code> clusters or <code>IPv6</code> clusters
         * that were made before October 2024.
         * </p>
         * 
         * @param publicAccessCidrs
         *        The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
         *        Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied.
         *        The default value is <code>0.0.0.0/0</code> and additionally <code>::/0</code> for dual-stack `IPv6`
         *        clusters. If you've disabled private endpoint access, make sure that you specify the necessary CIDR
         *        blocks for every node and Fargate <code>Pod</code> in the cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Cluster API server
         *        endpoint</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>
         *        <p>
         *        Note that the public endpoints are dual-stack for only <code>IPv6</code> clusters that are made after
         *        October 2024. You can't add <code>IPv6</code> CIDR blocks to <code>IPv4</code> clusters or
         *        <code>IPv6</code> clusters that were made before October 2024.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessCidrs(String... publicAccessCidrs);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String clusterSecurityGroupId;

        private String vpcId;

        private Boolean endpointPublicAccess;

        private Boolean endpointPrivateAccess;

        private List<String> publicAccessCidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigResponse model) {
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            clusterSecurityGroupId(model.clusterSecurityGroupId);
            vpcId(model.vpcId);
            endpointPublicAccess(model.endpointPublicAccess);
            endpointPrivateAccess(model.endpointPrivateAccess);
            publicAccessCidrs(model.publicAccessCidrs);
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getClusterSecurityGroupId() {
            return clusterSecurityGroupId;
        }

        public final void setClusterSecurityGroupId(String clusterSecurityGroupId) {
            this.clusterSecurityGroupId = clusterSecurityGroupId;
        }

        @Override
        public final Builder clusterSecurityGroupId(String clusterSecurityGroupId) {
            this.clusterSecurityGroupId = clusterSecurityGroupId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Boolean getEndpointPublicAccess() {
            return endpointPublicAccess;
        }

        public final void setEndpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
        }

        @Override
        public final Builder endpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
            return this;
        }

        public final Boolean getEndpointPrivateAccess() {
            return endpointPrivateAccess;
        }

        public final void setEndpointPrivateAccess(Boolean endpointPrivateAccess) {
            this.endpointPrivateAccess = endpointPrivateAccess;
        }

        @Override
        public final Builder endpointPrivateAccess(Boolean endpointPrivateAccess) {
            this.endpointPrivateAccess = endpointPrivateAccess;
            return this;
        }

        public final Collection<String> getPublicAccessCidrs() {
            if (publicAccessCidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return publicAccessCidrs;
        }

        public final void setPublicAccessCidrs(Collection<String> publicAccessCidrs) {
            this.publicAccessCidrs = StringListCopier.copy(publicAccessCidrs);
        }

        @Override
        public final Builder publicAccessCidrs(Collection<String> publicAccessCidrs) {
            this.publicAccessCidrs = StringListCopier.copy(publicAccessCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicAccessCidrs(String... publicAccessCidrs) {
            publicAccessCidrs(Arrays.asList(publicAccessCidrs));
            return this;
        }

        @Override
        public VpcConfigResponse build() {
            return new VpcConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
