/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The support policy to use for the cluster. Extended support allows you to remain on specific Kubernetes versions for
 * longer. Clusters in extended support have higher costs. The default value is <code>EXTENDED</code>. Use
 * <code>STANDARD</code> to disable extended support.
 * </p>
 * <p>
 * <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about EKS
 * Extended Support in the <i>Amazon EKS User Guide</i>.</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpgradePolicyRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<UpgradePolicyRequest.Builder, UpgradePolicyRequest> {
    private static final SdkField<String> SUPPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("supportType").getter(getter(UpgradePolicyRequest::supportTypeAsString))
            .setter(setter(Builder::supportType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String supportType;

    private UpgradePolicyRequest(BuilderImpl builder) {
        this.supportType = builder.supportType;
    }

    /**
     * <p>
     * If the cluster is set to <code>EXTENDED</code>, it will enter extended support at the end of standard support. If
     * the cluster is set to <code>STANDARD</code>, it will be automatically upgraded at the end of standard support.
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about EKS
     * Extended Support in the <i>Amazon EKS User Guide</i>.</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supportType} will
     * return {@link SupportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #supportTypeAsString}.
     * </p>
     * 
     * @return If the cluster is set to <code>EXTENDED</code>, it will enter extended support at the end of standard
     *         support. If the cluster is set to <code>STANDARD</code>, it will be automatically upgraded at the end of
     *         standard support.</p>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about
     *         EKS Extended Support in the <i>Amazon EKS User Guide</i>.</a>
     * @see SupportType
     */
    public final SupportType supportType() {
        return SupportType.fromValue(supportType);
    }

    /**
     * <p>
     * If the cluster is set to <code>EXTENDED</code>, it will enter extended support at the end of standard support. If
     * the cluster is set to <code>STANDARD</code>, it will be automatically upgraded at the end of standard support.
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about EKS
     * Extended Support in the <i>Amazon EKS User Guide</i>.</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supportType} will
     * return {@link SupportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #supportTypeAsString}.
     * </p>
     * 
     * @return If the cluster is set to <code>EXTENDED</code>, it will enter extended support at the end of standard
     *         support. If the cluster is set to <code>STANDARD</code>, it will be automatically upgraded at the end of
     *         standard support.</p>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about
     *         EKS Extended Support in the <i>Amazon EKS User Guide</i>.</a>
     * @see SupportType
     */
    public final String supportTypeAsString() {
        return supportType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(supportTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradePolicyRequest)) {
            return false;
        }
        UpgradePolicyRequest other = (UpgradePolicyRequest) obj;
        return Objects.equals(supportTypeAsString(), other.supportTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpgradePolicyRequest").add("SupportType", supportTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "supportType":
            return Optional.ofNullable(clazz.cast(supportTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("supportType", SUPPORT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpgradePolicyRequest, T> g) {
        return obj -> g.apply((UpgradePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpgradePolicyRequest> {
        /**
         * <p>
         * If the cluster is set to <code>EXTENDED</code>, it will enter extended support at the end of standard
         * support. If the cluster is set to <code>STANDARD</code>, it will be automatically upgraded at the end of
         * standard support.
         * </p>
         * <p>
         * <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about EKS
         * Extended Support in the <i>Amazon EKS User Guide</i>.</a>
         * </p>
         * 
         * @param supportType
         *        If the cluster is set to <code>EXTENDED</code>, it will enter extended support at the end of standard
         *        support. If the cluster is set to <code>STANDARD</code>, it will be automatically upgraded at the end
         *        of standard support.</p>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more
         *        about EKS Extended Support in the <i>Amazon EKS User Guide</i>.</a>
         * @see SupportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportType
         */
        Builder supportType(String supportType);

        /**
         * <p>
         * If the cluster is set to <code>EXTENDED</code>, it will enter extended support at the end of standard
         * support. If the cluster is set to <code>STANDARD</code>, it will be automatically upgraded at the end of
         * standard support.
         * </p>
         * <p>
         * <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more about EKS
         * Extended Support in the <i>Amazon EKS User Guide</i>.</a>
         * </p>
         * 
         * @param supportType
         *        If the cluster is set to <code>EXTENDED</code>, it will enter extended support at the end of standard
         *        support. If the cluster is set to <code>STANDARD</code>, it will be automatically upgraded at the end
         *        of standard support.</p>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/eks/latest/userguide/extended-support-control.html">Learn more
         *        about EKS Extended Support in the <i>Amazon EKS User Guide</i>.</a>
         * @see SupportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportType
         */
        Builder supportType(SupportType supportType);
    }

    static final class BuilderImpl implements Builder {
        private String supportType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradePolicyRequest model) {
            supportType(model.supportType);
        }

        public final String getSupportType() {
            return supportType;
        }

        public final void setSupportType(String supportType) {
            this.supportType = supportType;
        }

        @Override
        public final Builder supportType(String supportType) {
            this.supportType = supportType;
            return this;
        }

        @Override
        public final Builder supportType(SupportType supportType) {
            this.supportType(supportType == null ? null : supportType.toString());
            return this;
        }

        @Override
        public UpgradePolicyRequest build() {
            return new UpgradePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
