/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration updates for a capability. The structure varies depending on the capability type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCapabilityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateCapabilityConfiguration.Builder, UpdateCapabilityConfiguration> {
    private static final SdkField<UpdateArgoCdConfig> ARGO_CD_FIELD = SdkField
            .<UpdateArgoCdConfig> builder(MarshallingType.SDK_POJO).memberName("argoCd")
            .getter(getter(UpdateCapabilityConfiguration::argoCd)).setter(setter(Builder::argoCd))
            .constructor(UpdateArgoCdConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("argoCd").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARGO_CD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateArgoCdConfig argoCd;

    private UpdateCapabilityConfiguration(BuilderImpl builder) {
        this.argoCd = builder.argoCd;
    }

    /**
     * <p>
     * Configuration updates specific to Argo CD capabilities.
     * </p>
     * 
     * @return Configuration updates specific to Argo CD capabilities.
     */
    public final UpdateArgoCdConfig argoCd() {
        return argoCd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(argoCd());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapabilityConfiguration)) {
            return false;
        }
        UpdateCapabilityConfiguration other = (UpdateCapabilityConfiguration) obj;
        return Objects.equals(argoCd(), other.argoCd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCapabilityConfiguration").add("ArgoCd", argoCd()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "argoCd":
            return Optional.ofNullable(clazz.cast(argoCd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("argoCd", ARGO_CD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapabilityConfiguration, T> g) {
        return obj -> g.apply((UpdateCapabilityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateCapabilityConfiguration> {
        /**
         * <p>
         * Configuration updates specific to Argo CD capabilities.
         * </p>
         * 
         * @param argoCd
         *        Configuration updates specific to Argo CD capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder argoCd(UpdateArgoCdConfig argoCd);

        /**
         * <p>
         * Configuration updates specific to Argo CD capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateArgoCdConfig.Builder} avoiding the
         * need to create one manually via {@link UpdateArgoCdConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateArgoCdConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #argoCd(UpdateArgoCdConfig)}.
         * 
         * @param argoCd
         *        a consumer that will call methods on {@link UpdateArgoCdConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #argoCd(UpdateArgoCdConfig)
         */
        default Builder argoCd(Consumer<UpdateArgoCdConfig.Builder> argoCd) {
            return argoCd(UpdateArgoCdConfig.builder().applyMutation(argoCd).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateArgoCdConfig argoCd;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapabilityConfiguration model) {
            argoCd(model.argoCd);
        }

        public final UpdateArgoCdConfig.Builder getArgoCd() {
            return argoCd != null ? argoCd.toBuilder() : null;
        }

        public final void setArgoCd(UpdateArgoCdConfig.BuilderImpl argoCd) {
            this.argoCd = argoCd != null ? argoCd.build() : null;
        }

        @Override
        public final Builder argoCd(UpdateArgoCdConfig argoCd) {
            this.argoCd = argoCd;
            return this;
        }

        @Override
        public UpdateCapabilityConfiguration build() {
            return new UpdateCapabilityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
