/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration updates for an Argo CD capability. You only need to specify the fields you want to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateArgoCdConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateArgoCdConfig.Builder, UpdateArgoCdConfig> {
    private static final SdkField<UpdateRoleMappings> RBAC_ROLE_MAPPINGS_FIELD = SdkField
            .<UpdateRoleMappings> builder(MarshallingType.SDK_POJO).memberName("rbacRoleMappings")
            .getter(getter(UpdateArgoCdConfig::rbacRoleMappings)).setter(setter(Builder::rbacRoleMappings))
            .constructor(UpdateRoleMappings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rbacRoleMappings").build()).build();

    private static final SdkField<ArgoCdNetworkAccessConfigRequest> NETWORK_ACCESS_FIELD = SdkField
            .<ArgoCdNetworkAccessConfigRequest> builder(MarshallingType.SDK_POJO).memberName("networkAccess")
            .getter(getter(UpdateArgoCdConfig::networkAccess)).setter(setter(Builder::networkAccess))
            .constructor(ArgoCdNetworkAccessConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RBAC_ROLE_MAPPINGS_FIELD,
            NETWORK_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateRoleMappings rbacRoleMappings;

    private final ArgoCdNetworkAccessConfigRequest networkAccess;

    private UpdateArgoCdConfig(BuilderImpl builder) {
        this.rbacRoleMappings = builder.rbacRoleMappings;
        this.networkAccess = builder.networkAccess;
    }

    /**
     * <p>
     * Updated RBAC role mappings for the Argo CD capability. You can add, update, or remove role mappings.
     * </p>
     * 
     * @return Updated RBAC role mappings for the Argo CD capability. You can add, update, or remove role mappings.
     */
    public final UpdateRoleMappings rbacRoleMappings() {
        return rbacRoleMappings;
    }

    /**
     * <p>
     * Updated network access configuration for the Argo CD capability's managed API server endpoint. You can add or
     * remove VPC endpoint associations to control which VPCs have private access to the Argo CD server.
     * </p>
     * 
     * @return Updated network access configuration for the Argo CD capability's managed API server endpoint. You can
     *         add or remove VPC endpoint associations to control which VPCs have private access to the Argo CD server.
     */
    public final ArgoCdNetworkAccessConfigRequest networkAccess() {
        return networkAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rbacRoleMappings());
        hashCode = 31 * hashCode + Objects.hashCode(networkAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateArgoCdConfig)) {
            return false;
        }
        UpdateArgoCdConfig other = (UpdateArgoCdConfig) obj;
        return Objects.equals(rbacRoleMappings(), other.rbacRoleMappings())
                && Objects.equals(networkAccess(), other.networkAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateArgoCdConfig").add("RbacRoleMappings", rbacRoleMappings())
                .add("NetworkAccess", networkAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rbacRoleMappings":
            return Optional.ofNullable(clazz.cast(rbacRoleMappings()));
        case "networkAccess":
            return Optional.ofNullable(clazz.cast(networkAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rbacRoleMappings", RBAC_ROLE_MAPPINGS_FIELD);
        map.put("networkAccess", NETWORK_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateArgoCdConfig, T> g) {
        return obj -> g.apply((UpdateArgoCdConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateArgoCdConfig> {
        /**
         * <p>
         * Updated RBAC role mappings for the Argo CD capability. You can add, update, or remove role mappings.
         * </p>
         * 
         * @param rbacRoleMappings
         *        Updated RBAC role mappings for the Argo CD capability. You can add, update, or remove role mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rbacRoleMappings(UpdateRoleMappings rbacRoleMappings);

        /**
         * <p>
         * Updated RBAC role mappings for the Argo CD capability. You can add, update, or remove role mappings.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateRoleMappings.Builder} avoiding the
         * need to create one manually via {@link UpdateRoleMappings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateRoleMappings.Builder#build()} is called immediately and its
         * result is passed to {@link #rbacRoleMappings(UpdateRoleMappings)}.
         * 
         * @param rbacRoleMappings
         *        a consumer that will call methods on {@link UpdateRoleMappings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rbacRoleMappings(UpdateRoleMappings)
         */
        default Builder rbacRoleMappings(Consumer<UpdateRoleMappings.Builder> rbacRoleMappings) {
            return rbacRoleMappings(UpdateRoleMappings.builder().applyMutation(rbacRoleMappings).build());
        }

        /**
         * <p>
         * Updated network access configuration for the Argo CD capability's managed API server endpoint. You can add or
         * remove VPC endpoint associations to control which VPCs have private access to the Argo CD server.
         * </p>
         * 
         * @param networkAccess
         *        Updated network access configuration for the Argo CD capability's managed API server endpoint. You can
         *        add or remove VPC endpoint associations to control which VPCs have private access to the Argo CD
         *        server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAccess(ArgoCdNetworkAccessConfigRequest networkAccess);

        /**
         * <p>
         * Updated network access configuration for the Argo CD capability's managed API server endpoint. You can add or
         * remove VPC endpoint associations to control which VPCs have private access to the Argo CD server.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArgoCdNetworkAccessConfigRequest.Builder}
         * avoiding the need to create one manually via {@link ArgoCdNetworkAccessConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArgoCdNetworkAccessConfigRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #networkAccess(ArgoCdNetworkAccessConfigRequest)}.
         * 
         * @param networkAccess
         *        a consumer that will call methods on {@link ArgoCdNetworkAccessConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAccess(ArgoCdNetworkAccessConfigRequest)
         */
        default Builder networkAccess(Consumer<ArgoCdNetworkAccessConfigRequest.Builder> networkAccess) {
            return networkAccess(ArgoCdNetworkAccessConfigRequest.builder().applyMutation(networkAccess).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateRoleMappings rbacRoleMappings;

        private ArgoCdNetworkAccessConfigRequest networkAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateArgoCdConfig model) {
            rbacRoleMappings(model.rbacRoleMappings);
            networkAccess(model.networkAccess);
        }

        public final UpdateRoleMappings.Builder getRbacRoleMappings() {
            return rbacRoleMappings != null ? rbacRoleMappings.toBuilder() : null;
        }

        public final void setRbacRoleMappings(UpdateRoleMappings.BuilderImpl rbacRoleMappings) {
            this.rbacRoleMappings = rbacRoleMappings != null ? rbacRoleMappings.build() : null;
        }

        @Override
        public final Builder rbacRoleMappings(UpdateRoleMappings rbacRoleMappings) {
            this.rbacRoleMappings = rbacRoleMappings;
            return this;
        }

        public final ArgoCdNetworkAccessConfigRequest.Builder getNetworkAccess() {
            return networkAccess != null ? networkAccess.toBuilder() : null;
        }

        public final void setNetworkAccess(ArgoCdNetworkAccessConfigRequest.BuilderImpl networkAccess) {
            this.networkAccess = networkAccess != null ? networkAccess.build() : null;
        }

        @Override
        public final Builder networkAccess(ArgoCdNetworkAccessConfigRequest networkAccess) {
            this.networkAccess = networkAccess;
            return this;
        }

        @Override
        public UpdateArgoCdConfig build() {
            return new UpdateArgoCdConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
