/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The node auto repair configuration for the node group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeRepairConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeRepairConfig.Builder, NodeRepairConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(NodeRepairConfig::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Integer> MAX_UNHEALTHY_NODE_THRESHOLD_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxUnhealthyNodeThresholdCount")
            .getter(getter(NodeRepairConfig::maxUnhealthyNodeThresholdCount))
            .setter(setter(Builder::maxUnhealthyNodeThresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxUnhealthyNodeThresholdCount")
                    .build()).build();

    private static final SdkField<Integer> MAX_UNHEALTHY_NODE_THRESHOLD_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxUnhealthyNodeThresholdPercentage")
            .getter(getter(NodeRepairConfig::maxUnhealthyNodeThresholdPercentage))
            .setter(setter(Builder::maxUnhealthyNodeThresholdPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("maxUnhealthyNodeThresholdPercentage").build()).build();

    private static final SdkField<Integer> MAX_PARALLEL_NODES_REPAIRED_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxParallelNodesRepairedCount")
            .getter(getter(NodeRepairConfig::maxParallelNodesRepairedCount))
            .setter(setter(Builder::maxParallelNodesRepairedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxParallelNodesRepairedCount")
                    .build()).build();

    private static final SdkField<Integer> MAX_PARALLEL_NODES_REPAIRED_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxParallelNodesRepairedPercentage")
            .getter(getter(NodeRepairConfig::maxParallelNodesRepairedPercentage))
            .setter(setter(Builder::maxParallelNodesRepairedPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxParallelNodesRepairedPercentage")
                    .build()).build();

    private static final SdkField<List<NodeRepairConfigOverrides>> NODE_REPAIR_CONFIG_OVERRIDES_FIELD = SdkField
            .<List<NodeRepairConfigOverrides>> builder(MarshallingType.LIST)
            .memberName("nodeRepairConfigOverrides")
            .getter(getter(NodeRepairConfig::nodeRepairConfigOverrides))
            .setter(setter(Builder::nodeRepairConfigOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRepairConfigOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeRepairConfigOverrides> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeRepairConfigOverrides::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            MAX_UNHEALTHY_NODE_THRESHOLD_COUNT_FIELD, MAX_UNHEALTHY_NODE_THRESHOLD_PERCENTAGE_FIELD,
            MAX_PARALLEL_NODES_REPAIRED_COUNT_FIELD, MAX_PARALLEL_NODES_REPAIRED_PERCENTAGE_FIELD,
            NODE_REPAIR_CONFIG_OVERRIDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer maxUnhealthyNodeThresholdCount;

    private final Integer maxUnhealthyNodeThresholdPercentage;

    private final Integer maxParallelNodesRepairedCount;

    private final Integer maxParallelNodesRepairedPercentage;

    private final List<NodeRepairConfigOverrides> nodeRepairConfigOverrides;

    private NodeRepairConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxUnhealthyNodeThresholdCount = builder.maxUnhealthyNodeThresholdCount;
        this.maxUnhealthyNodeThresholdPercentage = builder.maxUnhealthyNodeThresholdPercentage;
        this.maxParallelNodesRepairedCount = builder.maxParallelNodesRepairedCount;
        this.maxParallelNodesRepairedPercentage = builder.maxParallelNodesRepairedPercentage;
        this.nodeRepairConfigOverrides = builder.nodeRepairConfigOverrides;
    }

    /**
     * <p>
     * Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
     * </p>
     * 
     * @return Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specify a count threshold of unhealthy nodes, above which node auto repair actions will stop. When using this,
     * you cannot also set <code>maxUnhealthyNodeThresholdPercentage</code> at the same time.
     * </p>
     * 
     * @return Specify a count threshold of unhealthy nodes, above which node auto repair actions will stop. When using
     *         this, you cannot also set <code>maxUnhealthyNodeThresholdPercentage</code> at the same time.
     */
    public final Integer maxUnhealthyNodeThresholdCount() {
        return maxUnhealthyNodeThresholdCount;
    }

    /**
     * <p>
     * Specify a percentage threshold of unhealthy nodes, above which node auto repair actions will stop. When using
     * this, you cannot also set <code>maxUnhealthyNodeThresholdCount</code> at the same time.
     * </p>
     * 
     * @return Specify a percentage threshold of unhealthy nodes, above which node auto repair actions will stop. When
     *         using this, you cannot also set <code>maxUnhealthyNodeThresholdCount</code> at the same time.
     */
    public final Integer maxUnhealthyNodeThresholdPercentage() {
        return maxUnhealthyNodeThresholdPercentage;
    }

    /**
     * <p>
     * Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a count of
     * unhealthy nodes. This gives you finer-grained control over the pace of node replacements. When using this, you
     * cannot also set <code>maxParallelNodesRepairedPercentage</code> at the same time.
     * </p>
     * 
     * @return Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a
     *         count of unhealthy nodes. This gives you finer-grained control over the pace of node replacements. When
     *         using this, you cannot also set <code>maxParallelNodesRepairedPercentage</code> at the same time.
     */
    public final Integer maxParallelNodesRepairedCount() {
        return maxParallelNodesRepairedCount;
    }

    /**
     * <p>
     * Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a percentage
     * of unhealthy nodes. This gives you finer-grained control over the pace of node replacements. When using this, you
     * cannot also set <code>maxParallelNodesRepairedCount</code> at the same time.
     * </p>
     * 
     * @return Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a
     *         percentage of unhealthy nodes. This gives you finer-grained control over the pace of node replacements.
     *         When using this, you cannot also set <code>maxParallelNodesRepairedCount</code> at the same time.
     */
    public final Integer maxParallelNodesRepairedPercentage() {
        return maxParallelNodesRepairedPercentage;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeRepairConfigOverrides property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNodeRepairConfigOverrides() {
        return nodeRepairConfigOverrides != null && !(nodeRepairConfigOverrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify granular overrides for specific repair actions. These overrides control the repair action and the repair
     * delay time before a node is considered eligible for repair. If you use this, you must specify all the values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeRepairConfigOverrides} method.
     * </p>
     * 
     * @return Specify granular overrides for specific repair actions. These overrides control the repair action and the
     *         repair delay time before a node is considered eligible for repair. If you use this, you must specify all
     *         the values.
     */
    public final List<NodeRepairConfigOverrides> nodeRepairConfigOverrides() {
        return nodeRepairConfigOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(maxUnhealthyNodeThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxUnhealthyNodeThresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(maxParallelNodesRepairedCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxParallelNodesRepairedPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeRepairConfigOverrides() ? nodeRepairConfigOverrides() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeRepairConfig)) {
            return false;
        }
        NodeRepairConfig other = (NodeRepairConfig) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(maxUnhealthyNodeThresholdCount(), other.maxUnhealthyNodeThresholdCount())
                && Objects.equals(maxUnhealthyNodeThresholdPercentage(), other.maxUnhealthyNodeThresholdPercentage())
                && Objects.equals(maxParallelNodesRepairedCount(), other.maxParallelNodesRepairedCount())
                && Objects.equals(maxParallelNodesRepairedPercentage(), other.maxParallelNodesRepairedPercentage())
                && hasNodeRepairConfigOverrides() == other.hasNodeRepairConfigOverrides()
                && Objects.equals(nodeRepairConfigOverrides(), other.nodeRepairConfigOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeRepairConfig").add("Enabled", enabled())
                .add("MaxUnhealthyNodeThresholdCount", maxUnhealthyNodeThresholdCount())
                .add("MaxUnhealthyNodeThresholdPercentage", maxUnhealthyNodeThresholdPercentage())
                .add("MaxParallelNodesRepairedCount", maxParallelNodesRepairedCount())
                .add("MaxParallelNodesRepairedPercentage", maxParallelNodesRepairedPercentage())
                .add("NodeRepairConfigOverrides", hasNodeRepairConfigOverrides() ? nodeRepairConfigOverrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "maxUnhealthyNodeThresholdCount":
            return Optional.ofNullable(clazz.cast(maxUnhealthyNodeThresholdCount()));
        case "maxUnhealthyNodeThresholdPercentage":
            return Optional.ofNullable(clazz.cast(maxUnhealthyNodeThresholdPercentage()));
        case "maxParallelNodesRepairedCount":
            return Optional.ofNullable(clazz.cast(maxParallelNodesRepairedCount()));
        case "maxParallelNodesRepairedPercentage":
            return Optional.ofNullable(clazz.cast(maxParallelNodesRepairedPercentage()));
        case "nodeRepairConfigOverrides":
            return Optional.ofNullable(clazz.cast(nodeRepairConfigOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("maxUnhealthyNodeThresholdCount", MAX_UNHEALTHY_NODE_THRESHOLD_COUNT_FIELD);
        map.put("maxUnhealthyNodeThresholdPercentage", MAX_UNHEALTHY_NODE_THRESHOLD_PERCENTAGE_FIELD);
        map.put("maxParallelNodesRepairedCount", MAX_PARALLEL_NODES_REPAIRED_COUNT_FIELD);
        map.put("maxParallelNodesRepairedPercentage", MAX_PARALLEL_NODES_REPAIRED_PERCENTAGE_FIELD);
        map.put("nodeRepairConfigOverrides", NODE_REPAIR_CONFIG_OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeRepairConfig, T> g) {
        return obj -> g.apply((NodeRepairConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeRepairConfig> {
        /**
         * <p>
         * Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
         * </p>
         * 
         * @param enabled
         *        Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specify a count threshold of unhealthy nodes, above which node auto repair actions will stop. When using
         * this, you cannot also set <code>maxUnhealthyNodeThresholdPercentage</code> at the same time.
         * </p>
         * 
         * @param maxUnhealthyNodeThresholdCount
         *        Specify a count threshold of unhealthy nodes, above which node auto repair actions will stop. When
         *        using this, you cannot also set <code>maxUnhealthyNodeThresholdPercentage</code> at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUnhealthyNodeThresholdCount(Integer maxUnhealthyNodeThresholdCount);

        /**
         * <p>
         * Specify a percentage threshold of unhealthy nodes, above which node auto repair actions will stop. When using
         * this, you cannot also set <code>maxUnhealthyNodeThresholdCount</code> at the same time.
         * </p>
         * 
         * @param maxUnhealthyNodeThresholdPercentage
         *        Specify a percentage threshold of unhealthy nodes, above which node auto repair actions will stop.
         *        When using this, you cannot also set <code>maxUnhealthyNodeThresholdCount</code> at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUnhealthyNodeThresholdPercentage(Integer maxUnhealthyNodeThresholdPercentage);

        /**
         * <p>
         * Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a count of
         * unhealthy nodes. This gives you finer-grained control over the pace of node replacements. When using this,
         * you cannot also set <code>maxParallelNodesRepairedPercentage</code> at the same time.
         * </p>
         * 
         * @param maxParallelNodesRepairedCount
         *        Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a
         *        count of unhealthy nodes. This gives you finer-grained control over the pace of node replacements.
         *        When using this, you cannot also set <code>maxParallelNodesRepairedPercentage</code> at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParallelNodesRepairedCount(Integer maxParallelNodesRepairedCount);

        /**
         * <p>
         * Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a
         * percentage of unhealthy nodes. This gives you finer-grained control over the pace of node replacements. When
         * using this, you cannot also set <code>maxParallelNodesRepairedCount</code> at the same time.
         * </p>
         * 
         * @param maxParallelNodesRepairedPercentage
         *        Specify the maximum number of nodes that can be repaired concurrently or in parallel, expressed as a
         *        percentage of unhealthy nodes. This gives you finer-grained control over the pace of node
         *        replacements. When using this, you cannot also set <code>maxParallelNodesRepairedCount</code> at the
         *        same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParallelNodesRepairedPercentage(Integer maxParallelNodesRepairedPercentage);

        /**
         * <p>
         * Specify granular overrides for specific repair actions. These overrides control the repair action and the
         * repair delay time before a node is considered eligible for repair. If you use this, you must specify all the
         * values.
         * </p>
         * 
         * @param nodeRepairConfigOverrides
         *        Specify granular overrides for specific repair actions. These overrides control the repair action and
         *        the repair delay time before a node is considered eligible for repair. If you use this, you must
         *        specify all the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRepairConfigOverrides(Collection<NodeRepairConfigOverrides> nodeRepairConfigOverrides);

        /**
         * <p>
         * Specify granular overrides for specific repair actions. These overrides control the repair action and the
         * repair delay time before a node is considered eligible for repair. If you use this, you must specify all the
         * values.
         * </p>
         * 
         * @param nodeRepairConfigOverrides
         *        Specify granular overrides for specific repair actions. These overrides control the repair action and
         *        the repair delay time before a node is considered eligible for repair. If you use this, you must
         *        specify all the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRepairConfigOverrides(NodeRepairConfigOverrides... nodeRepairConfigOverrides);

        /**
         * <p>
         * Specify granular overrides for specific repair actions. These overrides control the repair action and the
         * repair delay time before a node is considered eligible for repair. If you use this, you must specify all the
         * values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.NodeRepairConfigOverrides.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.eks.model.NodeRepairConfigOverrides#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.NodeRepairConfigOverrides.Builder#build()} is called
         * immediately and its result is passed to {@link #nodeRepairConfigOverrides(List<NodeRepairConfigOverrides>)}.
         * 
         * @param nodeRepairConfigOverrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.NodeRepairConfigOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeRepairConfigOverrides(java.util.Collection<NodeRepairConfigOverrides>)
         */
        Builder nodeRepairConfigOverrides(Consumer<NodeRepairConfigOverrides.Builder>... nodeRepairConfigOverrides);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer maxUnhealthyNodeThresholdCount;

        private Integer maxUnhealthyNodeThresholdPercentage;

        private Integer maxParallelNodesRepairedCount;

        private Integer maxParallelNodesRepairedPercentage;

        private List<NodeRepairConfigOverrides> nodeRepairConfigOverrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeRepairConfig model) {
            enabled(model.enabled);
            maxUnhealthyNodeThresholdCount(model.maxUnhealthyNodeThresholdCount);
            maxUnhealthyNodeThresholdPercentage(model.maxUnhealthyNodeThresholdPercentage);
            maxParallelNodesRepairedCount(model.maxParallelNodesRepairedCount);
            maxParallelNodesRepairedPercentage(model.maxParallelNodesRepairedPercentage);
            nodeRepairConfigOverrides(model.nodeRepairConfigOverrides);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getMaxUnhealthyNodeThresholdCount() {
            return maxUnhealthyNodeThresholdCount;
        }

        public final void setMaxUnhealthyNodeThresholdCount(Integer maxUnhealthyNodeThresholdCount) {
            this.maxUnhealthyNodeThresholdCount = maxUnhealthyNodeThresholdCount;
        }

        @Override
        public final Builder maxUnhealthyNodeThresholdCount(Integer maxUnhealthyNodeThresholdCount) {
            this.maxUnhealthyNodeThresholdCount = maxUnhealthyNodeThresholdCount;
            return this;
        }

        public final Integer getMaxUnhealthyNodeThresholdPercentage() {
            return maxUnhealthyNodeThresholdPercentage;
        }

        public final void setMaxUnhealthyNodeThresholdPercentage(Integer maxUnhealthyNodeThresholdPercentage) {
            this.maxUnhealthyNodeThresholdPercentage = maxUnhealthyNodeThresholdPercentage;
        }

        @Override
        public final Builder maxUnhealthyNodeThresholdPercentage(Integer maxUnhealthyNodeThresholdPercentage) {
            this.maxUnhealthyNodeThresholdPercentage = maxUnhealthyNodeThresholdPercentage;
            return this;
        }

        public final Integer getMaxParallelNodesRepairedCount() {
            return maxParallelNodesRepairedCount;
        }

        public final void setMaxParallelNodesRepairedCount(Integer maxParallelNodesRepairedCount) {
            this.maxParallelNodesRepairedCount = maxParallelNodesRepairedCount;
        }

        @Override
        public final Builder maxParallelNodesRepairedCount(Integer maxParallelNodesRepairedCount) {
            this.maxParallelNodesRepairedCount = maxParallelNodesRepairedCount;
            return this;
        }

        public final Integer getMaxParallelNodesRepairedPercentage() {
            return maxParallelNodesRepairedPercentage;
        }

        public final void setMaxParallelNodesRepairedPercentage(Integer maxParallelNodesRepairedPercentage) {
            this.maxParallelNodesRepairedPercentage = maxParallelNodesRepairedPercentage;
        }

        @Override
        public final Builder maxParallelNodesRepairedPercentage(Integer maxParallelNodesRepairedPercentage) {
            this.maxParallelNodesRepairedPercentage = maxParallelNodesRepairedPercentage;
            return this;
        }

        public final List<NodeRepairConfigOverrides.Builder> getNodeRepairConfigOverrides() {
            List<NodeRepairConfigOverrides.Builder> result = NodeRepairConfigOverridesListCopier
                    .copyToBuilder(this.nodeRepairConfigOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeRepairConfigOverrides(Collection<NodeRepairConfigOverrides.BuilderImpl> nodeRepairConfigOverrides) {
            this.nodeRepairConfigOverrides = NodeRepairConfigOverridesListCopier.copyFromBuilder(nodeRepairConfigOverrides);
        }

        @Override
        public final Builder nodeRepairConfigOverrides(Collection<NodeRepairConfigOverrides> nodeRepairConfigOverrides) {
            this.nodeRepairConfigOverrides = NodeRepairConfigOverridesListCopier.copy(nodeRepairConfigOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRepairConfigOverrides(NodeRepairConfigOverrides... nodeRepairConfigOverrides) {
            nodeRepairConfigOverrides(Arrays.asList(nodeRepairConfigOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRepairConfigOverrides(Consumer<NodeRepairConfigOverrides.Builder>... nodeRepairConfigOverrides) {
            nodeRepairConfigOverrides(Stream.of(nodeRepairConfigOverrides)
                    .map(c -> NodeRepairConfigOverrides.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public NodeRepairConfig build() {
            return new NodeRepairConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
