/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssociatedAccessPoliciesResponse extends EksResponse implements
        ToCopyableBuilder<ListAssociatedAccessPoliciesResponse.Builder, ListAssociatedAccessPoliciesResponse> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(ListAssociatedAccessPoliciesResponse::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(ListAssociatedAccessPoliciesResponse::principalArn))
            .setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssociatedAccessPoliciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AssociatedAccessPolicy>> ASSOCIATED_ACCESS_POLICIES_FIELD = SdkField
            .<List<AssociatedAccessPolicy>> builder(MarshallingType.LIST)
            .memberName("associatedAccessPolicies")
            .getter(getter(ListAssociatedAccessPoliciesResponse::associatedAccessPolicies))
            .setter(setter(Builder::associatedAccessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAccessPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociatedAccessPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedAccessPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            PRINCIPAL_ARN_FIELD, NEXT_TOKEN_FIELD, ASSOCIATED_ACCESS_POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final String principalArn;

    private final String nextToken;

    private final List<AssociatedAccessPolicy> associatedAccessPolicies;

    private ListAssociatedAccessPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.nextToken = builder.nextToken;
        this.associatedAccessPolicies = builder.associatedAccessPolicies;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The ARN of the IAM principal for the <code>AccessEntry</code>.
     * </p>
     * 
     * @return The ARN of the IAM principal for the <code>AccessEntry</code>.
     */
    public final String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was
     * used and the results exceeded the value of that parameter. Pagination continues from the end of the previous
     * results that returned the <code>nextToken</code> value. This value is null when there are no more results to
     * return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated request, where
     *         <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is null when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedAccessPolicies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedAccessPolicies() {
        return associatedAccessPolicies != null && !(associatedAccessPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of access policies associated with the access entry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedAccessPolicies} method.
     * </p>
     * 
     * @return The list of access policies associated with the access entry.
     */
    public final List<AssociatedAccessPolicy> associatedAccessPolicies() {
        return associatedAccessPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedAccessPolicies() ? associatedAccessPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedAccessPoliciesResponse)) {
            return false;
        }
        ListAssociatedAccessPoliciesResponse other = (ListAssociatedAccessPoliciesResponse) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(principalArn(), other.principalArn())
                && Objects.equals(nextToken(), other.nextToken())
                && hasAssociatedAccessPolicies() == other.hasAssociatedAccessPolicies()
                && Objects.equals(associatedAccessPolicies(), other.associatedAccessPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssociatedAccessPoliciesResponse").add("ClusterName", clusterName())
                .add("PrincipalArn", principalArn()).add("NextToken", nextToken())
                .add("AssociatedAccessPolicies", hasAssociatedAccessPolicies() ? associatedAccessPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "associatedAccessPolicies":
            return Optional.ofNullable(clazz.cast(associatedAccessPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("principalArn", PRINCIPAL_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("associatedAccessPolicies", ASSOCIATED_ACCESS_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedAccessPoliciesResponse, T> g) {
        return obj -> g.apply((ListAssociatedAccessPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAssociatedAccessPoliciesResponse> {
        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The ARN of the IAM principal for the <code>AccessEntry</code>.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the IAM principal for the <code>AccessEntry</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code>
         * was used and the results exceeded the value of that parameter. Pagination continues from the end of the
         * previous results that returned the <code>nextToken</code> value. This value is null when there are no more
         * results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated request, where
         *        <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         *        continues from the end of the previous results that returned the <code>nextToken</code> value. This
         *        value is null when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of access policies associated with the access entry.
         * </p>
         * 
         * @param associatedAccessPolicies
         *        The list of access policies associated with the access entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAccessPolicies(Collection<AssociatedAccessPolicy> associatedAccessPolicies);

        /**
         * <p>
         * The list of access policies associated with the access entry.
         * </p>
         * 
         * @param associatedAccessPolicies
         *        The list of access policies associated with the access entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAccessPolicies(AssociatedAccessPolicy... associatedAccessPolicies);

        /**
         * <p>
         * The list of access policies associated with the access entry.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.AssociatedAccessPolicy.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.eks.model.AssociatedAccessPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.AssociatedAccessPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #associatedAccessPolicies(List<AssociatedAccessPolicy>)}.
         * 
         * @param associatedAccessPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.AssociatedAccessPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedAccessPolicies(java.util.Collection<AssociatedAccessPolicy>)
         */
        Builder associatedAccessPolicies(Consumer<AssociatedAccessPolicy.Builder>... associatedAccessPolicies);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private String clusterName;

        private String principalArn;

        private String nextToken;

        private List<AssociatedAccessPolicy> associatedAccessPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedAccessPoliciesResponse model) {
            super(model);
            clusterName(model.clusterName);
            principalArn(model.principalArn);
            nextToken(model.nextToken);
            associatedAccessPolicies(model.associatedAccessPolicies);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AssociatedAccessPolicy.Builder> getAssociatedAccessPolicies() {
            List<AssociatedAccessPolicy.Builder> result = AssociatedAccessPoliciesListCopier
                    .copyToBuilder(this.associatedAccessPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedAccessPolicies(Collection<AssociatedAccessPolicy.BuilderImpl> associatedAccessPolicies) {
            this.associatedAccessPolicies = AssociatedAccessPoliciesListCopier.copyFromBuilder(associatedAccessPolicies);
        }

        @Override
        public final Builder associatedAccessPolicies(Collection<AssociatedAccessPolicy> associatedAccessPolicies) {
            this.associatedAccessPolicies = AssociatedAccessPoliciesListCopier.copy(associatedAccessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedAccessPolicies(AssociatedAccessPolicy... associatedAccessPolicies) {
            associatedAccessPolicies(Arrays.asList(associatedAccessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedAccessPolicies(Consumer<AssociatedAccessPolicy.Builder>... associatedAccessPolicies) {
            associatedAccessPolicies(Stream.of(associatedAccessPolicies)
                    .map(c -> AssociatedAccessPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAssociatedAccessPoliciesResponse build() {
            return new ListAssociatedAccessPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
