/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInsightsRefreshResponse extends EksResponse implements
        ToCopyableBuilder<DescribeInsightsRefreshResponse.Builder, DescribeInsightsRefreshResponse> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(DescribeInsightsRefreshResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeInsightsRefreshResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(DescribeInsightsRefreshResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt").getter(getter(DescribeInsightsRefreshResponse::endedAt)).setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, STATUS_FIELD,
            STARTED_AT_FIELD, ENDED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String message;

    private final String status;

    private final Instant startedAt;

    private final Instant endedAt;

    private DescribeInsightsRefreshResponse(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
    }

    /**
     * <p>
     * The message associated with the insights refresh operation.
     * </p>
     * 
     * @return The message associated with the insights refresh operation.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The current status of the insights refresh operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InsightsRefreshStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the insights refresh operation.
     * @see InsightsRefreshStatus
     */
    public final InsightsRefreshStatus status() {
        return InsightsRefreshStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the insights refresh operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InsightsRefreshStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the insights refresh operation.
     * @see InsightsRefreshStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the insights refresh operation started.
     * </p>
     * 
     * @return The date and time when the insights refresh operation started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The date and time when the insights refresh operation ended.
     * </p>
     * 
     * @return The date and time when the insights refresh operation ended.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInsightsRefreshResponse)) {
            return false;
        }
        DescribeInsightsRefreshResponse other = (DescribeInsightsRefreshResponse) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(endedAt(), other.endedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInsightsRefreshResponse").add("Message", message()).add("Status", statusAsString())
                .add("StartedAt", startedAt()).add("EndedAt", endedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("message", MESSAGE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInsightsRefreshResponse, T> g) {
        return obj -> g.apply((DescribeInsightsRefreshResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInsightsRefreshResponse> {
        /**
         * <p>
         * The message associated with the insights refresh operation.
         * </p>
         * 
         * @param message
         *        The message associated with the insights refresh operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The current status of the insights refresh operation.
         * </p>
         * 
         * @param status
         *        The current status of the insights refresh operation.
         * @see InsightsRefreshStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightsRefreshStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the insights refresh operation.
         * </p>
         * 
         * @param status
         *        The current status of the insights refresh operation.
         * @see InsightsRefreshStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightsRefreshStatus
         */
        Builder status(InsightsRefreshStatus status);

        /**
         * <p>
         * The date and time when the insights refresh operation started.
         * </p>
         * 
         * @param startedAt
         *        The date and time when the insights refresh operation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The date and time when the insights refresh operation ended.
         * </p>
         * 
         * @param endedAt
         *        The date and time when the insights refresh operation ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private String message;

        private String status;

        private Instant startedAt;

        private Instant endedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInsightsRefreshResponse model) {
            super(model);
            message(model.message);
            status(model.status);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InsightsRefreshStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Override
        public DescribeInsightsRefreshResponse build() {
            return new DescribeInsightsRefreshResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
