/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFargateProfileRequest extends EksRequest implements
        ToCopyableBuilder<CreateFargateProfileRequest.Builder, CreateFargateProfileRequest> {
    private static final SdkField<String> FARGATE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fargateProfileName").getter(getter(CreateFargateProfileRequest::fargateProfileName))
            .setter(setter(Builder::fargateProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileName").build())
            .build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(CreateFargateProfileRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> POD_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("podExecutionRoleArn").getter(getter(CreateFargateProfileRequest::podExecutionRoleArn))
            .setter(setter(Builder::podExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podExecutionRoleArn").build())
            .build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(CreateFargateProfileRequest::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FargateProfileSelector>> SELECTORS_FIELD = SdkField
            .<List<FargateProfileSelector>> builder(MarshallingType.LIST)
            .memberName("selectors")
            .getter(getter(CreateFargateProfileRequest::selectors))
            .setter(setter(Builder::selectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FargateProfileSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(FargateProfileSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateFargateProfileRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateFargateProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARGATE_PROFILE_NAME_FIELD,
            CLUSTER_NAME_FIELD, POD_EXECUTION_ROLE_ARN_FIELD, SUBNETS_FIELD, SELECTORS_FIELD, CLIENT_REQUEST_TOKEN_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fargateProfileName;

    private final String clusterName;

    private final String podExecutionRoleArn;

    private final List<String> subnets;

    private final List<FargateProfileSelector> selectors;

    private final String clientRequestToken;

    private final Map<String, String> tags;

    private CreateFargateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.fargateProfileName = builder.fargateProfileName;
        this.clusterName = builder.clusterName;
        this.podExecutionRoleArn = builder.podExecutionRoleArn;
        this.subnets = builder.subnets;
        this.selectors = builder.selectors;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the Fargate profile.
     * </p>
     * 
     * @return The name of the Fargate profile.
     */
    public final String fargateProfileName() {
        return fargateProfileName;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for a <code>Pod</code> that matches
     * the selectors in the Fargate profile. The <code>Pod</code> execution role allows Fargate infrastructure to
     * register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more
     * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">
     * <code>Pod</code> execution role</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for a <code>Pod</code> that
     *         matches the selectors in the Fargate profile. The <code>Pod</code> execution role allows Fargate
     *         infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image
     *         repositories. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html"> <code>Pod</code>
     *         execution role</a> in the <i>Amazon EKS User Guide</i>.
     */
    public final String podExecutionRoleArn() {
        return podExecutionRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of subnets to launch a <code>Pod</code> into. A <code>Pod</code> running on Fargate isn't assigned a
     * public IP address, so only private subnets (with no direct route to an Internet Gateway) are accepted for this
     * parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The IDs of subnets to launch a <code>Pod</code> into. A <code>Pod</code> running on Fargate isn't
     *         assigned a public IP address, so only private subnets (with no direct route to an Internet Gateway) are
     *         accepted for this parameter.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Selectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSelectors() {
        return selectors != null && !(selectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selectors to match for a <code>Pod</code> to use this Fargate profile. Each selector must have an associated
     * Kubernetes <code>namespace</code>. Optionally, you can also specify <code>labels</code> for a
     * <code>namespace</code>. You may specify up to five selectors in a Fargate profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectors} method.
     * </p>
     * 
     * @return The selectors to match for a <code>Pod</code> to use this Fargate profile. Each selector must have an
     *         associated Kubernetes <code>namespace</code>. Optionally, you can also specify <code>labels</code> for a
     *         <code>namespace</code>. You may specify up to five selectors in a Fargate profile.
     */
    public final List<FargateProfileSelector> selectors() {
        return selectors;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You
     * define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that assists with categorization and organization. Each tag consists of a key and an optional
     *         value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fargateProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(podExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectors() ? selectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFargateProfileRequest)) {
            return false;
        }
        CreateFargateProfileRequest other = (CreateFargateProfileRequest) obj;
        return Objects.equals(fargateProfileName(), other.fargateProfileName())
                && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(podExecutionRoleArn(), other.podExecutionRoleArn()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && hasSelectors() == other.hasSelectors()
                && Objects.equals(selectors(), other.selectors())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFargateProfileRequest").add("FargateProfileName", fargateProfileName())
                .add("ClusterName", clusterName()).add("PodExecutionRoleArn", podExecutionRoleArn())
                .add("Subnets", hasSubnets() ? subnets() : null).add("Selectors", hasSelectors() ? selectors() : null)
                .add("ClientRequestToken", clientRequestToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fargateProfileName":
            return Optional.ofNullable(clazz.cast(fargateProfileName()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "podExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(podExecutionRoleArn()));
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "selectors":
            return Optional.ofNullable(clazz.cast(selectors()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fargateProfileName", FARGATE_PROFILE_NAME_FIELD);
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("podExecutionRoleArn", POD_EXECUTION_ROLE_ARN_FIELD);
        map.put("subnets", SUBNETS_FIELD);
        map.put("selectors", SELECTORS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFargateProfileRequest, T> g) {
        return obj -> g.apply((CreateFargateProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFargateProfileRequest> {
        /**
         * <p>
         * The name of the Fargate profile.
         * </p>
         * 
         * @param fargateProfileName
         *        The name of the Fargate profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfileName(String fargateProfileName);

        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for a <code>Pod</code> that
         * matches the selectors in the Fargate profile. The <code>Pod</code> execution role allows Fargate
         * infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image
         * repositories. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html"> <code>Pod</code> execution
         * role</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param podExecutionRoleArn
         *        The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for a <code>Pod</code>
         *        that matches the selectors in the Fargate profile. The <code>Pod</code> execution role allows Fargate
         *        infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR
         *        image repositories. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html"> <code>Pod</code>
         *        execution role</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder podExecutionRoleArn(String podExecutionRoleArn);

        /**
         * <p>
         * The IDs of subnets to launch a <code>Pod</code> into. A <code>Pod</code> running on Fargate isn't assigned a
         * public IP address, so only private subnets (with no direct route to an Internet Gateway) are accepted for
         * this parameter.
         * </p>
         * 
         * @param subnets
         *        The IDs of subnets to launch a <code>Pod</code> into. A <code>Pod</code> running on Fargate isn't
         *        assigned a public IP address, so only private subnets (with no direct route to an Internet Gateway)
         *        are accepted for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of subnets to launch a <code>Pod</code> into. A <code>Pod</code> running on Fargate isn't assigned a
         * public IP address, so only private subnets (with no direct route to an Internet Gateway) are accepted for
         * this parameter.
         * </p>
         * 
         * @param subnets
         *        The IDs of subnets to launch a <code>Pod</code> into. A <code>Pod</code> running on Fargate isn't
         *        assigned a public IP address, so only private subnets (with no direct route to an Internet Gateway)
         *        are accepted for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The selectors to match for a <code>Pod</code> to use this Fargate profile. Each selector must have an
         * associated Kubernetes <code>namespace</code>. Optionally, you can also specify <code>labels</code> for a
         * <code>namespace</code>. You may specify up to five selectors in a Fargate profile.
         * </p>
         * 
         * @param selectors
         *        The selectors to match for a <code>Pod</code> to use this Fargate profile. Each selector must have an
         *        associated Kubernetes <code>namespace</code>. Optionally, you can also specify <code>labels</code> for
         *        a <code>namespace</code>. You may specify up to five selectors in a Fargate profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(Collection<FargateProfileSelector> selectors);

        /**
         * <p>
         * The selectors to match for a <code>Pod</code> to use this Fargate profile. Each selector must have an
         * associated Kubernetes <code>namespace</code>. Optionally, you can also specify <code>labels</code> for a
         * <code>namespace</code>. You may specify up to five selectors in a Fargate profile.
         * </p>
         * 
         * @param selectors
         *        The selectors to match for a <code>Pod</code> to use this Fargate profile. Each selector must have an
         *        associated Kubernetes <code>namespace</code>. Optionally, you can also specify <code>labels</code> for
         *        a <code>namespace</code>. You may specify up to five selectors in a Fargate profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(FargateProfileSelector... selectors);

        /**
         * <p>
         * The selectors to match for a <code>Pod</code> to use this Fargate profile. Each selector must have an
         * associated Kubernetes <code>namespace</code>. Optionally, you can also specify <code>labels</code> for a
         * <code>namespace</code>. You may specify up to five selectors in a Fargate profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.FargateProfileSelector.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.eks.model.FargateProfileSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.FargateProfileSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #selectors(List<FargateProfileSelector>)}.
         * 
         * @param selectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.FargateProfileSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectors(java.util.Collection<FargateProfileSelector>)
         */
        Builder selectors(Consumer<FargateProfileSelector.Builder>... selectors);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value.
         * You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        Metadata that assists with categorization and organization. Each tag consists of a key and an optional
         *        value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String fargateProfileName;

        private String clusterName;

        private String podExecutionRoleArn;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<FargateProfileSelector> selectors = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFargateProfileRequest model) {
            super(model);
            fargateProfileName(model.fargateProfileName);
            clusterName(model.clusterName);
            podExecutionRoleArn(model.podExecutionRoleArn);
            subnets(model.subnets);
            selectors(model.selectors);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getFargateProfileName() {
            return fargateProfileName;
        }

        public final void setFargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
        }

        @Override
        public final Builder fargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPodExecutionRoleArn() {
            return podExecutionRoleArn;
        }

        public final void setPodExecutionRoleArn(String podExecutionRoleArn) {
            this.podExecutionRoleArn = podExecutionRoleArn;
        }

        @Override
        public final Builder podExecutionRoleArn(String podExecutionRoleArn) {
            this.podExecutionRoleArn = podExecutionRoleArn;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final List<FargateProfileSelector.Builder> getSelectors() {
            List<FargateProfileSelector.Builder> result = FargateProfileSelectorsCopier.copyToBuilder(this.selectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectors(Collection<FargateProfileSelector.BuilderImpl> selectors) {
            this.selectors = FargateProfileSelectorsCopier.copyFromBuilder(selectors);
        }

        @Override
        public final Builder selectors(Collection<FargateProfileSelector> selectors) {
            this.selectors = FargateProfileSelectorsCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(FargateProfileSelector... selectors) {
            selectors(Arrays.asList(selectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Consumer<FargateProfileSelector.Builder>... selectors) {
            selectors(Stream.of(selectors).map(c -> FargateProfileSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFargateProfileRequest build() {
            return new CreateFargateProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
