/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a capability, containing basic information without the full configuration details. This is returned by
 * the <code>ListCapabilities</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapabilitySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CapabilitySummary.Builder, CapabilitySummary> {
    private static final SdkField<String> CAPABILITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityName").getter(getter(CapabilitySummary::capabilityName))
            .setter(setter(Builder::capabilityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CapabilitySummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CapabilitySummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CapabilitySummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CapabilitySummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CapabilitySummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(CapabilitySummary::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_NAME_FIELD,
            ARN_FIELD, TYPE_FIELD, STATUS_FIELD, VERSION_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capabilityName;

    private final String arn;

    private final String type;

    private final String status;

    private final String version;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private CapabilitySummary(BuilderImpl builder) {
        this.capabilityName = builder.capabilityName;
        this.arn = builder.arn;
        this.type = builder.type;
        this.status = builder.status;
        this.version = builder.version;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    /**
     * <p>
     * The unique name of the capability within the cluster.
     * </p>
     * 
     * @return The unique name of the capability within the cluster.
     */
    public final String capabilityName() {
        return capabilityName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the capability.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the capability.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of capability. Valid values are <code>ACK</code>, <code>ARGOCD</code>, or <code>KRO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of capability. Valid values are <code>ACK</code>, <code>ARGOCD</code>, or <code>KRO</code>.
     * @see CapabilityType
     */
    public final CapabilityType type() {
        return CapabilityType.fromValue(type);
    }

    /**
     * <p>
     * The type of capability. Valid values are <code>ACK</code>, <code>ARGOCD</code>, or <code>KRO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of capability. Valid values are <code>ACK</code>, <code>ARGOCD</code>, or <code>KRO</code>.
     * @see CapabilityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The current status of the capability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapabilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the capability.
     * @see CapabilityStatus
     */
    public final CapabilityStatus status() {
        return CapabilityStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the capability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapabilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the capability.
     * @see CapabilityStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The version of the capability software that is currently running.
     * </p>
     * 
     * @return The version of the capability software that is currently running.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the capability was created.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the capability was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the capability was last modified.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the capability was last modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilitySummary)) {
            return false;
        }
        CapabilitySummary other = (CapabilitySummary) obj;
        return Objects.equals(capabilityName(), other.capabilityName()) && Objects.equals(arn(), other.arn())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(version(), other.version())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapabilitySummary").add("CapabilityName", capabilityName()).add("Arn", arn())
                .add("Type", typeAsString()).add("Status", statusAsString()).add("Version", version())
                .add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capabilityName":
            return Optional.ofNullable(clazz.cast(capabilityName()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capabilityName", CAPABILITY_NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapabilitySummary, T> g) {
        return obj -> g.apply((CapabilitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapabilitySummary> {
        /**
         * <p>
         * The unique name of the capability within the cluster.
         * </p>
         * 
         * @param capabilityName
         *        The unique name of the capability within the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityName(String capabilityName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the capability.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of capability. Valid values are <code>ACK</code>, <code>ARGOCD</code>, or <code>KRO</code>.
         * </p>
         * 
         * @param type
         *        The type of capability. Valid values are <code>ACK</code>, <code>ARGOCD</code>, or <code>KRO</code>.
         * @see CapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of capability. Valid values are <code>ACK</code>, <code>ARGOCD</code>, or <code>KRO</code>.
         * </p>
         * 
         * @param type
         *        The type of capability. Valid values are <code>ACK</code>, <code>ARGOCD</code>, or <code>KRO</code>.
         * @see CapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityType
         */
        Builder type(CapabilityType type);

        /**
         * <p>
         * The current status of the capability.
         * </p>
         * 
         * @param status
         *        The current status of the capability.
         * @see CapabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the capability.
         * </p>
         * 
         * @param status
         *        The current status of the capability.
         * @see CapabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityStatus
         */
        Builder status(CapabilityStatus status);

        /**
         * <p>
         * The version of the capability software that is currently running.
         * </p>
         * 
         * @param version
         *        The version of the capability software that is currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the capability was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp in seconds for when the capability was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the capability was last modified.
         * </p>
         * 
         * @param modifiedAt
         *        The Unix epoch timestamp in seconds for when the capability was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);
    }

    static final class BuilderImpl implements Builder {
        private String capabilityName;

        private String arn;

        private String type;

        private String status;

        private String version;

        private Instant createdAt;

        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilitySummary model) {
            capabilityName(model.capabilityName);
            arn(model.arn);
            type(model.type);
            status(model.status);
            version(model.version);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
        }

        public final String getCapabilityName() {
            return capabilityName;
        }

        public final void setCapabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
        }

        @Override
        public final Builder capabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CapabilityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapabilityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public CapabilitySummary build() {
            return new CapabilitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
