/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response object containing Argo CD configuration details, including the server URL that you use to access the
 * Argo CD web interface and API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArgoCdConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ArgoCdConfigResponse.Builder, ArgoCdConfigResponse> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ArgoCdConfigResponse::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<ArgoCdAwsIdcConfigResponse> AWS_IDC_FIELD = SdkField
            .<ArgoCdAwsIdcConfigResponse> builder(MarshallingType.SDK_POJO).memberName("awsIdc")
            .getter(getter(ArgoCdConfigResponse::awsIdc)).setter(setter(Builder::awsIdc))
            .constructor(ArgoCdAwsIdcConfigResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIdc").build()).build();

    private static final SdkField<List<ArgoCdRoleMapping>> RBAC_ROLE_MAPPINGS_FIELD = SdkField
            .<List<ArgoCdRoleMapping>> builder(MarshallingType.LIST)
            .memberName("rbacRoleMappings")
            .getter(getter(ArgoCdConfigResponse::rbacRoleMappings))
            .setter(setter(Builder::rbacRoleMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rbacRoleMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArgoCdRoleMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArgoCdRoleMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ArgoCdNetworkAccessConfigResponse> NETWORK_ACCESS_FIELD = SdkField
            .<ArgoCdNetworkAccessConfigResponse> builder(MarshallingType.SDK_POJO).memberName("networkAccess")
            .getter(getter(ArgoCdConfigResponse::networkAccess)).setter(setter(Builder::networkAccess))
            .constructor(ArgoCdNetworkAccessConfigResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkAccess").build()).build();

    private static final SdkField<String> SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverUrl").getter(getter(ArgoCdConfigResponse::serverUrl)).setter(setter(Builder::serverUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD,
            AWS_IDC_FIELD, RBAC_ROLE_MAPPINGS_FIELD, NETWORK_ACCESS_FIELD, SERVER_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final ArgoCdAwsIdcConfigResponse awsIdc;

    private final List<ArgoCdRoleMapping> rbacRoleMappings;

    private final ArgoCdNetworkAccessConfigResponse networkAccess;

    private final String serverUrl;

    private ArgoCdConfigResponse(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.awsIdc = builder.awsIdc;
        this.rbacRoleMappings = builder.rbacRoleMappings;
        this.networkAccess = builder.networkAccess;
        this.serverUrl = builder.serverUrl;
    }

    /**
     * <p>
     * The Kubernetes namespace where Argo CD resources are monitored by your Argo CD Capability.
     * </p>
     * 
     * @return The Kubernetes namespace where Argo CD resources are monitored by your Argo CD Capability.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The IAM Identity CenterIAM; Identity Center integration configuration.
     * </p>
     * 
     * @return The IAM Identity CenterIAM; Identity Center integration configuration.
     */
    public final ArgoCdAwsIdcConfigResponse awsIdc() {
        return awsIdc;
    }

    /**
     * For responses, this returns true if the service returned a value for the RbacRoleMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRbacRoleMappings() {
        return rbacRoleMappings != null && !(rbacRoleMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of role mappings that define which IAM Identity CenterIAM; Identity Center users or groups have which
     * Argo CD roles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRbacRoleMappings} method.
     * </p>
     * 
     * @return The list of role mappings that define which IAM Identity CenterIAM; Identity Center users or groups have
     *         which Argo CD roles.
     */
    public final List<ArgoCdRoleMapping> rbacRoleMappings() {
        return rbacRoleMappings;
    }

    /**
     * <p>
     * The network access configuration for the Argo CD capability's managed API server endpoint. If VPC endpoint IDs
     * are specified, public access is blocked and the Argo CD server is only accessible through the specified VPC
     * endpoints.
     * </p>
     * 
     * @return The network access configuration for the Argo CD capability's managed API server endpoint. If VPC
     *         endpoint IDs are specified, public access is blocked and the Argo CD server is only accessible through
     *         the specified VPC endpoints.
     */
    public final ArgoCdNetworkAccessConfigResponse networkAccess() {
        return networkAccess;
    }

    /**
     * <p>
     * The URL of the Argo CD server. Use this URL to access the Argo CD web interface and API.
     * </p>
     * 
     * @return The URL of the Argo CD server. Use this URL to access the Argo CD web interface and API.
     */
    public final String serverUrl() {
        return serverUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(awsIdc());
        hashCode = 31 * hashCode + Objects.hashCode(hasRbacRoleMappings() ? rbacRoleMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkAccess());
        hashCode = 31 * hashCode + Objects.hashCode(serverUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArgoCdConfigResponse)) {
            return false;
        }
        ArgoCdConfigResponse other = (ArgoCdConfigResponse) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(awsIdc(), other.awsIdc())
                && hasRbacRoleMappings() == other.hasRbacRoleMappings()
                && Objects.equals(rbacRoleMappings(), other.rbacRoleMappings())
                && Objects.equals(networkAccess(), other.networkAccess()) && Objects.equals(serverUrl(), other.serverUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArgoCdConfigResponse").add("Namespace", namespace()).add("AwsIdc", awsIdc())
                .add("RbacRoleMappings", hasRbacRoleMappings() ? rbacRoleMappings() : null).add("NetworkAccess", networkAccess())
                .add("ServerUrl", serverUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "awsIdc":
            return Optional.ofNullable(clazz.cast(awsIdc()));
        case "rbacRoleMappings":
            return Optional.ofNullable(clazz.cast(rbacRoleMappings()));
        case "networkAccess":
            return Optional.ofNullable(clazz.cast(networkAccess()));
        case "serverUrl":
            return Optional.ofNullable(clazz.cast(serverUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("awsIdc", AWS_IDC_FIELD);
        map.put("rbacRoleMappings", RBAC_ROLE_MAPPINGS_FIELD);
        map.put("networkAccess", NETWORK_ACCESS_FIELD);
        map.put("serverUrl", SERVER_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArgoCdConfigResponse, T> g) {
        return obj -> g.apply((ArgoCdConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArgoCdConfigResponse> {
        /**
         * <p>
         * The Kubernetes namespace where Argo CD resources are monitored by your Argo CD Capability.
         * </p>
         * 
         * @param namespace
         *        The Kubernetes namespace where Argo CD resources are monitored by your Argo CD Capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The IAM Identity CenterIAM; Identity Center integration configuration.
         * </p>
         * 
         * @param awsIdc
         *        The IAM Identity CenterIAM; Identity Center integration configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIdc(ArgoCdAwsIdcConfigResponse awsIdc);

        /**
         * <p>
         * The IAM Identity CenterIAM; Identity Center integration configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArgoCdAwsIdcConfigResponse.Builder}
         * avoiding the need to create one manually via {@link ArgoCdAwsIdcConfigResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArgoCdAwsIdcConfigResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #awsIdc(ArgoCdAwsIdcConfigResponse)}.
         * 
         * @param awsIdc
         *        a consumer that will call methods on {@link ArgoCdAwsIdcConfigResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIdc(ArgoCdAwsIdcConfigResponse)
         */
        default Builder awsIdc(Consumer<ArgoCdAwsIdcConfigResponse.Builder> awsIdc) {
            return awsIdc(ArgoCdAwsIdcConfigResponse.builder().applyMutation(awsIdc).build());
        }

        /**
         * <p>
         * The list of role mappings that define which IAM Identity CenterIAM; Identity Center users or groups have
         * which Argo CD roles.
         * </p>
         * 
         * @param rbacRoleMappings
         *        The list of role mappings that define which IAM Identity CenterIAM; Identity Center users or groups
         *        have which Argo CD roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rbacRoleMappings(Collection<ArgoCdRoleMapping> rbacRoleMappings);

        /**
         * <p>
         * The list of role mappings that define which IAM Identity CenterIAM; Identity Center users or groups have
         * which Argo CD roles.
         * </p>
         * 
         * @param rbacRoleMappings
         *        The list of role mappings that define which IAM Identity CenterIAM; Identity Center users or groups
         *        have which Argo CD roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rbacRoleMappings(ArgoCdRoleMapping... rbacRoleMappings);

        /**
         * <p>
         * The list of role mappings that define which IAM Identity CenterIAM; Identity Center users or groups have
         * which Argo CD roles.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping.Builder#build()} is called immediately and
         * its result is passed to {@link #rbacRoleMappings(List<ArgoCdRoleMapping>)}.
         * 
         * @param rbacRoleMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rbacRoleMappings(java.util.Collection<ArgoCdRoleMapping>)
         */
        Builder rbacRoleMappings(Consumer<ArgoCdRoleMapping.Builder>... rbacRoleMappings);

        /**
         * <p>
         * The network access configuration for the Argo CD capability's managed API server endpoint. If VPC endpoint
         * IDs are specified, public access is blocked and the Argo CD server is only accessible through the specified
         * VPC endpoints.
         * </p>
         * 
         * @param networkAccess
         *        The network access configuration for the Argo CD capability's managed API server endpoint. If VPC
         *        endpoint IDs are specified, public access is blocked and the Argo CD server is only accessible through
         *        the specified VPC endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAccess(ArgoCdNetworkAccessConfigResponse networkAccess);

        /**
         * <p>
         * The network access configuration for the Argo CD capability's managed API server endpoint. If VPC endpoint
         * IDs are specified, public access is blocked and the Argo CD server is only accessible through the specified
         * VPC endpoints.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ArgoCdNetworkAccessConfigResponse.Builder} avoiding the need to create one manually via
         * {@link ArgoCdNetworkAccessConfigResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArgoCdNetworkAccessConfigResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #networkAccess(ArgoCdNetworkAccessConfigResponse)}.
         * 
         * @param networkAccess
         *        a consumer that will call methods on {@link ArgoCdNetworkAccessConfigResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAccess(ArgoCdNetworkAccessConfigResponse)
         */
        default Builder networkAccess(Consumer<ArgoCdNetworkAccessConfigResponse.Builder> networkAccess) {
            return networkAccess(ArgoCdNetworkAccessConfigResponse.builder().applyMutation(networkAccess).build());
        }

        /**
         * <p>
         * The URL of the Argo CD server. Use this URL to access the Argo CD web interface and API.
         * </p>
         * 
         * @param serverUrl
         *        The URL of the Argo CD server. Use this URL to access the Argo CD web interface and API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverUrl(String serverUrl);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private ArgoCdAwsIdcConfigResponse awsIdc;

        private List<ArgoCdRoleMapping> rbacRoleMappings = DefaultSdkAutoConstructList.getInstance();

        private ArgoCdNetworkAccessConfigResponse networkAccess;

        private String serverUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ArgoCdConfigResponse model) {
            namespace(model.namespace);
            awsIdc(model.awsIdc);
            rbacRoleMappings(model.rbacRoleMappings);
            networkAccess(model.networkAccess);
            serverUrl(model.serverUrl);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final ArgoCdAwsIdcConfigResponse.Builder getAwsIdc() {
            return awsIdc != null ? awsIdc.toBuilder() : null;
        }

        public final void setAwsIdc(ArgoCdAwsIdcConfigResponse.BuilderImpl awsIdc) {
            this.awsIdc = awsIdc != null ? awsIdc.build() : null;
        }

        @Override
        public final Builder awsIdc(ArgoCdAwsIdcConfigResponse awsIdc) {
            this.awsIdc = awsIdc;
            return this;
        }

        public final List<ArgoCdRoleMapping.Builder> getRbacRoleMappings() {
            List<ArgoCdRoleMapping.Builder> result = ArgoCdRoleMappingListCopier.copyToBuilder(this.rbacRoleMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRbacRoleMappings(Collection<ArgoCdRoleMapping.BuilderImpl> rbacRoleMappings) {
            this.rbacRoleMappings = ArgoCdRoleMappingListCopier.copyFromBuilder(rbacRoleMappings);
        }

        @Override
        public final Builder rbacRoleMappings(Collection<ArgoCdRoleMapping> rbacRoleMappings) {
            this.rbacRoleMappings = ArgoCdRoleMappingListCopier.copy(rbacRoleMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rbacRoleMappings(ArgoCdRoleMapping... rbacRoleMappings) {
            rbacRoleMappings(Arrays.asList(rbacRoleMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rbacRoleMappings(Consumer<ArgoCdRoleMapping.Builder>... rbacRoleMappings) {
            rbacRoleMappings(Stream.of(rbacRoleMappings).map(c -> ArgoCdRoleMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ArgoCdNetworkAccessConfigResponse.Builder getNetworkAccess() {
            return networkAccess != null ? networkAccess.toBuilder() : null;
        }

        public final void setNetworkAccess(ArgoCdNetworkAccessConfigResponse.BuilderImpl networkAccess) {
            this.networkAccess = networkAccess != null ? networkAccess.build() : null;
        }

        @Override
        public final Builder networkAccess(ArgoCdNetworkAccessConfigResponse networkAccess) {
            this.networkAccess = networkAccess;
            return this;
        }

        public final String getServerUrl() {
            return serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        @Override
        public ArgoCdConfigResponse build() {
            return new ArgoCdConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
