/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an add-on version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddonVersionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<AddonVersionInfo.Builder, AddonVersionInfo> {
    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonVersion").getter(getter(AddonVersionInfo::addonVersion)).setter(setter(Builder::addonVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()).build();

    private static final SdkField<List<String>> ARCHITECTURE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("architecture")
            .getter(getter(AddonVersionInfo::architecture))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> COMPUTE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("computeTypes")
            .getter(getter(AddonVersionInfo::computeTypes))
            .setter(setter(Builder::computeTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Compatibility>> COMPATIBILITIES_FIELD = SdkField
            .<List<Compatibility>> builder(MarshallingType.LIST)
            .memberName("compatibilities")
            .getter(getter(AddonVersionInfo::compatibilities))
            .setter(setter(Builder::compatibilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Compatibility> builder(MarshallingType.SDK_POJO)
                                            .constructor(Compatibility::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> REQUIRES_CONFIGURATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("requiresConfiguration").getter(getter(AddonVersionInfo::requiresConfiguration))
            .setter(setter(Builder::requiresConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiresConfiguration").build())
            .build();

    private static final SdkField<Boolean> REQUIRES_IAM_PERMISSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("requiresIamPermissions").getter(getter(AddonVersionInfo::requiresIamPermissions))
            .setter(setter(Builder::requiresIamPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiresIamPermissions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_VERSION_FIELD,
            ARCHITECTURE_FIELD, COMPUTE_TYPES_FIELD, COMPATIBILITIES_FIELD, REQUIRES_CONFIGURATION_FIELD,
            REQUIRES_IAM_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String addonVersion;

    private final List<String> architecture;

    private final List<String> computeTypes;

    private final List<Compatibility> compatibilities;

    private final Boolean requiresConfiguration;

    private final Boolean requiresIamPermissions;

    private AddonVersionInfo(BuilderImpl builder) {
        this.addonVersion = builder.addonVersion;
        this.architecture = builder.architecture;
        this.computeTypes = builder.computeTypes;
        this.compatibilities = builder.compatibilities;
        this.requiresConfiguration = builder.requiresConfiguration;
        this.requiresIamPermissions = builder.requiresIamPermissions;
    }

    /**
     * <p>
     * The version of the add-on.
     * </p>
     * 
     * @return The version of the add-on.
     */
    public final String addonVersion() {
        return addonVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Architecture property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchitecture() {
        return architecture != null && !(architecture instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The architectures that the version supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitecture} method.
     * </p>
     * 
     * @return The architectures that the version supports.
     */
    public final List<String> architecture() {
        return architecture;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputeTypes() {
        return computeTypes != null && !(computeTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the compute type of the add-on version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeTypes} method.
     * </p>
     * 
     * @return Indicates the compute type of the add-on version.
     */
    public final List<String> computeTypes() {
        return computeTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Compatibilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompatibilities() {
        return compatibilities != null && !(compatibilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object representing the compatibilities of a version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibilities} method.
     * </p>
     * 
     * @return An object representing the compatibilities of a version.
     */
    public final List<Compatibility> compatibilities() {
        return compatibilities;
    }

    /**
     * <p>
     * Whether the add-on requires configuration.
     * </p>
     * 
     * @return Whether the add-on requires configuration.
     */
    public final Boolean requiresConfiguration() {
        return requiresConfiguration;
    }

    /**
     * <p>
     * Indicates if the add-on requires IAM Permissions to operate, such as networking permissions.
     * </p>
     * 
     * @return Indicates if the add-on requires IAM Permissions to operate, such as networking permissions.
     */
    public final Boolean requiresIamPermissions() {
        return requiresIamPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasArchitecture() ? architecture() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasComputeTypes() ? computeTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCompatibilities() ? compatibilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requiresConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(requiresIamPermissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonVersionInfo)) {
            return false;
        }
        AddonVersionInfo other = (AddonVersionInfo) obj;
        return Objects.equals(addonVersion(), other.addonVersion()) && hasArchitecture() == other.hasArchitecture()
                && Objects.equals(architecture(), other.architecture()) && hasComputeTypes() == other.hasComputeTypes()
                && Objects.equals(computeTypes(), other.computeTypes()) && hasCompatibilities() == other.hasCompatibilities()
                && Objects.equals(compatibilities(), other.compatibilities())
                && Objects.equals(requiresConfiguration(), other.requiresConfiguration())
                && Objects.equals(requiresIamPermissions(), other.requiresIamPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddonVersionInfo").add("AddonVersion", addonVersion())
                .add("Architecture", hasArchitecture() ? architecture() : null)
                .add("ComputeTypes", hasComputeTypes() ? computeTypes() : null)
                .add("Compatibilities", hasCompatibilities() ? compatibilities() : null)
                .add("RequiresConfiguration", requiresConfiguration()).add("RequiresIamPermissions", requiresIamPermissions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addonVersion":
            return Optional.ofNullable(clazz.cast(addonVersion()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "computeTypes":
            return Optional.ofNullable(clazz.cast(computeTypes()));
        case "compatibilities":
            return Optional.ofNullable(clazz.cast(compatibilities()));
        case "requiresConfiguration":
            return Optional.ofNullable(clazz.cast(requiresConfiguration()));
        case "requiresIamPermissions":
            return Optional.ofNullable(clazz.cast(requiresIamPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addonVersion", ADDON_VERSION_FIELD);
        map.put("architecture", ARCHITECTURE_FIELD);
        map.put("computeTypes", COMPUTE_TYPES_FIELD);
        map.put("compatibilities", COMPATIBILITIES_FIELD);
        map.put("requiresConfiguration", REQUIRES_CONFIGURATION_FIELD);
        map.put("requiresIamPermissions", REQUIRES_IAM_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddonVersionInfo, T> g) {
        return obj -> g.apply((AddonVersionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddonVersionInfo> {
        /**
         * <p>
         * The version of the add-on.
         * </p>
         * 
         * @param addonVersion
         *        The version of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersion(String addonVersion);

        /**
         * <p>
         * The architectures that the version supports.
         * </p>
         * 
         * @param architecture
         *        The architectures that the version supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(Collection<String> architecture);

        /**
         * <p>
         * The architectures that the version supports.
         * </p>
         * 
         * @param architecture
         *        The architectures that the version supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String... architecture);

        /**
         * <p>
         * Indicates the compute type of the add-on version.
         * </p>
         * 
         * @param computeTypes
         *        Indicates the compute type of the add-on version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypes(Collection<String> computeTypes);

        /**
         * <p>
         * Indicates the compute type of the add-on version.
         * </p>
         * 
         * @param computeTypes
         *        Indicates the compute type of the add-on version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypes(String... computeTypes);

        /**
         * <p>
         * An object representing the compatibilities of a version.
         * </p>
         * 
         * @param compatibilities
         *        An object representing the compatibilities of a version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibilities(Collection<Compatibility> compatibilities);

        /**
         * <p>
         * An object representing the compatibilities of a version.
         * </p>
         * 
         * @param compatibilities
         *        An object representing the compatibilities of a version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibilities(Compatibility... compatibilities);

        /**
         * <p>
         * An object representing the compatibilities of a version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.Compatibility.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.Compatibility#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.Compatibility.Builder#build()} is called immediately and its
         * result is passed to {@link #compatibilities(List<Compatibility>)}.
         * 
         * @param compatibilities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.Compatibility.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compatibilities(java.util.Collection<Compatibility>)
         */
        Builder compatibilities(Consumer<Compatibility.Builder>... compatibilities);

        /**
         * <p>
         * Whether the add-on requires configuration.
         * </p>
         * 
         * @param requiresConfiguration
         *        Whether the add-on requires configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresConfiguration(Boolean requiresConfiguration);

        /**
         * <p>
         * Indicates if the add-on requires IAM Permissions to operate, such as networking permissions.
         * </p>
         * 
         * @param requiresIamPermissions
         *        Indicates if the add-on requires IAM Permissions to operate, such as networking permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresIamPermissions(Boolean requiresIamPermissions);
    }

    static final class BuilderImpl implements Builder {
        private String addonVersion;

        private List<String> architecture = DefaultSdkAutoConstructList.getInstance();

        private List<String> computeTypes = DefaultSdkAutoConstructList.getInstance();

        private List<Compatibility> compatibilities = DefaultSdkAutoConstructList.getInstance();

        private Boolean requiresConfiguration;

        private Boolean requiresIamPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(AddonVersionInfo model) {
            addonVersion(model.addonVersion);
            architecture(model.architecture);
            computeTypes(model.computeTypes);
            compatibilities(model.compatibilities);
            requiresConfiguration(model.requiresConfiguration);
            requiresIamPermissions(model.requiresIamPermissions);
        }

        public final String getAddonVersion() {
            return addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final Collection<String> getArchitecture() {
            if (architecture instanceof SdkAutoConstructList) {
                return null;
            }
            return architecture;
        }

        public final void setArchitecture(Collection<String> architecture) {
            this.architecture = StringListCopier.copy(architecture);
        }

        @Override
        public final Builder architecture(Collection<String> architecture) {
            this.architecture = StringListCopier.copy(architecture);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architecture(String... architecture) {
            architecture(Arrays.asList(architecture));
            return this;
        }

        public final Collection<String> getComputeTypes() {
            if (computeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return computeTypes;
        }

        public final void setComputeTypes(Collection<String> computeTypes) {
            this.computeTypes = StringListCopier.copy(computeTypes);
        }

        @Override
        public final Builder computeTypes(Collection<String> computeTypes) {
            this.computeTypes = StringListCopier.copy(computeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeTypes(String... computeTypes) {
            computeTypes(Arrays.asList(computeTypes));
            return this;
        }

        public final List<Compatibility.Builder> getCompatibilities() {
            List<Compatibility.Builder> result = CompatibilitiesCopier.copyToBuilder(this.compatibilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompatibilities(Collection<Compatibility.BuilderImpl> compatibilities) {
            this.compatibilities = CompatibilitiesCopier.copyFromBuilder(compatibilities);
        }

        @Override
        public final Builder compatibilities(Collection<Compatibility> compatibilities) {
            this.compatibilities = CompatibilitiesCopier.copy(compatibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibilities(Compatibility... compatibilities) {
            compatibilities(Arrays.asList(compatibilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibilities(Consumer<Compatibility.Builder>... compatibilities) {
            compatibilities(Stream.of(compatibilities).map(c -> Compatibility.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getRequiresConfiguration() {
            return requiresConfiguration;
        }

        public final void setRequiresConfiguration(Boolean requiresConfiguration) {
            this.requiresConfiguration = requiresConfiguration;
        }

        @Override
        public final Builder requiresConfiguration(Boolean requiresConfiguration) {
            this.requiresConfiguration = requiresConfiguration;
            return this;
        }

        public final Boolean getRequiresIamPermissions() {
            return requiresIamPermissions;
        }

        public final void setRequiresIamPermissions(Boolean requiresIamPermissions) {
            this.requiresIamPermissions = requiresIamPermissions;
        }

        @Override
        public final Builder requiresIamPermissions(Boolean requiresIamPermissions) {
            this.requiresIamPermissions = requiresIamPermissions;
            return this;
        }

        @Override
        public AddonVersionInfo build() {
            return new AddonVersionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
