/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.eks.auth.scheme.EksAuthSchemeParams;
import software.amazon.awssdk.services.eks.auth.scheme.internal.DefaultEksAuthSchemeProvider;
import software.amazon.awssdk.services.eks.auth.scheme.internal.PreferredEksAuthSchemeProvider;

@SdkPublicApi
public interface EksAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(EksAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<EksAuthSchemeParams.Builder> consumer) {
        EksAuthSchemeParams.Builder builder = EksAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static EksAuthSchemeProvider defaultProvider() {
        return DefaultEksAuthSchemeProvider.create();
    }

    public static EksAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredEksAuthSchemeProvider(EksAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

