/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePodIdentityAssociationRequest
extends EksRequest
implements ToCopyableBuilder<Builder, CreatePodIdentityAssociationRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(CreatePodIdentityAssociationRequest.getter(CreatePodIdentityAssociationRequest::clusterName)).setter(CreatePodIdentityAssociationRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(CreatePodIdentityAssociationRequest.getter(CreatePodIdentityAssociationRequest::namespace)).setter(CreatePodIdentityAssociationRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccount").getter(CreatePodIdentityAssociationRequest.getter(CreatePodIdentityAssociationRequest::serviceAccount)).setter(CreatePodIdentityAssociationRequest.setter(Builder::serviceAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccount").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreatePodIdentityAssociationRequest.getter(CreatePodIdentityAssociationRequest::roleArn)).setter(CreatePodIdentityAssociationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreatePodIdentityAssociationRequest.getter(CreatePodIdentityAssociationRequest::clientRequestToken)).setter(CreatePodIdentityAssociationRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreatePodIdentityAssociationRequest.getter(CreatePodIdentityAssociationRequest::tags)).setter(CreatePodIdentityAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NAMESPACE_FIELD, SERVICE_ACCOUNT_FIELD, ROLE_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePodIdentityAssociationRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final String namespace;
    private final String serviceAccount;
    private final String roleArn;
    private final String clientRequestToken;
    private final Map<String, String> tags;

    private CreatePodIdentityAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.namespace = builder.namespace;
        this.serviceAccount = builder.serviceAccount;
        this.roleArn = builder.roleArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String serviceAccount() {
        return this.serviceAccount;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePodIdentityAssociationRequest)) {
            return false;
        }
        CreatePodIdentityAssociationRequest other = (CreatePodIdentityAssociationRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.serviceAccount(), other.serviceAccount()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePodIdentityAssociationRequest").add("ClusterName", (Object)this.clusterName()).add("Namespace", (Object)this.namespace()).add("ServiceAccount", (Object)this.serviceAccount()).add("RoleArn", (Object)this.roleArn()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "serviceAccount": {
                return Optional.ofNullable(clazz.cast(this.serviceAccount()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("serviceAccount", SERVICE_ACCOUNT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePodIdentityAssociationRequest, T> g) {
        return obj -> g.apply((CreatePodIdentityAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String namespace;
        private String serviceAccount;
        private String roleArn;
        private String clientRequestToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePodIdentityAssociationRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.namespace(model.namespace);
            this.serviceAccount(model.serviceAccount);
            this.roleArn(model.roleArn);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getServiceAccount() {
            return this.serviceAccount;
        }

        public final void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }

        @Override
        public final Builder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePodIdentityAssociationRequest build() {
            return new CreatePodIdentityAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePodIdentityAssociationRequest> {
        public Builder clusterName(String var1);

        public Builder namespace(String var1);

        public Builder serviceAccount(String var1);

        public Builder roleArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

