/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodegroupScalingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodegroupScalingConfig> {
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minSize").getter(NodegroupScalingConfig.getter(NodegroupScalingConfig::minSize)).setter(NodegroupScalingConfig.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSize").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxSize").getter(NodegroupScalingConfig.getter(NodegroupScalingConfig::maxSize)).setter(NodegroupScalingConfig.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()}).build();
    private static final SdkField<Integer> DESIRED_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredSize").getter(NodegroupScalingConfig.getter(NodegroupScalingConfig::desiredSize)).setter(NodegroupScalingConfig.setter(Builder::desiredSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodegroupScalingConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer desiredSize;

    private NodegroupScalingConfig(BuilderImpl builder) {
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredSize = builder.desiredSize;
    }

    public final Integer minSize() {
        return this.minSize;
    }

    public final Integer maxSize() {
        return this.maxSize;
    }

    public final Integer desiredSize() {
        return this.desiredSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodegroupScalingConfig)) {
            return false;
        }
        NodegroupScalingConfig other = (NodegroupScalingConfig)obj;
        return Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.desiredSize(), other.desiredSize());
    }

    public final String toString() {
        return ToString.builder((String)"NodegroupScalingConfig").add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("DesiredSize", (Object)this.desiredSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "minSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "maxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "desiredSize": {
                return Optional.ofNullable(clazz.cast(this.desiredSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("minSize", MIN_SIZE_FIELD);
        map.put("maxSize", MAX_SIZE_FIELD);
        map.put("desiredSize", DESIRED_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodegroupScalingConfig, T> g) {
        return obj -> g.apply((NodegroupScalingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minSize;
        private Integer maxSize;
        private Integer desiredSize;

        private BuilderImpl() {
        }

        private BuilderImpl(NodegroupScalingConfig model) {
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.desiredSize(model.desiredSize);
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Integer getDesiredSize() {
            return this.desiredSize;
        }

        public final void setDesiredSize(Integer desiredSize) {
            this.desiredSize = desiredSize;
        }

        @Override
        public final Builder desiredSize(Integer desiredSize) {
            this.desiredSize = desiredSize;
            return this;
        }

        public NodegroupScalingConfig build() {
            return new NodegroupScalingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodegroupScalingConfig> {
        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder desiredSize(Integer var1);
    }
}

