/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AMITypes {
    AL2_X86_64("AL2_x86_64"),
    AL2_X86_64_GPU("AL2_x86_64_GPU"),
    AL2_ARM_64("AL2_ARM_64"),
    CUSTOM("CUSTOM"),
    BOTTLEROCKET_ARM_64("BOTTLEROCKET_ARM_64"),
    BOTTLEROCKET_X86_64("BOTTLEROCKET_x86_64"),
    BOTTLEROCKET_ARM_64_FIPS("BOTTLEROCKET_ARM_64_FIPS"),
    BOTTLEROCKET_X86_64_FIPS("BOTTLEROCKET_x86_64_FIPS"),
    BOTTLEROCKET_ARM_64_NVIDIA("BOTTLEROCKET_ARM_64_NVIDIA"),
    BOTTLEROCKET_X86_64_NVIDIA("BOTTLEROCKET_x86_64_NVIDIA"),
    WINDOWS_CORE_2019_X86_64("WINDOWS_CORE_2019_x86_64"),
    WINDOWS_FULL_2019_X86_64("WINDOWS_FULL_2019_x86_64"),
    WINDOWS_CORE_2022_X86_64("WINDOWS_CORE_2022_x86_64"),
    WINDOWS_FULL_2022_X86_64("WINDOWS_FULL_2022_x86_64"),
    AL2023_X86_64_STANDARD("AL2023_x86_64_STANDARD"),
    AL2023_ARM_64_STANDARD("AL2023_ARM_64_STANDARD"),
    AL2023_X86_64_NEURON("AL2023_x86_64_NEURON"),
    AL2023_X86_64_NVIDIA("AL2023_x86_64_NVIDIA"),
    AL2023_ARM_64_NVIDIA("AL2023_ARM_64_NVIDIA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AMITypes> VALUE_MAP;
    private final String value;

    private AMITypes(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AMITypes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AMITypes> knownValues() {
        EnumSet<AMITypes> knownValues = EnumSet.allOf(AMITypes.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AMITypes.class, AMITypes::toString);
    }
}

