/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.AssociatedAccessPolicy;
import software.amazon.awssdk.services.eks.model.ListAssociatedAccessPoliciesRequest;
import software.amazon.awssdk.services.eks.model.ListAssociatedAccessPoliciesResponse;

public class ListAssociatedAccessPoliciesIterable
implements SdkIterable<ListAssociatedAccessPoliciesResponse> {
    private final EksClient client;
    private final ListAssociatedAccessPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociatedAccessPoliciesIterable(EksClient client, ListAssociatedAccessPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssociatedAccessPoliciesResponseFetcher();
    }

    public Iterator<ListAssociatedAccessPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssociatedAccessPolicy> associatedAccessPolicies() {
        Function<ListAssociatedAccessPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.associatedAccessPolicies() != null) {
                return response.associatedAccessPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssociatedAccessPoliciesResponseFetcher
    implements SyncPageFetcher<ListAssociatedAccessPoliciesResponse> {
        private ListAssociatedAccessPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedAccessPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssociatedAccessPoliciesResponse nextPage(ListAssociatedAccessPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedAccessPoliciesIterable.this.client.listAssociatedAccessPolicies(ListAssociatedAccessPoliciesIterable.this.firstRequest);
            }
            return ListAssociatedAccessPoliciesIterable.this.client.listAssociatedAccessPolicies((ListAssociatedAccessPoliciesRequest)((Object)ListAssociatedAccessPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

