/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUpdatesResponse
extends EksResponse
implements ToCopyableBuilder<Builder, ListUpdatesResponse> {
    private static final SdkField<List<String>> UPDATE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("updateIds").getter(ListUpdatesResponse.getter(ListUpdatesResponse::updateIds)).setter(ListUpdatesResponse.setter(Builder::updateIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUpdatesResponse.getter(ListUpdatesResponse::nextToken)).setter(ListUpdatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUpdatesResponse.memberNameToFieldInitializer();
    private final List<String> updateIds;
    private final String nextToken;

    private ListUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.updateIds = builder.updateIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUpdateIds() {
        return this.updateIds != null && !(this.updateIds instanceof SdkAutoConstructList);
    }

    public final List<String> updateIds() {
        return this.updateIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdateIds() ? this.updateIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUpdatesResponse)) {
            return false;
        }
        ListUpdatesResponse other = (ListUpdatesResponse)((Object)obj);
        return this.hasUpdateIds() == other.hasUpdateIds() && Objects.equals(this.updateIds(), other.updateIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUpdatesResponse").add("UpdateIds", this.hasUpdateIds() ? this.updateIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "updateIds": {
                return Optional.ofNullable(clazz.cast(this.updateIds()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("updateIds", UPDATE_IDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUpdatesResponse, T> g) {
        return obj -> g.apply((ListUpdatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private List<String> updateIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUpdatesResponse model) {
            super(model);
            this.updateIds(model.updateIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getUpdateIds() {
            if (this.updateIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.updateIds;
        }

        public final void setUpdateIds(Collection<String> updateIds) {
            this.updateIds = StringListCopier.copy(updateIds);
        }

        @Override
        public final Builder updateIds(Collection<String> updateIds) {
            this.updateIds = StringListCopier.copy(updateIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateIds(String ... updateIds) {
            this.updateIds(Arrays.asList(updateIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUpdatesResponse build() {
            return new ListUpdatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUpdatesResponse> {
        public Builder updateIds(Collection<String> var1);

        public Builder updateIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

