/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.ControlPlanePlacementRequest;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutpostConfigRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutpostConfigRequest> {
    private static final SdkField<List<String>> OUTPOST_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outpostArns").getter(OutpostConfigRequest.getter(OutpostConfigRequest::outpostArns)).setter(OutpostConfigRequest.setter(Builder::outpostArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outpostArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTROL_PLANE_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlPlaneInstanceType").getter(OutpostConfigRequest.getter(OutpostConfigRequest::controlPlaneInstanceType)).setter(OutpostConfigRequest.setter(Builder::controlPlaneInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlPlaneInstanceType").build()}).build();
    private static final SdkField<ControlPlanePlacementRequest> CONTROL_PLANE_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("controlPlanePlacement").getter(OutpostConfigRequest.getter(OutpostConfigRequest::controlPlanePlacement)).setter(OutpostConfigRequest.setter(Builder::controlPlanePlacement)).constructor(ControlPlanePlacementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlPlanePlacement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ARNS_FIELD, CONTROL_PLANE_INSTANCE_TYPE_FIELD, CONTROL_PLANE_PLACEMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutpostConfigRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> outpostArns;
    private final String controlPlaneInstanceType;
    private final ControlPlanePlacementRequest controlPlanePlacement;

    private OutpostConfigRequest(BuilderImpl builder) {
        this.outpostArns = builder.outpostArns;
        this.controlPlaneInstanceType = builder.controlPlaneInstanceType;
        this.controlPlanePlacement = builder.controlPlanePlacement;
    }

    public final boolean hasOutpostArns() {
        return this.outpostArns != null && !(this.outpostArns instanceof SdkAutoConstructList);
    }

    public final List<String> outpostArns() {
        return this.outpostArns;
    }

    public final String controlPlaneInstanceType() {
        return this.controlPlaneInstanceType;
    }

    public final ControlPlanePlacementRequest controlPlanePlacement() {
        return this.controlPlanePlacement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutpostArns() ? this.outpostArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPlaneInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPlanePlacement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutpostConfigRequest)) {
            return false;
        }
        OutpostConfigRequest other = (OutpostConfigRequest)obj;
        return this.hasOutpostArns() == other.hasOutpostArns() && Objects.equals(this.outpostArns(), other.outpostArns()) && Objects.equals(this.controlPlaneInstanceType(), other.controlPlaneInstanceType()) && Objects.equals(this.controlPlanePlacement(), other.controlPlanePlacement());
    }

    public final String toString() {
        return ToString.builder((String)"OutpostConfigRequest").add("OutpostArns", this.hasOutpostArns() ? this.outpostArns() : null).add("ControlPlaneInstanceType", (Object)this.controlPlaneInstanceType()).add("ControlPlanePlacement", (Object)this.controlPlanePlacement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outpostArns": {
                return Optional.ofNullable(clazz.cast(this.outpostArns()));
            }
            case "controlPlaneInstanceType": {
                return Optional.ofNullable(clazz.cast(this.controlPlaneInstanceType()));
            }
            case "controlPlanePlacement": {
                return Optional.ofNullable(clazz.cast(this.controlPlanePlacement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("outpostArns", OUTPOST_ARNS_FIELD);
        map.put("controlPlaneInstanceType", CONTROL_PLANE_INSTANCE_TYPE_FIELD);
        map.put("controlPlanePlacement", CONTROL_PLANE_PLACEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutpostConfigRequest, T> g) {
        return obj -> g.apply((OutpostConfigRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> outpostArns = DefaultSdkAutoConstructList.getInstance();
        private String controlPlaneInstanceType;
        private ControlPlanePlacementRequest controlPlanePlacement;

        private BuilderImpl() {
        }

        private BuilderImpl(OutpostConfigRequest model) {
            this.outpostArns(model.outpostArns);
            this.controlPlaneInstanceType(model.controlPlaneInstanceType);
            this.controlPlanePlacement(model.controlPlanePlacement);
        }

        public final Collection<String> getOutpostArns() {
            if (this.outpostArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outpostArns;
        }

        public final void setOutpostArns(Collection<String> outpostArns) {
            this.outpostArns = StringListCopier.copy(outpostArns);
        }

        @Override
        public final Builder outpostArns(Collection<String> outpostArns) {
            this.outpostArns = StringListCopier.copy(outpostArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostArns(String ... outpostArns) {
            this.outpostArns(Arrays.asList(outpostArns));
            return this;
        }

        public final String getControlPlaneInstanceType() {
            return this.controlPlaneInstanceType;
        }

        public final void setControlPlaneInstanceType(String controlPlaneInstanceType) {
            this.controlPlaneInstanceType = controlPlaneInstanceType;
        }

        @Override
        public final Builder controlPlaneInstanceType(String controlPlaneInstanceType) {
            this.controlPlaneInstanceType = controlPlaneInstanceType;
            return this;
        }

        public final ControlPlanePlacementRequest.Builder getControlPlanePlacement() {
            return this.controlPlanePlacement != null ? this.controlPlanePlacement.toBuilder() : null;
        }

        public final void setControlPlanePlacement(ControlPlanePlacementRequest.BuilderImpl controlPlanePlacement) {
            this.controlPlanePlacement = controlPlanePlacement != null ? controlPlanePlacement.build() : null;
        }

        @Override
        public final Builder controlPlanePlacement(ControlPlanePlacementRequest controlPlanePlacement) {
            this.controlPlanePlacement = controlPlanePlacement;
            return this;
        }

        public OutpostConfigRequest build() {
            return new OutpostConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutpostConfigRequest> {
        public Builder outpostArns(Collection<String> var1);

        public Builder outpostArns(String ... var1);

        public Builder controlPlaneInstanceType(String var1);

        public Builder controlPlanePlacement(ControlPlanePlacementRequest var1);

        default public Builder controlPlanePlacement(Consumer<ControlPlanePlacementRequest.Builder> controlPlanePlacement) {
            return this.controlPlanePlacement((ControlPlanePlacementRequest)((ControlPlanePlacementRequest.Builder)ControlPlanePlacementRequest.builder().applyMutation(controlPlanePlacement)).build());
        }
    }
}

