/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientStat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientStat> {
    private static final SdkField<String> USER_AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAgent").getter(ClientStat.getter(ClientStat::userAgent)).setter(ClientStat.setter(Builder::userAgent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgent").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_REQUESTS_LAST30_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfRequestsLast30Days").getter(ClientStat.getter(ClientStat::numberOfRequestsLast30Days)).setter(ClientStat.setter(Builder::numberOfRequestsLast30Days)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRequestsLast30Days").build()}).build();
    private static final SdkField<Instant> LAST_REQUEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRequestTime").getter(ClientStat.getter(ClientStat::lastRequestTime)).setter(ClientStat.setter(Builder::lastRequestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRequestTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_AGENT_FIELD, NUMBER_OF_REQUESTS_LAST30_DAYS_FIELD, LAST_REQUEST_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("userAgent", USER_AGENT_FIELD);
            this.put("numberOfRequestsLast30Days", NUMBER_OF_REQUESTS_LAST30_DAYS_FIELD);
            this.put("lastRequestTime", LAST_REQUEST_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String userAgent;
    private final Integer numberOfRequestsLast30Days;
    private final Instant lastRequestTime;

    private ClientStat(BuilderImpl builder) {
        this.userAgent = builder.userAgent;
        this.numberOfRequestsLast30Days = builder.numberOfRequestsLast30Days;
        this.lastRequestTime = builder.lastRequestTime;
    }

    public final String userAgent() {
        return this.userAgent;
    }

    public final Integer numberOfRequestsLast30Days() {
        return this.numberOfRequestsLast30Days;
    }

    public final Instant lastRequestTime() {
        return this.lastRequestTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRequestsLast30Days());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRequestTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientStat)) {
            return false;
        }
        ClientStat other = (ClientStat)obj;
        return Objects.equals(this.userAgent(), other.userAgent()) && Objects.equals(this.numberOfRequestsLast30Days(), other.numberOfRequestsLast30Days()) && Objects.equals(this.lastRequestTime(), other.lastRequestTime());
    }

    public final String toString() {
        return ToString.builder((String)"ClientStat").add("UserAgent", (Object)this.userAgent()).add("NumberOfRequestsLast30Days", (Object)this.numberOfRequestsLast30Days()).add("LastRequestTime", (Object)this.lastRequestTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userAgent": {
                return Optional.ofNullable(clazz.cast(this.userAgent()));
            }
            case "numberOfRequestsLast30Days": {
                return Optional.ofNullable(clazz.cast(this.numberOfRequestsLast30Days()));
            }
            case "lastRequestTime": {
                return Optional.ofNullable(clazz.cast(this.lastRequestTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClientStat, T> g) {
        return obj -> g.apply((ClientStat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userAgent;
        private Integer numberOfRequestsLast30Days;
        private Instant lastRequestTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientStat model) {
            this.userAgent(model.userAgent);
            this.numberOfRequestsLast30Days(model.numberOfRequestsLast30Days);
            this.lastRequestTime(model.lastRequestTime);
        }

        public final String getUserAgent() {
            return this.userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final Integer getNumberOfRequestsLast30Days() {
            return this.numberOfRequestsLast30Days;
        }

        public final void setNumberOfRequestsLast30Days(Integer numberOfRequestsLast30Days) {
            this.numberOfRequestsLast30Days = numberOfRequestsLast30Days;
        }

        @Override
        public final Builder numberOfRequestsLast30Days(Integer numberOfRequestsLast30Days) {
            this.numberOfRequestsLast30Days = numberOfRequestsLast30Days;
            return this;
        }

        public final Instant getLastRequestTime() {
            return this.lastRequestTime;
        }

        public final void setLastRequestTime(Instant lastRequestTime) {
            this.lastRequestTime = lastRequestTime;
        }

        @Override
        public final Builder lastRequestTime(Instant lastRequestTime) {
            this.lastRequestTime = lastRequestTime;
            return this;
        }

        public ClientStat build() {
            return new ClientStat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientStat> {
        public Builder userAgent(String var1);

        public Builder numberOfRequestsLast30Days(Integer var1);

        public Builder lastRequestTime(Instant var1);
    }
}

