/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model._requiredClaimsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OidcIdentityProviderConfigRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OidcIdentityProviderConfigRequest> {
    private static final SdkField<String> IDENTITY_PROVIDER_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityProviderConfigName").getter(OidcIdentityProviderConfigRequest.getter(OidcIdentityProviderConfigRequest::identityProviderConfigName)).setter(OidcIdentityProviderConfigRequest.setter(Builder::identityProviderConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfigName").build()}).build();
    private static final SdkField<String> ISSUER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuerUrl").getter(OidcIdentityProviderConfigRequest.getter(OidcIdentityProviderConfigRequest::issuerUrl)).setter(OidcIdentityProviderConfigRequest.setter(Builder::issuerUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerUrl").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(OidcIdentityProviderConfigRequest.getter(OidcIdentityProviderConfigRequest::clientId)).setter(OidcIdentityProviderConfigRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> USERNAME_CLAIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usernameClaim").getter(OidcIdentityProviderConfigRequest.getter(OidcIdentityProviderConfigRequest::usernameClaim)).setter(OidcIdentityProviderConfigRequest.setter(Builder::usernameClaim)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernameClaim").build()}).build();
    private static final SdkField<String> USERNAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usernamePrefix").getter(OidcIdentityProviderConfigRequest.getter(OidcIdentityProviderConfigRequest::usernamePrefix)).setter(OidcIdentityProviderConfigRequest.setter(Builder::usernamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernamePrefix").build()}).build();
    private static final SdkField<String> GROUPS_CLAIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupsClaim").getter(OidcIdentityProviderConfigRequest.getter(OidcIdentityProviderConfigRequest::groupsClaim)).setter(OidcIdentityProviderConfigRequest.setter(Builder::groupsClaim)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupsClaim").build()}).build();
    private static final SdkField<String> GROUPS_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupsPrefix").getter(OidcIdentityProviderConfigRequest.getter(OidcIdentityProviderConfigRequest::groupsPrefix)).setter(OidcIdentityProviderConfigRequest.setter(Builder::groupsPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupsPrefix").build()}).build();
    private static final SdkField<Map<String, String>> REQUIRED_CLAIMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requiredClaims").getter(OidcIdentityProviderConfigRequest.getter(OidcIdentityProviderConfigRequest::requiredClaims)).setter(OidcIdentityProviderConfigRequest.setter(Builder::requiredClaims)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredClaims").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_CONFIG_NAME_FIELD, ISSUER_URL_FIELD, CLIENT_ID_FIELD, USERNAME_CLAIM_FIELD, USERNAME_PREFIX_FIELD, GROUPS_CLAIM_FIELD, GROUPS_PREFIX_FIELD, REQUIRED_CLAIMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OidcIdentityProviderConfigRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String identityProviderConfigName;
    private final String issuerUrl;
    private final String clientId;
    private final String usernameClaim;
    private final String usernamePrefix;
    private final String groupsClaim;
    private final String groupsPrefix;
    private final Map<String, String> requiredClaims;

    private OidcIdentityProviderConfigRequest(BuilderImpl builder) {
        this.identityProviderConfigName = builder.identityProviderConfigName;
        this.issuerUrl = builder.issuerUrl;
        this.clientId = builder.clientId;
        this.usernameClaim = builder.usernameClaim;
        this.usernamePrefix = builder.usernamePrefix;
        this.groupsClaim = builder.groupsClaim;
        this.groupsPrefix = builder.groupsPrefix;
        this.requiredClaims = builder.requiredClaims;
    }

    public final String identityProviderConfigName() {
        return this.identityProviderConfigName;
    }

    public final String issuerUrl() {
        return this.issuerUrl;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String usernameClaim() {
        return this.usernameClaim;
    }

    public final String usernamePrefix() {
        return this.usernamePrefix;
    }

    public final String groupsClaim() {
        return this.groupsClaim;
    }

    public final String groupsPrefix() {
        return this.groupsPrefix;
    }

    public final boolean hasRequiredClaims() {
        return this.requiredClaims != null && !(this.requiredClaims instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requiredClaims() {
        return this.requiredClaims;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernameClaim());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupsClaim());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupsPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredClaims() ? this.requiredClaims() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcIdentityProviderConfigRequest)) {
            return false;
        }
        OidcIdentityProviderConfigRequest other = (OidcIdentityProviderConfigRequest)obj;
        return Objects.equals(this.identityProviderConfigName(), other.identityProviderConfigName()) && Objects.equals(this.issuerUrl(), other.issuerUrl()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.usernameClaim(), other.usernameClaim()) && Objects.equals(this.usernamePrefix(), other.usernamePrefix()) && Objects.equals(this.groupsClaim(), other.groupsClaim()) && Objects.equals(this.groupsPrefix(), other.groupsPrefix()) && this.hasRequiredClaims() == other.hasRequiredClaims() && Objects.equals(this.requiredClaims(), other.requiredClaims());
    }

    public final String toString() {
        return ToString.builder((String)"OidcIdentityProviderConfigRequest").add("IdentityProviderConfigName", (Object)this.identityProviderConfigName()).add("IssuerUrl", (Object)this.issuerUrl()).add("ClientId", (Object)this.clientId()).add("UsernameClaim", (Object)this.usernameClaim()).add("UsernamePrefix", (Object)this.usernamePrefix()).add("GroupsClaim", (Object)this.groupsClaim()).add("GroupsPrefix", (Object)this.groupsPrefix()).add("RequiredClaims", this.hasRequiredClaims() ? this.requiredClaims() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identityProviderConfigName": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfigName()));
            }
            case "issuerUrl": {
                return Optional.ofNullable(clazz.cast(this.issuerUrl()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "usernameClaim": {
                return Optional.ofNullable(clazz.cast(this.usernameClaim()));
            }
            case "usernamePrefix": {
                return Optional.ofNullable(clazz.cast(this.usernamePrefix()));
            }
            case "groupsClaim": {
                return Optional.ofNullable(clazz.cast(this.groupsClaim()));
            }
            case "groupsPrefix": {
                return Optional.ofNullable(clazz.cast(this.groupsPrefix()));
            }
            case "requiredClaims": {
                return Optional.ofNullable(clazz.cast(this.requiredClaims()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identityProviderConfigName", IDENTITY_PROVIDER_CONFIG_NAME_FIELD);
        map.put("issuerUrl", ISSUER_URL_FIELD);
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("usernameClaim", USERNAME_CLAIM_FIELD);
        map.put("usernamePrefix", USERNAME_PREFIX_FIELD);
        map.put("groupsClaim", GROUPS_CLAIM_FIELD);
        map.put("groupsPrefix", GROUPS_PREFIX_FIELD);
        map.put("requiredClaims", REQUIRED_CLAIMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OidcIdentityProviderConfigRequest, T> g) {
        return obj -> g.apply((OidcIdentityProviderConfigRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityProviderConfigName;
        private String issuerUrl;
        private String clientId;
        private String usernameClaim;
        private String usernamePrefix;
        private String groupsClaim;
        private String groupsPrefix;
        private Map<String, String> requiredClaims = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OidcIdentityProviderConfigRequest model) {
            this.identityProviderConfigName(model.identityProviderConfigName);
            this.issuerUrl(model.issuerUrl);
            this.clientId(model.clientId);
            this.usernameClaim(model.usernameClaim);
            this.usernamePrefix(model.usernamePrefix);
            this.groupsClaim(model.groupsClaim);
            this.groupsPrefix(model.groupsPrefix);
            this.requiredClaims(model.requiredClaims);
        }

        public final String getIdentityProviderConfigName() {
            return this.identityProviderConfigName;
        }

        public final void setIdentityProviderConfigName(String identityProviderConfigName) {
            this.identityProviderConfigName = identityProviderConfigName;
        }

        @Override
        public final Builder identityProviderConfigName(String identityProviderConfigName) {
            this.identityProviderConfigName = identityProviderConfigName;
            return this;
        }

        public final String getIssuerUrl() {
            return this.issuerUrl;
        }

        public final void setIssuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
        }

        @Override
        public final Builder issuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getUsernameClaim() {
            return this.usernameClaim;
        }

        public final void setUsernameClaim(String usernameClaim) {
            this.usernameClaim = usernameClaim;
        }

        @Override
        public final Builder usernameClaim(String usernameClaim) {
            this.usernameClaim = usernameClaim;
            return this;
        }

        public final String getUsernamePrefix() {
            return this.usernamePrefix;
        }

        public final void setUsernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
        }

        @Override
        public final Builder usernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
            return this;
        }

        public final String getGroupsClaim() {
            return this.groupsClaim;
        }

        public final void setGroupsClaim(String groupsClaim) {
            this.groupsClaim = groupsClaim;
        }

        @Override
        public final Builder groupsClaim(String groupsClaim) {
            this.groupsClaim = groupsClaim;
            return this;
        }

        public final String getGroupsPrefix() {
            return this.groupsPrefix;
        }

        public final void setGroupsPrefix(String groupsPrefix) {
            this.groupsPrefix = groupsPrefix;
        }

        @Override
        public final Builder groupsPrefix(String groupsPrefix) {
            this.groupsPrefix = groupsPrefix;
            return this;
        }

        public final Map<String, String> getRequiredClaims() {
            if (this.requiredClaims instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requiredClaims;
        }

        public final void setRequiredClaims(Map<String, String> requiredClaims) {
            this.requiredClaims = _requiredClaimsMapCopier.copy(requiredClaims);
        }

        @Override
        public final Builder requiredClaims(Map<String, String> requiredClaims) {
            this.requiredClaims = _requiredClaimsMapCopier.copy(requiredClaims);
            return this;
        }

        public OidcIdentityProviderConfigRequest build() {
            return new OidcIdentityProviderConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OidcIdentityProviderConfigRequest> {
        public Builder identityProviderConfigName(String var1);

        public Builder issuerUrl(String var1);

        public Builder clientId(String var1);

        public Builder usernameClaim(String var1);

        public Builder usernamePrefix(String var1);

        public Builder groupsClaim(String var1);

        public Builder groupsPrefix(String var1);

        public Builder requiredClaims(Map<String, String> var1);
    }
}

