/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoteNodeNetwork
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemoteNodeNetwork> {
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cidrs").getter(RemoteNodeNetwork.getter(RemoteNodeNetwork::cidrs)).setter(RemoteNodeNetwork.setter(Builder::cidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDRS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cidrs", CIDRS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> cidrs;

    private RemoteNodeNetwork(BuilderImpl builder) {
        this.cidrs = builder.cidrs;
    }

    public final boolean hasCidrs() {
        return this.cidrs != null && !(this.cidrs instanceof SdkAutoConstructList);
    }

    public final List<String> cidrs() {
        return this.cidrs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrs() ? this.cidrs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteNodeNetwork)) {
            return false;
        }
        RemoteNodeNetwork other = (RemoteNodeNetwork)obj;
        return this.hasCidrs() == other.hasCidrs() && Objects.equals(this.cidrs(), other.cidrs());
    }

    public final String toString() {
        return ToString.builder((String)"RemoteNodeNetwork").add("Cidrs", this.hasCidrs() ? this.cidrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cidrs": {
                return Optional.ofNullable(clazz.cast(this.cidrs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemoteNodeNetwork, T> g) {
        return obj -> g.apply((RemoteNodeNetwork)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteNodeNetwork model) {
            this.cidrs(model.cidrs);
        }

        public final Collection<String> getCidrs() {
            if (this.cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrs;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = StringListCopier.copy(cidrs);
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = StringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String ... cidrs) {
            this.cidrs(Arrays.asList(cidrs));
            return this;
        }

        public RemoteNodeNetwork build() {
            return new RemoteNodeNetwork(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemoteNodeNetwork> {
        public Builder cidrs(Collection<String> var1);

        public Builder cidrs(String ... var1);
    }
}

