/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AddonIssueCode {
    ACCESS_DENIED("AccessDenied"),
    INTERNAL_FAILURE("InternalFailure"),
    CLUSTER_UNREACHABLE("ClusterUnreachable"),
    INSUFFICIENT_NUMBER_OF_REPLICAS("InsufficientNumberOfReplicas"),
    CONFIGURATION_CONFLICT("ConfigurationConflict"),
    ADMISSION_REQUEST_DENIED("AdmissionRequestDenied"),
    UNSUPPORTED_ADDON_MODIFICATION("UnsupportedAddonModification"),
    K8_S_RESOURCE_NOT_FOUND("K8sResourceNotFound"),
    ADDON_SUBSCRIPTION_NEEDED("AddonSubscriptionNeeded"),
    ADDON_PERMISSION_FAILURE("AddonPermissionFailure"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AddonIssueCode> VALUE_MAP;
    private final String value;

    private AddonIssueCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AddonIssueCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AddonIssueCode> knownValues() {
        EnumSet<AddonIssueCode> knownValues = EnumSet.allOf(AddonIssueCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AddonIssueCode.class, AddonIssueCode::toString);
    }
}

