/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.AddonHealth;
import software.amazon.awssdk.services.eks.model.AddonStatus;
import software.amazon.awssdk.services.eks.model.MarketplaceInformation;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Addon
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Addon> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonName").getter(Addon.getter(Addon::addonName)).setter(Addon.setter(Builder::addonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(Addon.getter(Addon::clusterName)).setter(Addon.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Addon.getter(Addon::statusAsString)).setter(Addon.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonVersion").getter(Addon.getter(Addon::addonVersion)).setter(Addon.setter(Builder::addonVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()}).build();
    private static final SdkField<AddonHealth> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("health").getter(Addon.getter(Addon::health)).setter(Addon.setter(Builder::health)).constructor(AddonHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()}).build();
    private static final SdkField<String> ADDON_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonArn").getter(Addon.getter(Addon::addonArn)).setter(Addon.setter(Builder::addonArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Addon.getter(Addon::createdAt)).setter(Addon.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(Addon.getter(Addon::modifiedAt)).setter(Addon.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccountRoleArn").getter(Addon.getter(Addon::serviceAccountRoleArn)).setter(Addon.setter(Builder::serviceAccountRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountRoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Addon.getter(Addon::tags)).setter(Addon.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLISHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publisher").getter(Addon.getter(Addon::publisher)).setter(Addon.setter(Builder::publisher)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publisher").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(Addon.getter(Addon::owner)).setter(Addon.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<MarketplaceInformation> MARKETPLACE_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("marketplaceInformation").getter(Addon.getter(Addon::marketplaceInformation)).setter(Addon.setter(Builder::marketplaceInformation)).constructor(MarketplaceInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marketplaceInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD, CLUSTER_NAME_FIELD, STATUS_FIELD, ADDON_VERSION_FIELD, HEALTH_FIELD, ADDON_ARN_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, SERVICE_ACCOUNT_ROLE_ARN_FIELD, TAGS_FIELD, PUBLISHER_FIELD, OWNER_FIELD, MARKETPLACE_INFORMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String addonName;
    private final String clusterName;
    private final String status;
    private final String addonVersion;
    private final AddonHealth health;
    private final String addonArn;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String serviceAccountRoleArn;
    private final Map<String, String> tags;
    private final String publisher;
    private final String owner;
    private final MarketplaceInformation marketplaceInformation;

    private Addon(BuilderImpl builder) {
        this.addonName = builder.addonName;
        this.clusterName = builder.clusterName;
        this.status = builder.status;
        this.addonVersion = builder.addonVersion;
        this.health = builder.health;
        this.addonArn = builder.addonArn;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.serviceAccountRoleArn = builder.serviceAccountRoleArn;
        this.tags = builder.tags;
        this.publisher = builder.publisher;
        this.owner = builder.owner;
        this.marketplaceInformation = builder.marketplaceInformation;
    }

    public final String addonName() {
        return this.addonName;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final AddonStatus status() {
        return AddonStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String addonVersion() {
        return this.addonVersion;
    }

    public final AddonHealth health() {
        return this.health;
    }

    public final String addonArn() {
        return this.addonArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String serviceAccountRoleArn() {
        return this.serviceAccountRoleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String publisher() {
        return this.publisher;
    }

    public final String owner() {
        return this.owner;
    }

    public final MarketplaceInformation marketplaceInformation() {
        return this.marketplaceInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.health());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publisher());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketplaceInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Addon)) {
            return false;
        }
        Addon other = (Addon)obj;
        return Objects.equals(this.addonName(), other.addonName()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.addonVersion(), other.addonVersion()) && Objects.equals(this.health(), other.health()) && Objects.equals(this.addonArn(), other.addonArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.serviceAccountRoleArn(), other.serviceAccountRoleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.publisher(), other.publisher()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.marketplaceInformation(), other.marketplaceInformation());
    }

    public final String toString() {
        return ToString.builder((String)"Addon").add("AddonName", (Object)this.addonName()).add("ClusterName", (Object)this.clusterName()).add("Status", (Object)this.statusAsString()).add("AddonVersion", (Object)this.addonVersion()).add("Health", (Object)this.health()).add("AddonArn", (Object)this.addonArn()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("ServiceAccountRoleArn", (Object)this.serviceAccountRoleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Publisher", (Object)this.publisher()).add("Owner", (Object)this.owner()).add("MarketplaceInformation", (Object)this.marketplaceInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addonName": {
                return Optional.ofNullable(clazz.cast(this.addonName()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "addonVersion": {
                return Optional.ofNullable(clazz.cast(this.addonVersion()));
            }
            case "health": {
                return Optional.ofNullable(clazz.cast(this.health()));
            }
            case "addonArn": {
                return Optional.ofNullable(clazz.cast(this.addonArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "serviceAccountRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountRoleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "publisher": {
                return Optional.ofNullable(clazz.cast(this.publisher()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "marketplaceInformation": {
                return Optional.ofNullable(clazz.cast(this.marketplaceInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Addon, T> g) {
        return obj -> g.apply((Addon)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addonName;
        private String clusterName;
        private String status;
        private String addonVersion;
        private AddonHealth health;
        private String addonArn;
        private Instant createdAt;
        private Instant modifiedAt;
        private String serviceAccountRoleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String publisher;
        private String owner;
        private MarketplaceInformation marketplaceInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(Addon model) {
            this.addonName(model.addonName);
            this.clusterName(model.clusterName);
            this.status(model.status);
            this.addonVersion(model.addonVersion);
            this.health(model.health);
            this.addonArn(model.addonArn);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.serviceAccountRoleArn(model.serviceAccountRoleArn);
            this.tags(model.tags);
            this.publisher(model.publisher);
            this.owner(model.owner);
            this.marketplaceInformation(model.marketplaceInformation);
        }

        public final String getAddonName() {
            return this.addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AddonStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAddonVersion() {
            return this.addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final AddonHealth.Builder getHealth() {
            return this.health != null ? this.health.toBuilder() : null;
        }

        public final void setHealth(AddonHealth.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        public final Builder health(AddonHealth health) {
            this.health = health;
            return this;
        }

        public final String getAddonArn() {
            return this.addonArn;
        }

        public final void setAddonArn(String addonArn) {
            this.addonArn = addonArn;
        }

        @Override
        public final Builder addonArn(String addonArn) {
            this.addonArn = addonArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getServiceAccountRoleArn() {
            return this.serviceAccountRoleArn;
        }

        public final void setServiceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
        }

        @Override
        public final Builder serviceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getPublisher() {
            return this.publisher;
        }

        public final void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        @Override
        public final Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final MarketplaceInformation.Builder getMarketplaceInformation() {
            return this.marketplaceInformation != null ? this.marketplaceInformation.toBuilder() : null;
        }

        public final void setMarketplaceInformation(MarketplaceInformation.BuilderImpl marketplaceInformation) {
            this.marketplaceInformation = marketplaceInformation != null ? marketplaceInformation.build() : null;
        }

        @Override
        public final Builder marketplaceInformation(MarketplaceInformation marketplaceInformation) {
            this.marketplaceInformation = marketplaceInformation;
            return this;
        }

        public Addon build() {
            return new Addon(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Addon> {
        public Builder addonName(String var1);

        public Builder clusterName(String var1);

        public Builder status(String var1);

        public Builder status(AddonStatus var1);

        public Builder addonVersion(String var1);

        public Builder health(AddonHealth var1);

        default public Builder health(Consumer<AddonHealth.Builder> health) {
            return this.health((AddonHealth)((AddonHealth.Builder)AddonHealth.builder().applyMutation(health)).build());
        }

        public Builder addonArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder serviceAccountRoleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder publisher(String var1);

        public Builder owner(String var1);

        public Builder marketplaceInformation(MarketplaceInformation var1);

        default public Builder marketplaceInformation(Consumer<MarketplaceInformation.Builder> marketplaceInformation) {
            return this.marketplaceInformation((MarketplaceInformation)((MarketplaceInformation.Builder)MarketplaceInformation.builder().applyMutation(marketplaceInformation)).build());
        }
    }
}

