/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ErrorCode {
    SUBNET_NOT_FOUND("SubnetNotFound"),
    SECURITY_GROUP_NOT_FOUND("SecurityGroupNotFound"),
    ENI_LIMIT_REACHED("EniLimitReached"),
    IP_NOT_AVAILABLE("IpNotAvailable"),
    ACCESS_DENIED("AccessDenied"),
    OPERATION_NOT_PERMITTED("OperationNotPermitted"),
    VPC_ID_NOT_FOUND("VpcIdNotFound"),
    UNKNOWN("Unknown"),
    NODE_CREATION_FAILURE("NodeCreationFailure"),
    POD_EVICTION_FAILURE("PodEvictionFailure"),
    INSUFFICIENT_FREE_ADDRESSES("InsufficientFreeAddresses"),
    CLUSTER_UNREACHABLE("ClusterUnreachable"),
    INSUFFICIENT_NUMBER_OF_REPLICAS("InsufficientNumberOfReplicas"),
    CONFIGURATION_CONFLICT("ConfigurationConflict"),
    ADMISSION_REQUEST_DENIED("AdmissionRequestDenied"),
    UNSUPPORTED_ADDON_MODIFICATION("UnsupportedAddonModification"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        return Stream.of(ErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

