/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAddonRequest
extends EksRequest
implements ToCopyableBuilder<Builder, DeleteAddonRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(DeleteAddonRequest.getter(DeleteAddonRequest::clusterName)).setter(DeleteAddonRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonName").getter(DeleteAddonRequest.getter(DeleteAddonRequest::addonName)).setter(DeleteAddonRequest.setter(Builder::addonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("addonName").build()}).build();
    private static final SdkField<Boolean> PRESERVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("preserve").getter(DeleteAddonRequest.getter(DeleteAddonRequest::preserve)).setter(DeleteAddonRequest.setter(Builder::preserve)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("preserve").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, ADDON_NAME_FIELD, PRESERVE_FIELD));
    private final String clusterName;
    private final String addonName;
    private final Boolean preserve;

    private DeleteAddonRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.addonName = builder.addonName;
        this.preserve = builder.preserve;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String addonName() {
        return this.addonName;
    }

    public final Boolean preserve() {
        return this.preserve;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preserve());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAddonRequest)) {
            return false;
        }
        DeleteAddonRequest other = (DeleteAddonRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.addonName(), other.addonName()) && Objects.equals(this.preserve(), other.preserve());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAddonRequest").add("ClusterName", (Object)this.clusterName()).add("AddonName", (Object)this.addonName()).add("Preserve", (Object)this.preserve()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "addonName": {
                return Optional.ofNullable(clazz.cast(this.addonName()));
            }
            case "preserve": {
                return Optional.ofNullable(clazz.cast(this.preserve()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAddonRequest, T> g) {
        return obj -> g.apply((DeleteAddonRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String addonName;
        private Boolean preserve;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAddonRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.addonName(model.addonName);
            this.preserve(model.preserve);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        @Transient
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getAddonName() {
            return this.addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        @Transient
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final Boolean getPreserve() {
            return this.preserve;
        }

        public final void setPreserve(Boolean preserve) {
            this.preserve = preserve;
        }

        @Override
        @Transient
        public final Builder preserve(Boolean preserve) {
            this.preserve = preserve;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAddonRequest build() {
            return new DeleteAddonRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAddonRequest> {
        public Builder clusterName(String var1);

        public Builder addonName(String var1);

        public Builder preserve(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

