/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConnectorConfigProvider {
    EKS_ANYWHERE("EKS_ANYWHERE"),
    ANTHOS("ANTHOS"),
    GKE("GKE"),
    AKS("AKS"),
    OPENSHIFT("OPENSHIFT"),
    TANZU("TANZU"),
    RANCHER("RANCHER"),
    EC2("EC2"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConnectorConfigProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorConfigProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConnectorConfigProvider.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorConfigProvider> knownValues() {
        return Stream.of(ConnectorConfigProvider.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

