/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorConfigResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorConfigResponse> {
    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activationId").getter(ConnectorConfigResponse.getter(ConnectorConfigResponse::activationId)).setter(ConnectorConfigResponse.setter(Builder::activationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationId").build()}).build();
    private static final SdkField<String> ACTIVATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activationCode").getter(ConnectorConfigResponse.getter(ConnectorConfigResponse::activationCode)).setter(ConnectorConfigResponse.setter(Builder::activationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationCode").build()}).build();
    private static final SdkField<Instant> ACTIVATION_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("activationExpiry").getter(ConnectorConfigResponse.getter(ConnectorConfigResponse::activationExpiry)).setter(ConnectorConfigResponse.setter(Builder::activationExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationExpiry").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(ConnectorConfigResponse.getter(ConnectorConfigResponse::provider)).setter(ConnectorConfigResponse.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ConnectorConfigResponse.getter(ConnectorConfigResponse::roleArn)).setter(ConnectorConfigResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_ID_FIELD, ACTIVATION_CODE_FIELD, ACTIVATION_EXPIRY_FIELD, PROVIDER_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activationId;
    private final String activationCode;
    private final Instant activationExpiry;
    private final String provider;
    private final String roleArn;

    private ConnectorConfigResponse(BuilderImpl builder) {
        this.activationId = builder.activationId;
        this.activationCode = builder.activationCode;
        this.activationExpiry = builder.activationExpiry;
        this.provider = builder.provider;
        this.roleArn = builder.roleArn;
    }

    public final String activationId() {
        return this.activationId;
    }

    public final String activationCode() {
        return this.activationCode;
    }

    public final Instant activationExpiry() {
        return this.activationExpiry;
    }

    public final String provider() {
        return this.provider;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorConfigResponse)) {
            return false;
        }
        ConnectorConfigResponse other = (ConnectorConfigResponse)obj;
        return Objects.equals(this.activationId(), other.activationId()) && Objects.equals(this.activationCode(), other.activationCode()) && Objects.equals(this.activationExpiry(), other.activationExpiry()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorConfigResponse").add("ActivationId", (Object)this.activationId()).add("ActivationCode", (Object)this.activationCode()).add("ActivationExpiry", (Object)this.activationExpiry()).add("Provider", (Object)this.provider()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activationId": {
                return Optional.ofNullable(clazz.cast(this.activationId()));
            }
            case "activationCode": {
                return Optional.ofNullable(clazz.cast(this.activationCode()));
            }
            case "activationExpiry": {
                return Optional.ofNullable(clazz.cast(this.activationExpiry()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorConfigResponse, T> g) {
        return obj -> g.apply((ConnectorConfigResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activationId;
        private String activationCode;
        private Instant activationExpiry;
        private String provider;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorConfigResponse model) {
            this.activationId(model.activationId);
            this.activationCode(model.activationCode);
            this.activationExpiry(model.activationExpiry);
            this.provider(model.provider);
            this.roleArn(model.roleArn);
        }

        public final String getActivationId() {
            return this.activationId;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        @Override
        @Transient
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final String getActivationCode() {
            return this.activationCode;
        }

        public final void setActivationCode(String activationCode) {
            this.activationCode = activationCode;
        }

        @Override
        @Transient
        public final Builder activationCode(String activationCode) {
            this.activationCode = activationCode;
            return this;
        }

        public final Instant getActivationExpiry() {
            return this.activationExpiry;
        }

        public final void setActivationExpiry(Instant activationExpiry) {
            this.activationExpiry = activationExpiry;
        }

        @Override
        @Transient
        public final Builder activationExpiry(Instant activationExpiry) {
            this.activationExpiry = activationExpiry;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        @Transient
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public ConnectorConfigResponse build() {
            return new ConnectorConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorConfigResponse> {
        public Builder activationId(String var1);

        public Builder activationCode(String var1);

        public Builder activationExpiry(Instant var1);

        public Builder provider(String var1);

        public Builder roleArn(String var1);
    }
}

