/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AddonIssueCode {
    ACCESS_DENIED("AccessDenied"),
    INTERNAL_FAILURE("InternalFailure"),
    CLUSTER_UNREACHABLE("ClusterUnreachable"),
    INSUFFICIENT_NUMBER_OF_REPLICAS("InsufficientNumberOfReplicas"),
    CONFIGURATION_CONFLICT("ConfigurationConflict"),
    ADMISSION_REQUEST_DENIED("AdmissionRequestDenied"),
    UNSUPPORTED_ADDON_MODIFICATION("UnsupportedAddonModification"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AddonIssueCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AddonIssueCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AddonIssueCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AddonIssueCode> knownValues() {
        return Stream.of(AddonIssueCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

