/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.model.ListUpdatesRequest;
import software.amazon.awssdk.services.eks.model.ListUpdatesResponse;

public class ListUpdatesIterable
implements SdkIterable<ListUpdatesResponse> {
    private final EksClient client;
    private final ListUpdatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUpdatesIterable(EksClient client, ListUpdatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUpdatesResponseFetcher();
    }

    public Iterator<ListUpdatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> updateIds() {
        Function<ListUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.updateIds() != null) {
                return response.updateIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUpdatesResponseFetcher
    implements SyncPageFetcher<ListUpdatesResponse> {
        private ListUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(ListUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUpdatesResponse nextPage(ListUpdatesResponse previousPage) {
            if (previousPage == null) {
                return ListUpdatesIterable.this.client.listUpdates(ListUpdatesIterable.this.firstRequest);
            }
            return ListUpdatesIterable.this.client.listUpdates((ListUpdatesRequest)((Object)ListUpdatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

