/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUpdateRequest extends EksRequest implements
        ToCopyableBuilder<DescribeUpdateRequest.Builder, DescribeUpdateRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUpdateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> UPDATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUpdateRequest::updateId)).setter(setter(Builder::updateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("updateId").build()).build();

    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUpdateRequest::nodegroupName)).setter(setter(Builder::nodegroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nodegroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, UPDATE_ID_FIELD,
            NODEGROUP_NAME_FIELD));

    private final String name;

    private final String updateId;

    private final String nodegroupName;

    private DescribeUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.updateId = builder.updateId;
        this.nodegroupName = builder.nodegroupName;
    }

    /**
     * <p>
     * The name of the Amazon EKS cluster associated with the update.
     * </p>
     * 
     * @return The name of the Amazon EKS cluster associated with the update.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the update to describe.
     * </p>
     * 
     * @return The ID of the update to describe.
     */
    public String updateId() {
        return updateId;
    }

    /**
     * <p>
     * The name of the Amazon EKS node group associated with the update.
     * </p>
     * 
     * @return The name of the Amazon EKS node group associated with the update.
     */
    public String nodegroupName() {
        return nodegroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(updateId());
        hashCode = 31 * hashCode + Objects.hashCode(nodegroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUpdateRequest)) {
            return false;
        }
        DescribeUpdateRequest other = (DescribeUpdateRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(updateId(), other.updateId())
                && Objects.equals(nodegroupName(), other.nodegroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUpdateRequest").add("Name", name()).add("UpdateId", updateId())
                .add("NodegroupName", nodegroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "updateId":
            return Optional.ofNullable(clazz.cast(updateId()));
        case "nodegroupName":
            return Optional.ofNullable(clazz.cast(nodegroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUpdateRequest, T> g) {
        return obj -> g.apply((DescribeUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUpdateRequest> {
        /**
         * <p>
         * The name of the Amazon EKS cluster associated with the update.
         * </p>
         * 
         * @param name
         *        The name of the Amazon EKS cluster associated with the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the update to describe.
         * </p>
         * 
         * @param updateId
         *        The ID of the update to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateId(String updateId);

        /**
         * <p>
         * The name of the Amazon EKS node group associated with the update.
         * </p>
         * 
         * @param nodegroupName
         *        The name of the Amazon EKS node group associated with the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupName(String nodegroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String name;

        private String updateId;

        private String nodegroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUpdateRequest model) {
            super(model);
            name(model.name);
            updateId(model.updateId);
            nodegroupName(model.nodegroupName);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getUpdateId() {
            return updateId;
        }

        @Override
        public final Builder updateId(String updateId) {
            this.updateId = updateId;
            return this;
        }

        public final void setUpdateId(String updateId) {
            this.updateId = updateId;
        }

        public final String getNodegroupName() {
            return nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUpdateRequest build() {
            return new DescribeUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
