/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.FargateProfileSelector;
import software.amazon.awssdk.services.eks.model.FargateProfileSelectorsCopier;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFargateProfileRequest
extends EksRequest
implements ToCopyableBuilder<Builder, CreateFargateProfileRequest> {
    private static final SdkField<String> FARGATE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFargateProfileRequest.getter(CreateFargateProfileRequest::fargateProfileName)).setter(CreateFargateProfileRequest.setter(Builder::fargateProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileName").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFargateProfileRequest.getter(CreateFargateProfileRequest::clusterName)).setter(CreateFargateProfileRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> POD_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFargateProfileRequest.getter(CreateFargateProfileRequest::podExecutionRoleArn)).setter(CreateFargateProfileRequest.setter(Builder::podExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podExecutionRoleArn").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateFargateProfileRequest.getter(CreateFargateProfileRequest::subnets)).setter(CreateFargateProfileRequest.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FargateProfileSelector>> SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateFargateProfileRequest.getter(CreateFargateProfileRequest::selectors)).setter(CreateFargateProfileRequest.setter(Builder::selectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FargateProfileSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFargateProfileRequest.getter(CreateFargateProfileRequest::clientRequestToken)).setter(CreateFargateProfileRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateFargateProfileRequest.getter(CreateFargateProfileRequest::tags)).setter(CreateFargateProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARGATE_PROFILE_NAME_FIELD, CLUSTER_NAME_FIELD, POD_EXECUTION_ROLE_ARN_FIELD, SUBNETS_FIELD, SELECTORS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private final String fargateProfileName;
    private final String clusterName;
    private final String podExecutionRoleArn;
    private final List<String> subnets;
    private final List<FargateProfileSelector> selectors;
    private final String clientRequestToken;
    private final Map<String, String> tags;

    private CreateFargateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.fargateProfileName = builder.fargateProfileName;
        this.clusterName = builder.clusterName;
        this.podExecutionRoleArn = builder.podExecutionRoleArn;
        this.subnets = builder.subnets;
        this.selectors = builder.selectors;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public String fargateProfileName() {
        return this.fargateProfileName;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String podExecutionRoleArn() {
        return this.podExecutionRoleArn;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<FargateProfileSelector> selectors() {
        return this.selectors;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fargateProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.podExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFargateProfileRequest)) {
            return false;
        }
        CreateFargateProfileRequest other = (CreateFargateProfileRequest)((Object)obj);
        return Objects.equals(this.fargateProfileName(), other.fargateProfileName()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.podExecutionRoleArn(), other.podExecutionRoleArn()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.selectors(), other.selectors()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateFargateProfileRequest").add("FargateProfileName", (Object)this.fargateProfileName()).add("ClusterName", (Object)this.clusterName()).add("PodExecutionRoleArn", (Object)this.podExecutionRoleArn()).add("Subnets", this.subnets()).add("Selectors", this.selectors()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fargateProfileName": {
                return Optional.ofNullable(clazz.cast(this.fargateProfileName()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "podExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.podExecutionRoleArn()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "selectors": {
                return Optional.ofNullable(clazz.cast(this.selectors()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFargateProfileRequest, T> g) {
        return obj -> g.apply((CreateFargateProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String fargateProfileName;
        private String clusterName;
        private String podExecutionRoleArn;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<FargateProfileSelector> selectors = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFargateProfileRequest model) {
            super(model);
            this.fargateProfileName(model.fargateProfileName);
            this.clusterName(model.clusterName);
            this.podExecutionRoleArn(model.podExecutionRoleArn);
            this.subnets(model.subnets);
            this.selectors(model.selectors);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getFargateProfileName() {
            return this.fargateProfileName;
        }

        @Override
        public final Builder fargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
            return this;
        }

        public final void setFargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getPodExecutionRoleArn() {
            return this.podExecutionRoleArn;
        }

        @Override
        public final Builder podExecutionRoleArn(String podExecutionRoleArn) {
            this.podExecutionRoleArn = podExecutionRoleArn;
            return this;
        }

        public final void setPodExecutionRoleArn(String podExecutionRoleArn) {
            this.podExecutionRoleArn = podExecutionRoleArn;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<FargateProfileSelector.Builder> getSelectors() {
            return this.selectors != null ? (Collection)this.selectors.stream().map(FargateProfileSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder selectors(Collection<FargateProfileSelector> selectors) {
            this.selectors = FargateProfileSelectorsCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(FargateProfileSelector ... selectors) {
            this.selectors(Arrays.asList(selectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Consumer<FargateProfileSelector.Builder> ... selectors) {
            this.selectors(Stream.of(selectors).map(c -> (FargateProfileSelector)((FargateProfileSelector.Builder)FargateProfileSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSelectors(Collection<FargateProfileSelector.BuilderImpl> selectors) {
            this.selectors = FargateProfileSelectorsCopier.copyFromBuilder(selectors);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFargateProfileRequest build() {
            return new CreateFargateProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFargateProfileRequest> {
        public Builder fargateProfileName(String var1);

        public Builder clusterName(String var1);

        public Builder podExecutionRoleArn(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder selectors(Collection<FargateProfileSelector> var1);

        public Builder selectors(FargateProfileSelector ... var1);

        public Builder selectors(Consumer<FargateProfileSelector.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

