/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.eks.DefaultEksClientBuilder;
import software.amazon.awssdk.services.eks.EksClientBuilder;
import software.amazon.awssdk.services.eks.model.ClientException;
import software.amazon.awssdk.services.eks.model.CreateClusterRequest;
import software.amazon.awssdk.services.eks.model.CreateClusterResponse;
import software.amazon.awssdk.services.eks.model.DeleteClusterRequest;
import software.amazon.awssdk.services.eks.model.DeleteClusterResponse;
import software.amazon.awssdk.services.eks.model.DescribeClusterRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterResponse;
import software.amazon.awssdk.services.eks.model.EksException;
import software.amazon.awssdk.services.eks.model.InvalidParameterException;
import software.amazon.awssdk.services.eks.model.ListClustersRequest;
import software.amazon.awssdk.services.eks.model.ListClustersResponse;
import software.amazon.awssdk.services.eks.model.ResourceInUseException;
import software.amazon.awssdk.services.eks.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.eks.model.ResourceNotFoundException;
import software.amazon.awssdk.services.eks.model.ServerException;
import software.amazon.awssdk.services.eks.model.ServiceUnavailableException;
import software.amazon.awssdk.services.eks.model.UnsupportedAvailabilityZoneException;

public interface EksClient
extends SdkClient {
    public static final String SERVICE_NAME = "eks";

    public static EksClient create() {
        return (EksClient)EksClient.builder().build();
    }

    public static EksClientBuilder builder() {
        return new DefaultEksClientBuilder();
    }

    default public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ResourceInUseException, ResourceLimitExceededException, InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) throws ResourceInUseException, ResourceLimitExceededException, InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EksException {
        return this.createCluster((CreateClusterRequest)((Object)((CreateClusterRequest.Builder)CreateClusterRequest.builder().applyMutation(createClusterRequest)).build()));
    }

    default public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ResourceInUseException, ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) throws ResourceInUseException, ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.deleteCluster((DeleteClusterRequest)((Object)((DeleteClusterRequest.Builder)DeleteClusterRequest.builder().applyMutation(deleteClusterRequest)).build()));
    }

    default public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest) throws ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.describeCluster((DescribeClusterRequest)((Object)((DescribeClusterRequest.Builder)DescribeClusterRequest.builder().applyMutation(describeClusterRequest)).build()));
    }

    default public ListClustersResponse listClusters() throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.listClusters((ListClustersRequest)((Object)ListClustersRequest.builder().build()));
    }

    default public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    default public ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return this.listClusters((ListClustersRequest)((Object)((ListClustersRequest.Builder)ListClustersRequest.builder().applyMutation(listClustersRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

