/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.efs.EfsAsyncClient;
import software.amazon.awssdk.services.efs.internal.UserAgentUtils;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse;
import software.amazon.awssdk.services.efs.model.MountTargetDescription;

public class DescribeMountTargetsPublisher
implements SdkPublisher<DescribeMountTargetsResponse> {
    private final EfsAsyncClient client;
    private final DescribeMountTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMountTargetsPublisher(EfsAsyncClient client, DescribeMountTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMountTargetsPublisher(EfsAsyncClient client, DescribeMountTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMountTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMountTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MountTargetDescription> mountTargets() {
        return this.flatMapIterable(response -> response.mountTargets());
    }

    private class DescribeMountTargetsResponseFetcher
    implements AsyncPageFetcher<DescribeMountTargetsResponse> {
        private DescribeMountTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMountTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeMountTargetsResponse> nextPage(DescribeMountTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMountTargetsPublisher.this.client.describeMountTargets(DescribeMountTargetsPublisher.this.firstRequest);
            }
            return DescribeMountTargetsPublisher.this.client.describeMountTargets((DescribeMountTargetsRequest)((Object)DescribeMountTargetsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

