/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.efs.EfsClient;
import software.amazon.awssdk.services.efs.EfsServiceClientConfiguration;
import software.amazon.awssdk.services.efs.internal.EfsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.efs.model.AccessPointAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.AccessPointLimitExceededException;
import software.amazon.awssdk.services.efs.model.AccessPointNotFoundException;
import software.amazon.awssdk.services.efs.model.AvailabilityZonesMismatchException;
import software.amazon.awssdk.services.efs.model.BadRequestException;
import software.amazon.awssdk.services.efs.model.ConflictException;
import software.amazon.awssdk.services.efs.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.efs.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.efs.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.CreateMountTargetRequest;
import software.amazon.awssdk.services.efs.model.CreateMountTargetResponse;
import software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationRequest;
import software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationResponse;
import software.amazon.awssdk.services.efs.model.CreateTagsRequest;
import software.amazon.awssdk.services.efs.model.CreateTagsResponse;
import software.amazon.awssdk.services.efs.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.efs.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetResponse;
import software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationRequest;
import software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationResponse;
import software.amazon.awssdk.services.efs.model.DeleteTagsRequest;
import software.amazon.awssdk.services.efs.model.DeleteTagsResponse;
import software.amazon.awssdk.services.efs.model.DependencyTimeoutException;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse;
import software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesResponse;
import software.amazon.awssdk.services.efs.model.DescribeBackupPolicyRequest;
import software.amazon.awssdk.services.efs.model.DescribeBackupPolicyResponse;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationRequest;
import software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse;
import software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest;
import software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsResponse;
import software.amazon.awssdk.services.efs.model.DescribeTagsRequest;
import software.amazon.awssdk.services.efs.model.DescribeTagsResponse;
import software.amazon.awssdk.services.efs.model.EfsException;
import software.amazon.awssdk.services.efs.model.FileSystemAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.FileSystemInUseException;
import software.amazon.awssdk.services.efs.model.FileSystemLimitExceededException;
import software.amazon.awssdk.services.efs.model.FileSystemNotFoundException;
import software.amazon.awssdk.services.efs.model.IncorrectFileSystemLifeCycleStateException;
import software.amazon.awssdk.services.efs.model.IncorrectMountTargetStateException;
import software.amazon.awssdk.services.efs.model.InsufficientThroughputCapacityException;
import software.amazon.awssdk.services.efs.model.InternalServerErrorException;
import software.amazon.awssdk.services.efs.model.InvalidPolicyException;
import software.amazon.awssdk.services.efs.model.IpAddressInUseException;
import software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.efs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.MountTargetConflictException;
import software.amazon.awssdk.services.efs.model.MountTargetNotFoundException;
import software.amazon.awssdk.services.efs.model.NetworkInterfaceLimitExceededException;
import software.amazon.awssdk.services.efs.model.NoFreeAddressesInSubnetException;
import software.amazon.awssdk.services.efs.model.PolicyNotFoundException;
import software.amazon.awssdk.services.efs.model.PutAccountPreferencesRequest;
import software.amazon.awssdk.services.efs.model.PutAccountPreferencesResponse;
import software.amazon.awssdk.services.efs.model.PutBackupPolicyRequest;
import software.amazon.awssdk.services.efs.model.PutBackupPolicyResponse;
import software.amazon.awssdk.services.efs.model.PutFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.PutFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationRequest;
import software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationResponse;
import software.amazon.awssdk.services.efs.model.ReplicationAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.ReplicationNotFoundException;
import software.amazon.awssdk.services.efs.model.SecurityGroupLimitExceededException;
import software.amazon.awssdk.services.efs.model.SecurityGroupNotFoundException;
import software.amazon.awssdk.services.efs.model.SubnetNotFoundException;
import software.amazon.awssdk.services.efs.model.TagResourceRequest;
import software.amazon.awssdk.services.efs.model.TagResourceResponse;
import software.amazon.awssdk.services.efs.model.ThrottlingException;
import software.amazon.awssdk.services.efs.model.ThroughputLimitExceededException;
import software.amazon.awssdk.services.efs.model.TooManyRequestsException;
import software.amazon.awssdk.services.efs.model.UnsupportedAvailabilityZoneException;
import software.amazon.awssdk.services.efs.model.UntagResourceRequest;
import software.amazon.awssdk.services.efs.model.UntagResourceResponse;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemProtectionRequest;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemProtectionResponse;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.ValidationException;
import software.amazon.awssdk.services.efs.transform.CreateAccessPointRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateMountTargetRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteAccessPointRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteFileSystemPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteFileSystemRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteMountTargetRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeAccountPreferencesRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeBackupPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeFileSystemPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeFileSystemsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeMountTargetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeMountTargetsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeReplicationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.ModifyMountTargetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.PutAccountPreferencesRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.PutBackupPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.PutFileSystemPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.PutLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.UpdateFileSystemProtectionRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.UpdateFileSystemRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultEfsClient
implements EfsClient {
    private static final Logger log = Logger.loggerFor(DefaultEfsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEfsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"EFS#2.37.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessPointResponse createAccessPoint(CreateAccessPointRequest createAccessPointRequest) throws BadRequestException, AccessPointAlreadyExistsException, IncorrectFileSystemLifeCycleStateException, InternalServerErrorException, FileSystemNotFoundException, AccessPointLimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccessPointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, createAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPoint");
            CreateAccessPointResponse createAccessPointResponse = (CreateAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAccessPointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAccessPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createAccessPoint$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFileSystemResponse createFileSystem(CreateFileSystemRequest createFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemAlreadyExistsException, FileSystemLimitExceededException, InsufficientThroughputCapacityException, ThroughputLimitExceededException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileSystemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, createFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileSystem");
            CreateFileSystemResponse createFileSystemResponse = (CreateFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createFileSystem$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMountTargetResponse createMountTarget(CreateMountTargetRequest createMountTargetRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, MountTargetConflictException, SubnetNotFoundException, NoFreeAddressesInSubnetException, IpAddressInUseException, NetworkInterfaceLimitExceededException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, UnsupportedAvailabilityZoneException, AvailabilityZonesMismatchException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMountTargetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMountTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, createMountTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMountTarget");
            CreateMountTargetResponse createMountTargetResponse = (CreateMountTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMountTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMountTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMountTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMountTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createMountTarget$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationConfigurationResponse createReplicationConfiguration(CreateReplicationConfigurationRequest createReplicationConfigurationRequest) throws BadRequestException, IncorrectFileSystemLifeCycleStateException, ValidationException, ReplicationNotFoundException, FileSystemNotFoundException, UnsupportedAvailabilityZoneException, FileSystemLimitExceededException, InsufficientThroughputCapacityException, ThroughputLimitExceededException, ConflictException, InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReplicationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, createReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationConfiguration");
            CreateReplicationConfigurationResponse createReplicationConfigurationResponse = (CreateReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createReplicationConfiguration$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, createTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTags");
            CreateTagsResponse createTagsResponse = (CreateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createTags$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointResponse deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) throws BadRequestException, InternalServerErrorException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccessPointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, deleteAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPoint");
            DeleteAccessPointResponse deleteAccessPointResponse = (DeleteAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAccessPointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccessPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteAccessPoint$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, FileSystemInUseException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileSystemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, deleteFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileSystem");
            DeleteFileSystemResponse deleteFileSystemResponse = (DeleteFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteFileSystem$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFileSystemPolicyResponse deleteFileSystemPolicy(DeleteFileSystemPolicyRequest deleteFileSystemPolicyRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileSystemPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFileSystemPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, deleteFileSystemPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileSystemPolicy");
            DeleteFileSystemPolicyResponse deleteFileSystemPolicyResponse = (DeleteFileSystemPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileSystemPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFileSystemPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFileSystemPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFileSystemPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteFileSystemPolicy$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMountTargetResponse deleteMountTarget(DeleteMountTargetRequest deleteMountTargetRequest) throws BadRequestException, InternalServerErrorException, DependencyTimeoutException, MountTargetNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMountTargetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMountTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, deleteMountTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMountTarget");
            DeleteMountTargetResponse deleteMountTargetResponse = (DeleteMountTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMountTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMountTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMountTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMountTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteMountTarget$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationConfigurationResponse deleteReplicationConfiguration(DeleteReplicationConfigurationRequest deleteReplicationConfigurationRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, ReplicationNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReplicationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, deleteReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationConfiguration");
            DeleteReplicationConfigurationResponse deleteReplicationConfigurationResponse = (DeleteReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteReplicationConfiguration$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            DeleteTagsResponse deleteTagsResponse = (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteTags$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccessPointsResponse describeAccessPoints(DescribeAccessPointsRequest describeAccessPointsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccessPointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccessPointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeAccessPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccessPoints");
            DescribeAccessPointsResponse describeAccessPointsResponse = (DescribeAccessPointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccessPoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAccessPointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccessPointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccessPointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeAccessPoints$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountPreferencesResponse describeAccountPreferences(DescribeAccountPreferencesRequest describeAccountPreferencesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountPreferencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccountPreferencesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeAccountPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountPreferences");
            DescribeAccountPreferencesResponse describeAccountPreferencesResponse = (DescribeAccountPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountPreferences").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAccountPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeAccountPreferences$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBackupPolicyResponse describeBackupPolicy(DescribeBackupPolicyRequest describeBackupPolicyRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, PolicyNotFoundException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBackupPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeBackupPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackupPolicy");
            DescribeBackupPolicyResponse describeBackupPolicyResponse = (DescribeBackupPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackupPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeBackupPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBackupPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBackupPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeBackupPolicy$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileSystemPolicyResponse describeFileSystemPolicy(DescribeFileSystemPolicyRequest describeFileSystemPolicyRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, PolicyNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFileSystemPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeFileSystemPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystemPolicy");
            DescribeFileSystemPolicyResponse describeFileSystemPolicyResponse = (DescribeFileSystemPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystemPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFileSystemPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFileSystemPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFileSystemPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeFileSystemPolicy$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileSystemsResponse describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFileSystemsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeFileSystemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystems");
            DescribeFileSystemsResponse describeFileSystemsResponse = (DescribeFileSystemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystems").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFileSystemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFileSystemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFileSystemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeFileSystems$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLifecycleConfigurationResponse describeLifecycleConfiguration(DescribeLifecycleConfigurationRequest describeLifecycleConfigurationRequest) throws InternalServerErrorException, BadRequestException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLifecycleConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLifecycleConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLifecycleConfiguration");
            DescribeLifecycleConfigurationResponse describeLifecycleConfigurationResponse = (DescribeLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLifecycleConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLifecycleConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeLifecycleConfiguration$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMountTargetSecurityGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMountTargetSecurityGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeMountTargetSecurityGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMountTargetSecurityGroups");
            DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroupsResponse = (DescribeMountTargetSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMountTargetSecurityGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMountTargetSecurityGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMountTargetSecurityGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMountTargetSecurityGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeMountTargetSecurityGroups$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMountTargetsResponse describeMountTargets(DescribeMountTargetsRequest describeMountTargetsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, MountTargetNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMountTargetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMountTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeMountTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMountTargets");
            DescribeMountTargetsResponse describeMountTargetsResponse = (DescribeMountTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMountTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMountTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMountTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMountTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeMountTargets$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationConfigurationsResponse describeReplicationConfigurations(DescribeReplicationConfigurationsRequest describeReplicationConfigurationsRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, ReplicationNotFoundException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeReplicationConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationConfigurations");
            DescribeReplicationConfigurationsResponse describeReplicationConfigurationsResponse = (DescribeReplicationConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeReplicationConfigurations$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            DescribeTagsResponse describeTagsResponse = (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeTags$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$listTagsForResource$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyMountTargetSecurityGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyMountTargetSecurityGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, modifyMountTargetSecurityGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyMountTargetSecurityGroups");
            ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroupsResponse = (ModifyMountTargetSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyMountTargetSecurityGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyMountTargetSecurityGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyMountTargetSecurityGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyMountTargetSecurityGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$modifyMountTargetSecurityGroups$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountPreferencesResponse putAccountPreferences(PutAccountPreferencesRequest putAccountPreferencesRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountPreferencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountPreferencesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, putAccountPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountPreferences");
            PutAccountPreferencesResponse putAccountPreferencesResponse = (PutAccountPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountPreferences").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAccountPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$putAccountPreferences$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBackupPolicyResponse putBackupPolicy(PutBackupPolicyRequest putBackupPolicyRequest) throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InternalServerErrorException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutBackupPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putBackupPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, putBackupPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBackupPolicy");
            PutBackupPolicyResponse putBackupPolicyResponse = (PutBackupPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBackupPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putBackupPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutBackupPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putBackupPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$putBackupPolicy$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutFileSystemPolicyResponse putFileSystemPolicy(PutFileSystemPolicyRequest putFileSystemPolicyRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, InvalidPolicyException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutFileSystemPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putFileSystemPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, putFileSystemPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutFileSystemPolicy");
            PutFileSystemPolicyResponse putFileSystemPolicyResponse = (PutFileSystemPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutFileSystemPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putFileSystemPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutFileSystemPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putFileSystemPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$putFileSystemPolicy$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLifecycleConfigurationResponse putLifecycleConfiguration(PutLifecycleConfigurationRequest putLifecycleConfigurationRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLifecycleConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putLifecycleConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, putLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLifecycleConfiguration");
            PutLifecycleConfigurationResponse putLifecycleConfigurationResponse = (PutLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLifecycleConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putLifecycleConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutLifecycleConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$putLifecycleConfiguration$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$tagResource$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$untagResource$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFileSystemResponse updateFileSystem(UpdateFileSystemRequest updateFileSystemRequest) throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InsufficientThroughputCapacityException, InternalServerErrorException, ThroughputLimitExceededException, TooManyRequestsException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFileSystemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, updateFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFileSystem");
            UpdateFileSystemResponse updateFileSystemResponse = (UpdateFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$updateFileSystem$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFileSystemProtectionResponse updateFileSystemProtection(UpdateFileSystemProtectionRequest updateFileSystemProtectionRequest) throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InsufficientThroughputCapacityException, InternalServerErrorException, ThroughputLimitExceededException, ReplicationAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFileSystemProtectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "IpAddressInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpAddressInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IpAddressInUseException::builder).build());
                }
                case "FileSystemInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemInUse").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemInUseException::builder).build());
                }
                case "FileSystemAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).build());
                }
                case "AccessPointAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).build());
                }
                case "IncorrectFileSystemLifeCycleState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).build());
                }
                case "AccessPointLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessPointLimitExceededException::builder).build());
                }
                case "NoFreeAddressesInSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).build());
                }
                case "FileSystemNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(FileSystemNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InsufficientThroughputCapacity": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).build());
                }
                case "SecurityGroupLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).build());
                }
                case "PolicyNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "ReplicationAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationAlreadyExists").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ReplicationAlreadyExistsException::builder).build());
                }
                case "FileSystemLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(FileSystemLimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "UnsupportedAvailabilityZone": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).build());
                }
                case "AccessPointNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessPointNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(AccessPointNotFoundException::builder).build());
                }
                case "MountTargetConflict": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetConflict").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(MountTargetConflictException::builder).build());
                }
                case "InvalidPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                }
                case "SecurityGroupNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).build());
                }
                case "NetworkInterfaceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).build());
                }
                case "ReplicationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ReplicationNotFoundException::builder).build());
                }
                case "MountTargetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MountTargetNotFound").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(MountTargetNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "SubnetNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetNotFoundException::builder).build());
                }
                case "IncorrectMountTargetState": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).build());
                }
                case "ThroughputLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThroughputLimitExceededException::builder).build());
                }
                case "DependencyTimeout": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeout").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "AvailabilityZonesMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).build());
                }
                case "TooManyRequests": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequests").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFileSystemProtectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(clientConfiguration, updateFileSystemProtectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFileSystemProtection");
            UpdateFileSystemProtectionResponse updateFileSystemProtectionResponse = (UpdateFileSystemProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFileSystemProtection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFileSystemProtectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFileSystemProtectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFileSystemProtectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$updateFileSystemProtection$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "elasticfilesystem";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        EfsServiceClientConfigurationBuilder serviceConfigBuilder = new EfsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EfsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final EfsServiceClientConfiguration serviceClientConfiguration() {
        return new EfsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateFileSystemProtection$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFileSystem$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putLifecycleConfiguration$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putFileSystemPolicy$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBackupPolicy$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountPreferences$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyMountTargetSecurityGroups$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationConfigurations$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMountTargets$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMountTargetSecurityGroups$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLifecycleConfiguration$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystems$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystemPolicy$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackupPolicy$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountPreferences$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccessPoints$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTags$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationConfiguration$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMountTarget$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileSystemPolicy$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileSystem$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPoint$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTags$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationConfiguration$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMountTarget$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileSystem$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPoint$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

