/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.services.efs.model.ResourceIdType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAccountPreferencesRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, PutAccountPreferencesRequest> {
    private static final SdkField<String> RESOURCE_ID_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdType").getter(PutAccountPreferencesRequest.getter(PutAccountPreferencesRequest::resourceIdTypeAsString)).setter(PutAccountPreferencesRequest.setter(Builder::resourceIdType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAccountPreferencesRequest.memberNameToFieldInitializer();
    private final String resourceIdType;

    private PutAccountPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdType = builder.resourceIdType;
    }

    public final ResourceIdType resourceIdType() {
        return ResourceIdType.fromValue(this.resourceIdType);
    }

    public final String resourceIdTypeAsString() {
        return this.resourceIdType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountPreferencesRequest)) {
            return false;
        }
        PutAccountPreferencesRequest other = (PutAccountPreferencesRequest)((Object)obj);
        return Objects.equals(this.resourceIdTypeAsString(), other.resourceIdTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutAccountPreferencesRequest").add("ResourceIdType", (Object)this.resourceIdTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdType": {
                return Optional.ofNullable(clazz.cast(this.resourceIdTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceIdType", RESOURCE_ID_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAccountPreferencesRequest, T> g) {
        return obj -> g.apply((PutAccountPreferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private String resourceIdType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountPreferencesRequest model) {
            super(model);
            this.resourceIdType(model.resourceIdType);
        }

        public final String getResourceIdType() {
            return this.resourceIdType;
        }

        public final void setResourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
        }

        @Override
        public final Builder resourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
            return this;
        }

        @Override
        public final Builder resourceIdType(ResourceIdType resourceIdType) {
            this.resourceIdType(resourceIdType == null ? null : resourceIdType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountPreferencesRequest build() {
            return new PutAccountPreferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAccountPreferencesRequest> {
        public Builder resourceIdType(String var1);

        public Builder resourceIdType(ResourceIdType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

