/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMountTargetsRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, DescribeMountTargetsRequest> {
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(DescribeMountTargetsRequest.getter(DescribeMountTargetsRequest::maxItems)).setter(DescribeMountTargetsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeMountTargetsRequest.getter(DescribeMountTargetsRequest::marker)).setter(DescribeMountTargetsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(DescribeMountTargetsRequest.getter(DescribeMountTargetsRequest::fileSystemId)).setter(DescribeMountTargetsRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> MOUNT_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountTargetId").getter(DescribeMountTargetsRequest.getter(DescribeMountTargetsRequest::mountTargetId)).setter(DescribeMountTargetsRequest.setter(Builder::mountTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MountTargetId").build()}).build();
    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointId").getter(DescribeMountTargetsRequest.getter(DescribeMountTargetsRequest::accessPointId)).setter(DescribeMountTargetsRequest.setter(Builder::accessPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AccessPointId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ITEMS_FIELD, MARKER_FIELD, FILE_SYSTEM_ID_FIELD, MOUNT_TARGET_ID_FIELD, ACCESS_POINT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMountTargetsRequest.memberNameToFieldInitializer();
    private final Integer maxItems;
    private final String marker;
    private final String fileSystemId;
    private final String mountTargetId;
    private final String accessPointId;

    private DescribeMountTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.fileSystemId = builder.fileSystemId;
        this.mountTargetId = builder.mountTargetId;
        this.accessPointId = builder.accessPointId;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String marker() {
        return this.marker;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String mountTargetId() {
        return this.mountTargetId;
    }

    public final String accessPointId() {
        return this.accessPointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsRequest)) {
            return false;
        }
        DescribeMountTargetsRequest other = (DescribeMountTargetsRequest)((Object)obj);
        return Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.mountTargetId(), other.mountTargetId()) && Objects.equals(this.accessPointId(), other.accessPointId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMountTargetsRequest").add("MaxItems", (Object)this.maxItems()).add("Marker", (Object)this.marker()).add("FileSystemId", (Object)this.fileSystemId()).add("MountTargetId", (Object)this.mountTargetId()).add("AccessPointId", (Object)this.accessPointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "MountTargetId": {
                return Optional.ofNullable(clazz.cast(this.mountTargetId()));
            }
            case "AccessPointId": {
                return Optional.ofNullable(clazz.cast(this.accessPointId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("MountTargetId", MOUNT_TARGET_ID_FIELD);
        map.put("AccessPointId", ACCESS_POINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMountTargetsRequest, T> g) {
        return obj -> g.apply((DescribeMountTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private Integer maxItems;
        private String marker;
        private String fileSystemId;
        private String mountTargetId;
        private String accessPointId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsRequest model) {
            super(model);
            this.maxItems(model.maxItems);
            this.marker(model.marker);
            this.fileSystemId(model.fileSystemId);
            this.mountTargetId(model.mountTargetId);
            this.accessPointId(model.accessPointId);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getMountTargetId() {
            return this.mountTargetId;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final String getAccessPointId() {
            return this.accessPointId;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        @Override
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMountTargetsRequest build() {
            return new DescribeMountTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMountTargetsRequest> {
        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder fileSystemId(String var1);

        public Builder mountTargetId(String var1);

        public Builder accessPointId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

