/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.DeletionMode;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteReplicationConfigurationRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, DeleteReplicationConfigurationRequest> {
    private static final SdkField<String> SOURCE_FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileSystemId").getter(DeleteReplicationConfigurationRequest.getter(DeleteReplicationConfigurationRequest::sourceFileSystemId)).setter(DeleteReplicationConfigurationRequest.setter(Builder::sourceFileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SourceFileSystemId").build()}).build();
    private static final SdkField<String> DELETION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionMode").getter(DeleteReplicationConfigurationRequest.getter(DeleteReplicationConfigurationRequest::deletionModeAsString)).setter(DeleteReplicationConfigurationRequest.setter(Builder::deletionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deletionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FILE_SYSTEM_ID_FIELD, DELETION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteReplicationConfigurationRequest.memberNameToFieldInitializer();
    private final String sourceFileSystemId;
    private final String deletionMode;

    private DeleteReplicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceFileSystemId = builder.sourceFileSystemId;
        this.deletionMode = builder.deletionMode;
    }

    public final String sourceFileSystemId() {
        return this.sourceFileSystemId;
    }

    public final DeletionMode deletionMode() {
        return DeletionMode.fromValue(this.deletionMode);
    }

    public final String deletionModeAsString() {
        return this.deletionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteReplicationConfigurationRequest)) {
            return false;
        }
        DeleteReplicationConfigurationRequest other = (DeleteReplicationConfigurationRequest)((Object)obj);
        return Objects.equals(this.sourceFileSystemId(), other.sourceFileSystemId()) && Objects.equals(this.deletionModeAsString(), other.deletionModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteReplicationConfigurationRequest").add("SourceFileSystemId", (Object)this.sourceFileSystemId()).add("DeletionMode", (Object)this.deletionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceFileSystemId": {
                return Optional.ofNullable(clazz.cast(this.sourceFileSystemId()));
            }
            case "DeletionMode": {
                return Optional.ofNullable(clazz.cast(this.deletionModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SourceFileSystemId", SOURCE_FILE_SYSTEM_ID_FIELD);
        map.put("deletionMode", DELETION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteReplicationConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteReplicationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private String sourceFileSystemId;
        private String deletionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteReplicationConfigurationRequest model) {
            super(model);
            this.sourceFileSystemId(model.sourceFileSystemId);
            this.deletionMode(model.deletionMode);
        }

        public final String getSourceFileSystemId() {
            return this.sourceFileSystemId;
        }

        public final void setSourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
        }

        @Override
        public final Builder sourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
            return this;
        }

        public final String getDeletionMode() {
            return this.deletionMode;
        }

        public final void setDeletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
        }

        @Override
        public final Builder deletionMode(String deletionMode) {
            this.deletionMode = deletionMode;
            return this;
        }

        @Override
        public final Builder deletionMode(DeletionMode deletionMode) {
            this.deletionMode(deletionMode == null ? null : deletionMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteReplicationConfigurationRequest build() {
            return new DeleteReplicationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteReplicationConfigurationRequest> {
        public Builder sourceFileSystemId(String var1);

        public Builder deletionMode(String var1);

        public Builder deletionMode(DeletionMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

