/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.services.efs.model.PosixUser;
import software.amazon.awssdk.services.efs.model.RootDirectory;
import software.amazon.awssdk.services.efs.model.Tag;
import software.amazon.awssdk.services.efs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessPointRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, CreateAccessPointRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateAccessPointRequest.getter(CreateAccessPointRequest::clientToken)).setter(CreateAccessPointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAccessPointRequest.getter(CreateAccessPointRequest::tags)).setter(CreateAccessPointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(CreateAccessPointRequest.getter(CreateAccessPointRequest::fileSystemId)).setter(CreateAccessPointRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<PosixUser> POSIX_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PosixUser").getter(CreateAccessPointRequest.getter(CreateAccessPointRequest::posixUser)).setter(CreateAccessPointRequest.setter(Builder::posixUser)).constructor(PosixUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixUser").build()}).build();
    private static final SdkField<RootDirectory> ROOT_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootDirectory").getter(CreateAccessPointRequest.getter(CreateAccessPointRequest::rootDirectory)).setter(CreateAccessPointRequest.setter(Builder::rootDirectory)).constructor(RootDirectory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDirectory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, TAGS_FIELD, FILE_SYSTEM_ID_FIELD, POSIX_USER_FIELD, ROOT_DIRECTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
            this.put("PosixUser", POSIX_USER_FIELD);
            this.put("RootDirectory", ROOT_DIRECTORY_FIELD);
        }
    });
    private final String clientToken;
    private final List<Tag> tags;
    private final String fileSystemId;
    private final PosixUser posixUser;
    private final RootDirectory rootDirectory;

    private CreateAccessPointRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.fileSystemId = builder.fileSystemId;
        this.posixUser = builder.posixUser;
        this.rootDirectory = builder.rootDirectory;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final PosixUser posixUser() {
        return this.posixUser;
    }

    public final RootDirectory rootDirectory() {
        return this.rootDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.posixUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDirectory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPointRequest)) {
            return false;
        }
        CreateAccessPointRequest other = (CreateAccessPointRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.posixUser(), other.posixUser()) && Objects.equals(this.rootDirectory(), other.rootDirectory());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessPointRequest").add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("FileSystemId", (Object)this.fileSystemId()).add("PosixUser", (Object)this.posixUser()).add("RootDirectory", (Object)this.rootDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "PosixUser": {
                return Optional.ofNullable(clazz.cast(this.posixUser()));
            }
            case "RootDirectory": {
                return Optional.ofNullable(clazz.cast(this.rootDirectory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPointRequest, T> g) {
        return obj -> g.apply((CreateAccessPointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String fileSystemId;
        private PosixUser posixUser;
        private RootDirectory rootDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPointRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.fileSystemId(model.fileSystemId);
            this.posixUser(model.posixUser);
            this.rootDirectory(model.rootDirectory);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final PosixUser.Builder getPosixUser() {
            return this.posixUser != null ? this.posixUser.toBuilder() : null;
        }

        public final void setPosixUser(PosixUser.BuilderImpl posixUser) {
            this.posixUser = posixUser != null ? posixUser.build() : null;
        }

        @Override
        public final Builder posixUser(PosixUser posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        public final RootDirectory.Builder getRootDirectory() {
            return this.rootDirectory != null ? this.rootDirectory.toBuilder() : null;
        }

        public final void setRootDirectory(RootDirectory.BuilderImpl rootDirectory) {
            this.rootDirectory = rootDirectory != null ? rootDirectory.build() : null;
        }

        @Override
        public final Builder rootDirectory(RootDirectory rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessPointRequest build() {
            return new CreateAccessPointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessPointRequest> {
        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder fileSystemId(String var1);

        public Builder posixUser(PosixUser var1);

        default public Builder posixUser(Consumer<PosixUser.Builder> posixUser) {
            return this.posixUser((PosixUser)((PosixUser.Builder)PosixUser.builder().applyMutation(posixUser)).build());
        }

        public Builder rootDirectory(RootDirectory var1);

        default public Builder rootDirectory(Consumer<RootDirectory.Builder> rootDirectory) {
            return this.rootDirectory((RootDirectory)((RootDirectory.Builder)RootDirectory.builder().applyMutation(rootDirectory)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

