/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.services.efs.model.FileSystemSize;
import software.amazon.awssdk.services.efs.model.LifeCycleState;
import software.amazon.awssdk.services.efs.model.PerformanceMode;
import software.amazon.awssdk.services.efs.model.Tag;
import software.amazon.awssdk.services.efs.model.TagsCopier;
import software.amazon.awssdk.services.efs.model.ThroughputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFileSystemResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, UpdateFileSystemResponse> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::ownerId)).setter(UpdateFileSystemResponse.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> CREATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationToken").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::creationToken)).setter(UpdateFileSystemResponse.setter(Builder::creationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationToken").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::fileSystemId)).setter(UpdateFileSystemResponse.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemArn").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::fileSystemArn)).setter(UpdateFileSystemResponse.setter(Builder::fileSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::creationTime)).setter(UpdateFileSystemResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifeCycleState").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::lifeCycleStateAsString)).setter(UpdateFileSystemResponse.setter(Builder::lifeCycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::name)).setter(UpdateFileSystemResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_MOUNT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfMountTargets").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::numberOfMountTargets)).setter(UpdateFileSystemResponse.setter(Builder::numberOfMountTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMountTargets").build()}).build();
    private static final SdkField<FileSystemSize> SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SizeInBytes").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::sizeInBytes)).setter(UpdateFileSystemResponse.setter(Builder::sizeInBytes)).constructor(FileSystemSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()}).build();
    private static final SdkField<String> PERFORMANCE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformanceMode").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::performanceModeAsString)).setter(UpdateFileSystemResponse.setter(Builder::performanceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceMode").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::encrypted)).setter(UpdateFileSystemResponse.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::kmsKeyId)).setter(UpdateFileSystemResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThroughputMode").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::throughputModeAsString)).setter(UpdateFileSystemResponse.setter(Builder::throughputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputMode").build()}).build();
    private static final SdkField<Double> PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ProvisionedThroughputInMibps").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::provisionedThroughputInMibps)).setter(UpdateFileSystemResponse.setter(Builder::provisionedThroughputInMibps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputInMibps").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneName").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::availabilityZoneName)).setter(UpdateFileSystemResponse.setter(Builder::availabilityZoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneName").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::availabilityZoneId)).setter(UpdateFileSystemResponse.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(UpdateFileSystemResponse.getter(UpdateFileSystemResponse::tags)).setter(UpdateFileSystemResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, CREATION_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD, FILE_SYSTEM_ARN_FIELD, CREATION_TIME_FIELD, LIFE_CYCLE_STATE_FIELD, NAME_FIELD, NUMBER_OF_MOUNT_TARGETS_FIELD, SIZE_IN_BYTES_FIELD, PERFORMANCE_MODE_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, THROUGHPUT_MODE_FIELD, PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD, AVAILABILITY_ZONE_NAME_FIELD, AVAILABILITY_ZONE_ID_FIELD, TAGS_FIELD));
    private final String ownerId;
    private final String creationToken;
    private final String fileSystemId;
    private final String fileSystemArn;
    private final Instant creationTime;
    private final String lifeCycleState;
    private final String name;
    private final Integer numberOfMountTargets;
    private final FileSystemSize sizeInBytes;
    private final String performanceMode;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String throughputMode;
    private final Double provisionedThroughputInMibps;
    private final String availabilityZoneName;
    private final String availabilityZoneId;
    private final List<Tag> tags;

    private UpdateFileSystemResponse(BuilderImpl builder) {
        super(builder);
        this.ownerId = builder.ownerId;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemArn = builder.fileSystemArn;
        this.creationTime = builder.creationTime;
        this.lifeCycleState = builder.lifeCycleState;
        this.name = builder.name;
        this.numberOfMountTargets = builder.numberOfMountTargets;
        this.sizeInBytes = builder.sizeInBytes;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.throughputMode = builder.throughputMode;
        this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
        this.availabilityZoneName = builder.availabilityZoneName;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tags = builder.tags;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String creationToken() {
        return this.creationToken;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String fileSystemArn() {
        return this.fileSystemArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(this.lifeCycleState);
    }

    public final String lifeCycleStateAsString() {
        return this.lifeCycleState;
    }

    public final String name() {
        return this.name;
    }

    public final Integer numberOfMountTargets() {
        return this.numberOfMountTargets;
    }

    public final FileSystemSize sizeInBytes() {
        return this.sizeInBytes;
    }

    public final PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(this.performanceMode);
    }

    public final String performanceModeAsString() {
        return this.performanceMode;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(this.throughputMode);
    }

    public final String throughputModeAsString() {
        return this.throughputMode;
    }

    public final Double provisionedThroughputInMibps() {
        return this.provisionedThroughputInMibps;
    }

    public final String availabilityZoneName() {
        return this.availabilityZoneName;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMountTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputInMibps());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemResponse)) {
            return false;
        }
        UpdateFileSystemResponse other = (UpdateFileSystemResponse)((Object)obj);
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.creationToken(), other.creationToken()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.fileSystemArn(), other.fileSystemArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lifeCycleStateAsString(), other.lifeCycleStateAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.numberOfMountTargets(), other.numberOfMountTargets()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes()) && Objects.equals(this.performanceModeAsString(), other.performanceModeAsString()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.throughputModeAsString(), other.throughputModeAsString()) && Objects.equals(this.provisionedThroughputInMibps(), other.provisionedThroughputInMibps()) && Objects.equals(this.availabilityZoneName(), other.availabilityZoneName()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFileSystemResponse").add("OwnerId", (Object)this.ownerId()).add("CreationToken", (Object)this.creationToken()).add("FileSystemId", (Object)this.fileSystemId()).add("FileSystemArn", (Object)this.fileSystemArn()).add("CreationTime", (Object)this.creationTime()).add("LifeCycleState", (Object)this.lifeCycleStateAsString()).add("Name", (Object)this.name()).add("NumberOfMountTargets", (Object)this.numberOfMountTargets()).add("SizeInBytes", (Object)this.sizeInBytes()).add("PerformanceMode", (Object)this.performanceModeAsString()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ThroughputMode", (Object)this.throughputModeAsString()).add("ProvisionedThroughputInMibps", (Object)this.provisionedThroughputInMibps()).add("AvailabilityZoneName", (Object)this.availabilityZoneName()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CreationToken": {
                return Optional.ofNullable(clazz.cast(this.creationToken()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "FileSystemArn": {
                return Optional.ofNullable(clazz.cast(this.fileSystemArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LifeCycleState": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleStateAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NumberOfMountTargets": {
                return Optional.ofNullable(clazz.cast(this.numberOfMountTargets()));
            }
            case "SizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
            case "PerformanceMode": {
                return Optional.ofNullable(clazz.cast(this.performanceModeAsString()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ThroughputMode": {
                return Optional.ofNullable(clazz.cast(this.throughputModeAsString()));
            }
            case "ProvisionedThroughputInMibps": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputInMibps()));
            }
            case "AvailabilityZoneName": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneName()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemResponse, T> g) {
        return obj -> g.apply((UpdateFileSystemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private String ownerId;
        private String creationToken;
        private String fileSystemId;
        private String fileSystemArn;
        private Instant creationTime;
        private String lifeCycleState;
        private String name;
        private Integer numberOfMountTargets;
        private FileSystemSize sizeInBytes;
        private String performanceMode;
        private Boolean encrypted;
        private String kmsKeyId;
        private String throughputMode;
        private Double provisionedThroughputInMibps;
        private String availabilityZoneName;
        private String availabilityZoneId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemResponse model) {
            super(model);
            this.ownerId(model.ownerId);
            this.creationToken(model.creationToken);
            this.fileSystemId(model.fileSystemId);
            this.fileSystemArn(model.fileSystemArn);
            this.creationTime(model.creationTime);
            this.lifeCycleState(model.lifeCycleState);
            this.name(model.name);
            this.numberOfMountTargets(model.numberOfMountTargets);
            this.sizeInBytes(model.sizeInBytes);
            this.performanceMode(model.performanceMode);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.throughputMode(model.throughputMode);
            this.provisionedThroughputInMibps(model.provisionedThroughputInMibps);
            this.availabilityZoneName(model.availabilityZoneName);
            this.availabilityZoneId(model.availabilityZoneId);
            this.tags(model.tags);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        @Override
        @Transient
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getFileSystemArn() {
            return this.fileSystemArn;
        }

        public final void setFileSystemArn(String fileSystemArn) {
            this.fileSystemArn = fileSystemArn;
        }

        @Override
        @Transient
        public final Builder fileSystemArn(String fileSystemArn) {
            this.fileSystemArn = fileSystemArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLifeCycleState() {
            return this.lifeCycleState;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        @Override
        @Transient
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        @Transient
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getNumberOfMountTargets() {
            return this.numberOfMountTargets;
        }

        public final void setNumberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
        }

        @Override
        @Transient
        public final Builder numberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
            return this;
        }

        public final FileSystemSize.Builder getSizeInBytes() {
            return this.sizeInBytes != null ? this.sizeInBytes.toBuilder() : null;
        }

        public final void setSizeInBytes(FileSystemSize.BuilderImpl sizeInBytes) {
            this.sizeInBytes = sizeInBytes != null ? sizeInBytes.build() : null;
        }

        @Override
        @Transient
        public final Builder sizeInBytes(FileSystemSize sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final String getPerformanceMode() {
            return this.performanceMode;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        @Override
        @Transient
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        @Transient
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode == null ? null : performanceMode.toString());
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getThroughputMode() {
            return this.throughputMode;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        @Override
        @Transient
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        @Transient
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final Double getProvisionedThroughputInMibps() {
            return this.provisionedThroughputInMibps;
        }

        public final void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
        }

        @Override
        @Transient
        public final Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        public final String getAvailabilityZoneName() {
            return this.availabilityZoneName;
        }

        public final void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        @Override
        @Transient
        public final Builder availabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        @Transient
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateFileSystemResponse build() {
            return new UpdateFileSystemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFileSystemResponse> {
        public Builder ownerId(String var1);

        public Builder creationToken(String var1);

        public Builder fileSystemId(String var1);

        public Builder fileSystemArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lifeCycleState(String var1);

        public Builder lifeCycleState(LifeCycleState var1);

        public Builder name(String var1);

        public Builder numberOfMountTargets(Integer var1);

        public Builder sizeInBytes(FileSystemSize var1);

        default public Builder sizeInBytes(Consumer<FileSystemSize.Builder> sizeInBytes) {
            return this.sizeInBytes((FileSystemSize)((FileSystemSize.Builder)FileSystemSize.builder().applyMutation(sizeInBytes)).build());
        }

        public Builder performanceMode(String var1);

        public Builder performanceMode(PerformanceMode var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder throughputMode(String var1);

        public Builder throughputMode(ThroughputMode var1);

        public Builder provisionedThroughputInMibps(Double var1);

        public Builder availabilityZoneName(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

