/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.efs.DefaultEfsClientBuilder;
import software.amazon.awssdk.services.efs.EfsClientBuilder;
import software.amazon.awssdk.services.efs.model.AccessPointAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.AccessPointLimitExceededException;
import software.amazon.awssdk.services.efs.model.AccessPointNotFoundException;
import software.amazon.awssdk.services.efs.model.AvailabilityZonesMismatchException;
import software.amazon.awssdk.services.efs.model.BadRequestException;
import software.amazon.awssdk.services.efs.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.efs.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.efs.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.CreateMountTargetRequest;
import software.amazon.awssdk.services.efs.model.CreateMountTargetResponse;
import software.amazon.awssdk.services.efs.model.CreateTagsRequest;
import software.amazon.awssdk.services.efs.model.CreateTagsResponse;
import software.amazon.awssdk.services.efs.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.efs.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetResponse;
import software.amazon.awssdk.services.efs.model.DeleteTagsRequest;
import software.amazon.awssdk.services.efs.model.DeleteTagsResponse;
import software.amazon.awssdk.services.efs.model.DependencyTimeoutException;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse;
import software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesResponse;
import software.amazon.awssdk.services.efs.model.DescribeBackupPolicyRequest;
import software.amazon.awssdk.services.efs.model.DescribeBackupPolicyResponse;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationRequest;
import software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse;
import software.amazon.awssdk.services.efs.model.DescribeTagsRequest;
import software.amazon.awssdk.services.efs.model.DescribeTagsResponse;
import software.amazon.awssdk.services.efs.model.EfsException;
import software.amazon.awssdk.services.efs.model.FileSystemAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.FileSystemInUseException;
import software.amazon.awssdk.services.efs.model.FileSystemLimitExceededException;
import software.amazon.awssdk.services.efs.model.FileSystemNotFoundException;
import software.amazon.awssdk.services.efs.model.IncorrectFileSystemLifeCycleStateException;
import software.amazon.awssdk.services.efs.model.IncorrectMountTargetStateException;
import software.amazon.awssdk.services.efs.model.InsufficientThroughputCapacityException;
import software.amazon.awssdk.services.efs.model.InternalServerErrorException;
import software.amazon.awssdk.services.efs.model.InvalidPolicyException;
import software.amazon.awssdk.services.efs.model.IpAddressInUseException;
import software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.efs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.MountTargetConflictException;
import software.amazon.awssdk.services.efs.model.MountTargetNotFoundException;
import software.amazon.awssdk.services.efs.model.NetworkInterfaceLimitExceededException;
import software.amazon.awssdk.services.efs.model.NoFreeAddressesInSubnetException;
import software.amazon.awssdk.services.efs.model.PolicyNotFoundException;
import software.amazon.awssdk.services.efs.model.PutAccountPreferencesRequest;
import software.amazon.awssdk.services.efs.model.PutAccountPreferencesResponse;
import software.amazon.awssdk.services.efs.model.PutBackupPolicyRequest;
import software.amazon.awssdk.services.efs.model.PutBackupPolicyResponse;
import software.amazon.awssdk.services.efs.model.PutFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.PutFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationRequest;
import software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationResponse;
import software.amazon.awssdk.services.efs.model.SecurityGroupLimitExceededException;
import software.amazon.awssdk.services.efs.model.SecurityGroupNotFoundException;
import software.amazon.awssdk.services.efs.model.SubnetNotFoundException;
import software.amazon.awssdk.services.efs.model.TagResourceRequest;
import software.amazon.awssdk.services.efs.model.TagResourceResponse;
import software.amazon.awssdk.services.efs.model.ThroughputLimitExceededException;
import software.amazon.awssdk.services.efs.model.TooManyRequestsException;
import software.amazon.awssdk.services.efs.model.UnsupportedAvailabilityZoneException;
import software.amazon.awssdk.services.efs.model.UntagResourceRequest;
import software.amazon.awssdk.services.efs.model.UntagResourceResponse;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.ValidationException;
import software.amazon.awssdk.services.efs.paginators.DescribeAccessPointsIterable;
import software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable;
import software.amazon.awssdk.services.efs.paginators.DescribeTagsIterable;
import software.amazon.awssdk.services.efs.paginators.ListTagsForResourceIterable;

@SdkPublicApi
@ThreadSafe
public interface EfsClient
extends SdkClient {
    public static final String SERVICE_NAME = "elasticfilesystem";
    public static final String SERVICE_METADATA_ID = "elasticfilesystem";

    public static EfsClient create() {
        return (EfsClient)EfsClient.builder().build();
    }

    public static EfsClientBuilder builder() {
        return new DefaultEfsClientBuilder();
    }

    default public CreateAccessPointResponse createAccessPoint(CreateAccessPointRequest createAccessPointRequest) throws BadRequestException, AccessPointAlreadyExistsException, IncorrectFileSystemLifeCycleStateException, InternalServerErrorException, FileSystemNotFoundException, AccessPointLimitExceededException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public CreateAccessPointResponse createAccessPoint(Consumer<CreateAccessPointRequest.Builder> createAccessPointRequest) throws BadRequestException, AccessPointAlreadyExistsException, IncorrectFileSystemLifeCycleStateException, InternalServerErrorException, FileSystemNotFoundException, AccessPointLimitExceededException, AwsServiceException, SdkClientException, EfsException {
        return this.createAccessPoint((CreateAccessPointRequest)((Object)((CreateAccessPointRequest.Builder)CreateAccessPointRequest.builder().applyMutation(createAccessPointRequest)).build()));
    }

    default public CreateFileSystemResponse createFileSystem(CreateFileSystemRequest createFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemAlreadyExistsException, FileSystemLimitExceededException, InsufficientThroughputCapacityException, ThroughputLimitExceededException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public CreateFileSystemResponse createFileSystem(Consumer<CreateFileSystemRequest.Builder> createFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemAlreadyExistsException, FileSystemLimitExceededException, InsufficientThroughputCapacityException, ThroughputLimitExceededException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EfsException {
        return this.createFileSystem((CreateFileSystemRequest)((Object)((CreateFileSystemRequest.Builder)CreateFileSystemRequest.builder().applyMutation(createFileSystemRequest)).build()));
    }

    default public CreateMountTargetResponse createMountTarget(CreateMountTargetRequest createMountTargetRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, MountTargetConflictException, SubnetNotFoundException, NoFreeAddressesInSubnetException, IpAddressInUseException, NetworkInterfaceLimitExceededException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, UnsupportedAvailabilityZoneException, AvailabilityZonesMismatchException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public CreateMountTargetResponse createMountTarget(Consumer<CreateMountTargetRequest.Builder> createMountTargetRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, MountTargetConflictException, SubnetNotFoundException, NoFreeAddressesInSubnetException, IpAddressInUseException, NetworkInterfaceLimitExceededException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, UnsupportedAvailabilityZoneException, AvailabilityZonesMismatchException, AwsServiceException, SdkClientException, EfsException {
        return this.createMountTarget((CreateMountTargetRequest)((Object)((CreateMountTargetRequest.Builder)CreateMountTargetRequest.builder().applyMutation(createMountTargetRequest)).build()));
    }

    default public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.createTags((CreateTagsRequest)((Object)((CreateTagsRequest.Builder)CreateTagsRequest.builder().applyMutation(createTagsRequest)).build()));
    }

    default public DeleteAccessPointResponse deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) throws BadRequestException, InternalServerErrorException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteAccessPointResponse deleteAccessPoint(Consumer<DeleteAccessPointRequest.Builder> deleteAccessPointRequest) throws BadRequestException, InternalServerErrorException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.deleteAccessPoint((DeleteAccessPointRequest)((Object)((DeleteAccessPointRequest.Builder)DeleteAccessPointRequest.builder().applyMutation(deleteAccessPointRequest)).build()));
    }

    default public DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, FileSystemInUseException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteFileSystemResponse deleteFileSystem(Consumer<DeleteFileSystemRequest.Builder> deleteFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, FileSystemInUseException, AwsServiceException, SdkClientException, EfsException {
        return this.deleteFileSystem((DeleteFileSystemRequest)((Object)((DeleteFileSystemRequest.Builder)DeleteFileSystemRequest.builder().applyMutation(deleteFileSystemRequest)).build()));
    }

    default public DeleteFileSystemPolicyResponse deleteFileSystemPolicy(DeleteFileSystemPolicyRequest deleteFileSystemPolicyRequest) throws InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteFileSystemPolicyResponse deleteFileSystemPolicy(Consumer<DeleteFileSystemPolicyRequest.Builder> deleteFileSystemPolicyRequest) throws InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        return this.deleteFileSystemPolicy((DeleteFileSystemPolicyRequest)((Object)((DeleteFileSystemPolicyRequest.Builder)DeleteFileSystemPolicyRequest.builder().applyMutation(deleteFileSystemPolicyRequest)).build()));
    }

    default public DeleteMountTargetResponse deleteMountTarget(DeleteMountTargetRequest deleteMountTargetRequest) throws BadRequestException, InternalServerErrorException, DependencyTimeoutException, MountTargetNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteMountTargetResponse deleteMountTarget(Consumer<DeleteMountTargetRequest.Builder> deleteMountTargetRequest) throws BadRequestException, InternalServerErrorException, DependencyTimeoutException, MountTargetNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.deleteMountTarget((DeleteMountTargetRequest)((Object)((DeleteMountTargetRequest.Builder)DeleteMountTargetRequest.builder().applyMutation(deleteMountTargetRequest)).build()));
    }

    default public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.deleteTags((DeleteTagsRequest)((Object)((DeleteTagsRequest.Builder)DeleteTagsRequest.builder().applyMutation(deleteTagsRequest)).build()));
    }

    default public DescribeAccessPointsResponse describeAccessPoints(DescribeAccessPointsRequest describeAccessPointsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAccessPointsResponse describeAccessPoints(Consumer<DescribeAccessPointsRequest.Builder> describeAccessPointsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeAccessPoints((DescribeAccessPointsRequest)((Object)((DescribeAccessPointsRequest.Builder)DescribeAccessPointsRequest.builder().applyMutation(describeAccessPointsRequest)).build()));
    }

    default public DescribeAccessPointsIterable describeAccessPointsPaginator(DescribeAccessPointsRequest describeAccessPointsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAccessPointsIterable describeAccessPointsPaginator(Consumer<DescribeAccessPointsRequest.Builder> describeAccessPointsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeAccessPointsPaginator((DescribeAccessPointsRequest)((Object)((DescribeAccessPointsRequest.Builder)DescribeAccessPointsRequest.builder().applyMutation(describeAccessPointsRequest)).build()));
    }

    default public DescribeAccountPreferencesResponse describeAccountPreferences(DescribeAccountPreferencesRequest describeAccountPreferencesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAccountPreferencesResponse describeAccountPreferences(Consumer<DescribeAccountPreferencesRequest.Builder> describeAccountPreferencesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        return this.describeAccountPreferences((DescribeAccountPreferencesRequest)((Object)((DescribeAccountPreferencesRequest.Builder)DescribeAccountPreferencesRequest.builder().applyMutation(describeAccountPreferencesRequest)).build()));
    }

    default public DescribeBackupPolicyResponse describeBackupPolicy(DescribeBackupPolicyRequest describeBackupPolicyRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, PolicyNotFoundException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeBackupPolicyResponse describeBackupPolicy(Consumer<DescribeBackupPolicyRequest.Builder> describeBackupPolicyRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, PolicyNotFoundException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        return this.describeBackupPolicy((DescribeBackupPolicyRequest)((Object)((DescribeBackupPolicyRequest.Builder)DescribeBackupPolicyRequest.builder().applyMutation(describeBackupPolicyRequest)).build()));
    }

    default public DescribeFileSystemPolicyResponse describeFileSystemPolicy(DescribeFileSystemPolicyRequest describeFileSystemPolicyRequest) throws InternalServerErrorException, FileSystemNotFoundException, PolicyNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeFileSystemPolicyResponse describeFileSystemPolicy(Consumer<DescribeFileSystemPolicyRequest.Builder> describeFileSystemPolicyRequest) throws InternalServerErrorException, FileSystemNotFoundException, PolicyNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeFileSystemPolicy((DescribeFileSystemPolicyRequest)((Object)((DescribeFileSystemPolicyRequest.Builder)DescribeFileSystemPolicyRequest.builder().applyMutation(describeFileSystemPolicyRequest)).build()));
    }

    default public DescribeFileSystemsResponse describeFileSystems() throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeFileSystems((DescribeFileSystemsRequest)((Object)DescribeFileSystemsRequest.builder().build()));
    }

    default public DescribeFileSystemsResponse describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeFileSystemsResponse describeFileSystems(Consumer<DescribeFileSystemsRequest.Builder> describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeFileSystems((DescribeFileSystemsRequest)((Object)((DescribeFileSystemsRequest.Builder)DescribeFileSystemsRequest.builder().applyMutation(describeFileSystemsRequest)).build()));
    }

    default public DescribeFileSystemsIterable describeFileSystemsPaginator() throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeFileSystemsPaginator((DescribeFileSystemsRequest)((Object)DescribeFileSystemsRequest.builder().build()));
    }

    default public DescribeFileSystemsIterable describeFileSystemsPaginator(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeFileSystemsIterable describeFileSystemsPaginator(Consumer<DescribeFileSystemsRequest.Builder> describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeFileSystemsPaginator((DescribeFileSystemsRequest)((Object)((DescribeFileSystemsRequest.Builder)DescribeFileSystemsRequest.builder().applyMutation(describeFileSystemsRequest)).build()));
    }

    default public DescribeLifecycleConfigurationResponse describeLifecycleConfiguration(DescribeLifecycleConfigurationRequest describeLifecycleConfigurationRequest) throws InternalServerErrorException, BadRequestException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeLifecycleConfigurationResponse describeLifecycleConfiguration(Consumer<DescribeLifecycleConfigurationRequest.Builder> describeLifecycleConfigurationRequest) throws InternalServerErrorException, BadRequestException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeLifecycleConfiguration((DescribeLifecycleConfigurationRequest)((Object)((DescribeLifecycleConfigurationRequest.Builder)DescribeLifecycleConfigurationRequest.builder().applyMutation(describeLifecycleConfigurationRequest)).build()));
    }

    default public DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroups(Consumer<DescribeMountTargetSecurityGroupsRequest.Builder> describeMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, AwsServiceException, SdkClientException, EfsException {
        return this.describeMountTargetSecurityGroups((DescribeMountTargetSecurityGroupsRequest)((Object)((DescribeMountTargetSecurityGroupsRequest.Builder)DescribeMountTargetSecurityGroupsRequest.builder().applyMutation(describeMountTargetSecurityGroupsRequest)).build()));
    }

    default public DescribeMountTargetsResponse describeMountTargets(DescribeMountTargetsRequest describeMountTargetsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, MountTargetNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeMountTargetsResponse describeMountTargets(Consumer<DescribeMountTargetsRequest.Builder> describeMountTargetsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, MountTargetNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeMountTargets((DescribeMountTargetsRequest)((Object)((DescribeMountTargetsRequest.Builder)DescribeMountTargetsRequest.builder().applyMutation(describeMountTargetsRequest)).build()));
    }

    default public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeTags((DescribeTagsRequest)((Object)((DescribeTagsRequest.Builder)DescribeTagsRequest.builder().applyMutation(describeTagsRequest)).build()));
    }

    default public DescribeTagsIterable describeTagsPaginator(DescribeTagsRequest describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeTagsIterable describeTagsPaginator(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.describeTagsPaginator((DescribeTagsRequest)((Object)((DescribeTagsRequest.Builder)DescribeTagsRequest.builder().applyMutation(describeTagsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceIterable listTagsForResourcePaginator(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.listTagsForResourcePaginator((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroups(Consumer<ModifyMountTargetSecurityGroupsRequest.Builder> modifyMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.modifyMountTargetSecurityGroups((ModifyMountTargetSecurityGroupsRequest)((Object)((ModifyMountTargetSecurityGroupsRequest.Builder)ModifyMountTargetSecurityGroupsRequest.builder().applyMutation(modifyMountTargetSecurityGroupsRequest)).build()));
    }

    default public PutAccountPreferencesResponse putAccountPreferences(PutAccountPreferencesRequest putAccountPreferencesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public PutAccountPreferencesResponse putAccountPreferences(Consumer<PutAccountPreferencesRequest.Builder> putAccountPreferencesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        return this.putAccountPreferences((PutAccountPreferencesRequest)((Object)((PutAccountPreferencesRequest.Builder)PutAccountPreferencesRequest.builder().applyMutation(putAccountPreferencesRequest)).build()));
    }

    default public PutBackupPolicyResponse putBackupPolicy(PutBackupPolicyRequest putBackupPolicyRequest) throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InternalServerErrorException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public PutBackupPolicyResponse putBackupPolicy(Consumer<PutBackupPolicyRequest.Builder> putBackupPolicyRequest) throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InternalServerErrorException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        return this.putBackupPolicy((PutBackupPolicyRequest)((Object)((PutBackupPolicyRequest.Builder)PutBackupPolicyRequest.builder().applyMutation(putBackupPolicyRequest)).build()));
    }

    default public PutFileSystemPolicyResponse putFileSystemPolicy(PutFileSystemPolicyRequest putFileSystemPolicyRequest) throws InternalServerErrorException, FileSystemNotFoundException, InvalidPolicyException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public PutFileSystemPolicyResponse putFileSystemPolicy(Consumer<PutFileSystemPolicyRequest.Builder> putFileSystemPolicyRequest) throws InternalServerErrorException, FileSystemNotFoundException, InvalidPolicyException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        return this.putFileSystemPolicy((PutFileSystemPolicyRequest)((Object)((PutFileSystemPolicyRequest.Builder)PutFileSystemPolicyRequest.builder().applyMutation(putFileSystemPolicyRequest)).build()));
    }

    default public PutLifecycleConfigurationResponse putLifecycleConfiguration(PutLifecycleConfigurationRequest putLifecycleConfigurationRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public PutLifecycleConfigurationResponse putLifecycleConfiguration(Consumer<PutLifecycleConfigurationRequest.Builder> putLifecycleConfigurationRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        return this.putLifecycleConfiguration((PutLifecycleConfigurationRequest)((Object)((PutLifecycleConfigurationRequest.Builder)PutLifecycleConfigurationRequest.builder().applyMutation(putLifecycleConfigurationRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateFileSystemResponse updateFileSystem(UpdateFileSystemRequest updateFileSystemRequest) throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InsufficientThroughputCapacityException, InternalServerErrorException, ThroughputLimitExceededException, TooManyRequestsException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    default public UpdateFileSystemResponse updateFileSystem(Consumer<UpdateFileSystemRequest.Builder> updateFileSystemRequest) throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InsufficientThroughputCapacityException, InternalServerErrorException, ThroughputLimitExceededException, TooManyRequestsException, AwsServiceException, SdkClientException, EfsException {
        return this.updateFileSystem((UpdateFileSystemRequest)((Object)((UpdateFileSystemRequest.Builder)UpdateFileSystemRequest.builder().applyMutation(updateFileSystemRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"elasticfilesystem");
    }
}

