/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Resource {
    FILE_SYSTEM("FILE_SYSTEM"),
    MOUNT_TARGET("MOUNT_TARGET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Resource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Resource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Resource.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Resource> knownValues() {
        return Stream.of(Resource.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

