/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.services.efs.model.LifeCycleState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMountTargetResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, CreateMountTargetResponse> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::ownerId)).setter(CreateMountTargetResponse.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> MOUNT_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountTargetId").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::mountTargetId)).setter(CreateMountTargetResponse.setter(Builder::mountTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountTargetId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::fileSystemId)).setter(CreateMountTargetResponse.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::subnetId)).setter(CreateMountTargetResponse.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifeCycleState").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::lifeCycleStateAsString)).setter(CreateMountTargetResponse.setter(Builder::lifeCycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::ipAddress)).setter(CreateMountTargetResponse.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::networkInterfaceId)).setter(CreateMountTargetResponse.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::availabilityZoneId)).setter(CreateMountTargetResponse.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneName").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::availabilityZoneName)).setter(CreateMountTargetResponse.setter(Builder::availabilityZoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneName").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateMountTargetResponse.getter(CreateMountTargetResponse::vpcId)).setter(CreateMountTargetResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, MOUNT_TARGET_ID_FIELD, FILE_SYSTEM_ID_FIELD, SUBNET_ID_FIELD, LIFE_CYCLE_STATE_FIELD, IP_ADDRESS_FIELD, NETWORK_INTERFACE_ID_FIELD, AVAILABILITY_ZONE_ID_FIELD, AVAILABILITY_ZONE_NAME_FIELD, VPC_ID_FIELD));
    private final String ownerId;
    private final String mountTargetId;
    private final String fileSystemId;
    private final String subnetId;
    private final String lifeCycleState;
    private final String ipAddress;
    private final String networkInterfaceId;
    private final String availabilityZoneId;
    private final String availabilityZoneName;
    private final String vpcId;

    private CreateMountTargetResponse(BuilderImpl builder) {
        super(builder);
        this.ownerId = builder.ownerId;
        this.mountTargetId = builder.mountTargetId;
        this.fileSystemId = builder.fileSystemId;
        this.subnetId = builder.subnetId;
        this.lifeCycleState = builder.lifeCycleState;
        this.ipAddress = builder.ipAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availabilityZoneName = builder.availabilityZoneName;
        this.vpcId = builder.vpcId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String mountTargetId() {
        return this.mountTargetId;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(this.lifeCycleState);
    }

    public final String lifeCycleStateAsString() {
        return this.lifeCycleState;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String availabilityZoneName() {
        return this.availabilityZoneName;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMountTargetResponse)) {
            return false;
        }
        CreateMountTargetResponse other = (CreateMountTargetResponse)((Object)obj);
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.mountTargetId(), other.mountTargetId()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.lifeCycleStateAsString(), other.lifeCycleStateAsString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.availabilityZoneName(), other.availabilityZoneName()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMountTargetResponse").add("OwnerId", (Object)this.ownerId()).add("MountTargetId", (Object)this.mountTargetId()).add("FileSystemId", (Object)this.fileSystemId()).add("SubnetId", (Object)this.subnetId()).add("LifeCycleState", (Object)this.lifeCycleStateAsString()).add("IpAddress", (Object)this.ipAddress()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("AvailabilityZoneName", (Object)this.availabilityZoneName()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "MountTargetId": {
                return Optional.ofNullable(clazz.cast(this.mountTargetId()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "LifeCycleState": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleStateAsString()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "AvailabilityZoneName": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneName()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMountTargetResponse, T> g) {
        return obj -> g.apply((CreateMountTargetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private String ownerId;
        private String mountTargetId;
        private String fileSystemId;
        private String subnetId;
        private String lifeCycleState;
        private String ipAddress;
        private String networkInterfaceId;
        private String availabilityZoneId;
        private String availabilityZoneName;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMountTargetResponse model) {
            super(model);
            this.ownerId(model.ownerId);
            this.mountTargetId(model.mountTargetId);
            this.fileSystemId(model.fileSystemId);
            this.subnetId(model.subnetId);
            this.lifeCycleState(model.lifeCycleState);
            this.ipAddress(model.ipAddress);
            this.networkInterfaceId(model.networkInterfaceId);
            this.availabilityZoneId(model.availabilityZoneId);
            this.availabilityZoneName(model.availabilityZoneName);
            this.vpcId(model.vpcId);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getMountTargetId() {
            return this.mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getLifeCycleState() {
            return this.lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final String getAvailabilityZoneName() {
            return this.availabilityZoneName;
        }

        @Override
        public final Builder availabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        public final void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public CreateMountTargetResponse build() {
            return new CreateMountTargetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMountTargetResponse> {
        public Builder ownerId(String var1);

        public Builder mountTargetId(String var1);

        public Builder fileSystemId(String var1);

        public Builder subnetId(String var1);

        public Builder lifeCycleState(String var1);

        public Builder lifeCycleState(LifeCycleState var1);

        public Builder ipAddress(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder availabilityZoneName(String var1);

        public Builder vpcId(String var1);
    }
}

