/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.FileSystemSize;
import software.amazon.awssdk.services.efs.model.LifeCycleState;
import software.amazon.awssdk.services.efs.model.PerformanceMode;
import software.amazon.awssdk.services.efs.model.Tag;
import software.amazon.awssdk.services.efs.model.TagsCopier;
import software.amazon.awssdk.services.efs.model.ThroughputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSystemDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSystemDescription> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileSystemDescription.getter(FileSystemDescription::ownerId)).setter(FileSystemDescription.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> CREATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileSystemDescription.getter(FileSystemDescription::creationToken)).setter(FileSystemDescription.setter(Builder::creationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationToken").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileSystemDescription.getter(FileSystemDescription::fileSystemId)).setter(FileSystemDescription.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileSystemDescription.getter(FileSystemDescription::fileSystemArn)).setter(FileSystemDescription.setter(Builder::fileSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FileSystemDescription.getter(FileSystemDescription::creationTime)).setter(FileSystemDescription.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileSystemDescription.getter(FileSystemDescription::lifeCycleStateAsString)).setter(FileSystemDescription.setter(Builder::lifeCycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileSystemDescription.getter(FileSystemDescription::name)).setter(FileSystemDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_MOUNT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(FileSystemDescription.getter(FileSystemDescription::numberOfMountTargets)).setter(FileSystemDescription.setter(Builder::numberOfMountTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMountTargets").build()}).build();
    private static final SdkField<FileSystemSize> SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FileSystemDescription.getter(FileSystemDescription::sizeInBytes)).setter(FileSystemDescription.setter(Builder::sizeInBytes)).constructor(FileSystemSize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()}).build();
    private static final SdkField<String> PERFORMANCE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileSystemDescription.getter(FileSystemDescription::performanceModeAsString)).setter(FileSystemDescription.setter(Builder::performanceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceMode").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(FileSystemDescription.getter(FileSystemDescription::encrypted)).setter(FileSystemDescription.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileSystemDescription.getter(FileSystemDescription::kmsKeyId)).setter(FileSystemDescription.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileSystemDescription.getter(FileSystemDescription::throughputModeAsString)).setter(FileSystemDescription.setter(Builder::throughputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputMode").build()}).build();
    private static final SdkField<Double> PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(FileSystemDescription.getter(FileSystemDescription::provisionedThroughputInMibps)).setter(FileSystemDescription.setter(Builder::provisionedThroughputInMibps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputInMibps").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FileSystemDescription.getter(FileSystemDescription::tags)).setter(FileSystemDescription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, CREATION_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD, FILE_SYSTEM_ARN_FIELD, CREATION_TIME_FIELD, LIFE_CYCLE_STATE_FIELD, NAME_FIELD, NUMBER_OF_MOUNT_TARGETS_FIELD, SIZE_IN_BYTES_FIELD, PERFORMANCE_MODE_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, THROUGHPUT_MODE_FIELD, PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String creationToken;
    private final String fileSystemId;
    private final String fileSystemArn;
    private final Instant creationTime;
    private final String lifeCycleState;
    private final String name;
    private final Integer numberOfMountTargets;
    private final FileSystemSize sizeInBytes;
    private final String performanceMode;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String throughputMode;
    private final Double provisionedThroughputInMibps;
    private final List<Tag> tags;

    private FileSystemDescription(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemArn = builder.fileSystemArn;
        this.creationTime = builder.creationTime;
        this.lifeCycleState = builder.lifeCycleState;
        this.name = builder.name;
        this.numberOfMountTargets = builder.numberOfMountTargets;
        this.sizeInBytes = builder.sizeInBytes;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.throughputMode = builder.throughputMode;
        this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
        this.tags = builder.tags;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String creationToken() {
        return this.creationToken;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public String fileSystemArn() {
        return this.fileSystemArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(this.lifeCycleState);
    }

    public String lifeCycleStateAsString() {
        return this.lifeCycleState;
    }

    public String name() {
        return this.name;
    }

    public Integer numberOfMountTargets() {
        return this.numberOfMountTargets;
    }

    public FileSystemSize sizeInBytes() {
        return this.sizeInBytes;
    }

    public PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(this.performanceMode);
    }

    public String performanceModeAsString() {
        return this.performanceMode;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(this.throughputMode);
    }

    public String throughputModeAsString() {
        return this.throughputMode;
    }

    public Double provisionedThroughputInMibps() {
        return this.provisionedThroughputInMibps;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMountTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputInMibps());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemDescription)) {
            return false;
        }
        FileSystemDescription other = (FileSystemDescription)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.creationToken(), other.creationToken()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.fileSystemArn(), other.fileSystemArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lifeCycleStateAsString(), other.lifeCycleStateAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.numberOfMountTargets(), other.numberOfMountTargets()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes()) && Objects.equals(this.performanceModeAsString(), other.performanceModeAsString()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.throughputModeAsString(), other.throughputModeAsString()) && Objects.equals(this.provisionedThroughputInMibps(), other.provisionedThroughputInMibps()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"FileSystemDescription").add("OwnerId", (Object)this.ownerId()).add("CreationToken", (Object)this.creationToken()).add("FileSystemId", (Object)this.fileSystemId()).add("FileSystemArn", (Object)this.fileSystemArn()).add("CreationTime", (Object)this.creationTime()).add("LifeCycleState", (Object)this.lifeCycleStateAsString()).add("Name", (Object)this.name()).add("NumberOfMountTargets", (Object)this.numberOfMountTargets()).add("SizeInBytes", (Object)this.sizeInBytes()).add("PerformanceMode", (Object)this.performanceModeAsString()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ThroughputMode", (Object)this.throughputModeAsString()).add("ProvisionedThroughputInMibps", (Object)this.provisionedThroughputInMibps()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CreationToken": {
                return Optional.ofNullable(clazz.cast(this.creationToken()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "FileSystemArn": {
                return Optional.ofNullable(clazz.cast(this.fileSystemArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LifeCycleState": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleStateAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NumberOfMountTargets": {
                return Optional.ofNullable(clazz.cast(this.numberOfMountTargets()));
            }
            case "SizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
            case "PerformanceMode": {
                return Optional.ofNullable(clazz.cast(this.performanceModeAsString()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ThroughputMode": {
                return Optional.ofNullable(clazz.cast(this.throughputModeAsString()));
            }
            case "ProvisionedThroughputInMibps": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputInMibps()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemDescription, T> g) {
        return obj -> g.apply((FileSystemDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String creationToken;
        private String fileSystemId;
        private String fileSystemArn;
        private Instant creationTime;
        private String lifeCycleState;
        private String name;
        private Integer numberOfMountTargets;
        private FileSystemSize sizeInBytes;
        private String performanceMode;
        private Boolean encrypted;
        private String kmsKeyId;
        private String throughputMode;
        private Double provisionedThroughputInMibps;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemDescription model) {
            this.ownerId(model.ownerId);
            this.creationToken(model.creationToken);
            this.fileSystemId(model.fileSystemId);
            this.fileSystemArn(model.fileSystemArn);
            this.creationTime(model.creationTime);
            this.lifeCycleState(model.lifeCycleState);
            this.name(model.name);
            this.numberOfMountTargets(model.numberOfMountTargets);
            this.sizeInBytes(model.sizeInBytes);
            this.performanceMode(model.performanceMode);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.throughputMode(model.throughputMode);
            this.provisionedThroughputInMibps(model.provisionedThroughputInMibps);
            this.tags(model.tags);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getFileSystemArn() {
            return this.fileSystemArn;
        }

        @Override
        public final Builder fileSystemArn(String fileSystemArn) {
            this.fileSystemArn = fileSystemArn;
            return this;
        }

        public final void setFileSystemArn(String fileSystemArn) {
            this.fileSystemArn = fileSystemArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getLifeCycleState() {
            return this.lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getNumberOfMountTargets() {
            return this.numberOfMountTargets;
        }

        @Override
        public final Builder numberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
            return this;
        }

        public final void setNumberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
        }

        public final FileSystemSize.Builder getSizeInBytes() {
            return this.sizeInBytes != null ? this.sizeInBytes.toBuilder() : null;
        }

        @Override
        public final Builder sizeInBytes(FileSystemSize sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(FileSystemSize.BuilderImpl sizeInBytes) {
            this.sizeInBytes = sizeInBytes != null ? sizeInBytes.build() : null;
        }

        public final String getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode == null ? null : performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getThroughputMode() {
            return this.throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        public final Double getProvisionedThroughputInMibps() {
            return this.provisionedThroughputInMibps;
        }

        @Override
        public final Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        public final void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public FileSystemDescription build() {
            return new FileSystemDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSystemDescription> {
        public Builder ownerId(String var1);

        public Builder creationToken(String var1);

        public Builder fileSystemId(String var1);

        public Builder fileSystemArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lifeCycleState(String var1);

        public Builder lifeCycleState(LifeCycleState var1);

        public Builder name(String var1);

        public Builder numberOfMountTargets(Integer var1);

        public Builder sizeInBytes(FileSystemSize var1);

        default public Builder sizeInBytes(Consumer<FileSystemSize.Builder> sizeInBytes) {
            return this.sizeInBytes((FileSystemSize)((FileSystemSize.Builder)FileSystemSize.builder().applyMutation(sizeInBytes)).build());
        }

        public Builder performanceMode(String var1);

        public Builder performanceMode(PerformanceMode var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder throughputMode(String var1);

        public Builder throughputMode(ThroughputMode var1);

        public Builder provisionedThroughputInMibps(Double var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

